/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.collection.closabledictionary.OClosableItem;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.fs.OFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OFileClassic
implements OFile,
OClosableItem {
    public static final String NAME = "classic";
    private static final int CURRENT_VERSION = 2;
    public static final int HEADER_SIZE = 1024;
    public static final int VERSION_OFFSET = 48;
    private static final int SIZE_OFFSET = 52;
    private static final int OPEN_RETRY_MAX = 10;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile Path osFile;
    private FileChannel channel;
    private volatile boolean dirty = false;
    private volatile boolean headerDirty = false;
    private int version;
    private volatile long size;
    private static final ConcurrentHashMap<Path, FileUser> openedFilesMap = new ConcurrentHashMap();
    private final boolean exclusiveFileAccess = OGlobalConfiguration.STORAGE_EXCLUSIVE_FILE_ACCESS.getValueAsBoolean();
    private final boolean trackFileOpen = OGlobalConfiguration.STORAGE_TRACK_FILE_ACCESS.getValueAsBoolean();

    public OFileClassic(Path osFile) {
        this.osFile = osFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long allocateSpace(long size) throws IOException {
        this.acquireWriteLock();
        try {
            long currentSize = this.size;
            this.size += size;
            assert (this.size >= size);
            this.setSize(this.size);
            this.channel.truncate(this.size + 1024L);
            long l = currentSize;
            return l;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shrink(long size) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    this.channel.truncate(1024L + size);
                    this.size = size;
                    this.setSize(this.size);
                    assert (this.size >= 0L);
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during file shrink for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    @Override
    public long getFileSize() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long offset, byte[] iData, int iLength, int iArrayOffset) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireReadLock();
                try {
                    offset = this.checkRegions(offset, iLength);
                    ByteBuffer buffer = ByteBuffer.wrap(iData, iArrayOffset, iLength);
                    OIOUtils.readByteBuffer(buffer, this.channel, offset, true);
                }
                finally {
                    this.releaseReadLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during data read for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long offset, ByteBuffer buffer, boolean throwOnEof) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireReadLock();
                try {
                    offset = this.checkRegions(offset, buffer.limit());
                    OIOUtils.readByteBuffer(buffer, this.channel, offset, throwOnEof);
                }
                finally {
                    this.releaseReadLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during data read for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(long offset, ByteBuffer[] buffers, boolean throwOnEof) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    this.channel.position(offset += 1024L);
                    OIOUtils.readByteBuffers(buffers, this.channel, buffers.length * buffers[0].limit(), throwOnEof);
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during data read for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long offset, ByteBuffer buffer) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    OIOUtils.writeByteBuffer(buffer, this.channel, offset += 1024L);
                    this.setDirty();
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during data write for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long offset, ByteBuffer[] buffers) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    this.channel.position(offset += 1024L);
                    OIOUtils.writeByteBuffers(buffers, this.channel, buffers.length * buffers[0].limit());
                    this.setDirty();
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during data write for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long iOffset, byte[] iData, int iSize, int iArrayOffset) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    this.writeInternal(iOffset, iData, iSize, iArrayOffset);
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during data write for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    private void writeInternal(long offset, byte[] data, int size, int arrayOffset) throws IOException {
        if (data != null) {
            ByteBuffer byteBuffer = ByteBuffer.wrap(data, arrayOffset, size);
            OIOUtils.writeByteBuffer(byteBuffer, this.channel, offset += 1024L);
            this.setDirty();
        }
    }

    @Override
    public void read(long iOffset, byte[] iDestBuffer, int iLength) throws IOException {
        this.read(iOffset, iDestBuffer, iLength, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt(long iOffset) throws IOException {
        int attempts = 0;
        while (true) {
            this.acquireReadLock();
            try {
                iOffset = this.checkRegions(iOffset, 4L);
                int n = this.readData(iOffset, 4).getInt();
                this.releaseReadLock();
                ++attempts;
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.releaseReadLock();
                    ++attempts;
                    throw throwable;
                }
                catch (IOException e) {
                    OLogManager.instance().error(this, "Error during read of int data for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                    this.reopenFile(attempts, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLong(long iOffset) throws IOException {
        int attempts = 0;
        while (true) {
            this.acquireReadLock();
            try {
                iOffset = this.checkRegions(iOffset, 8L);
                long l = this.readData(iOffset, 8).getLong();
                this.releaseReadLock();
                ++attempts;
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.releaseReadLock();
                    ++attempts;
                    throw throwable;
                }
                catch (IOException e) {
                    OLogManager.instance().error(this, "Error during read of long data for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                    this.reopenFile(attempts, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeInt(long iOffset, int iValue) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(4);
                    buffer.putInt(iValue);
                    this.writeBuffer(buffer, iOffset += 1024L);
                    this.setDirty();
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during write of int data for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLong(long iOffset, long iValue) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(8);
                    buffer.putLong(iValue);
                    this.writeBuffer(buffer, iOffset += 1024L);
                    this.setDirty();
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during write of long data for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeByte(long iOffset, byte iValue) throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    ByteBuffer buffer = ByteBuffer.allocate(1);
                    buffer.put(iValue);
                    this.writeBuffer(buffer, iOffset += 1024L);
                    this.setDirty();
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during write of byte data for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(long iOffset, byte[] iSourceBuffer) throws IOException {
        int attempts = 0;
        block5: while (true) {
            try {
                while (true) {
                    this.acquireWriteLock();
                    try {
                        if (iSourceBuffer == null) continue;
                        this.writeInternal(iOffset, iSourceBuffer, iSourceBuffer.length, 0);
                        break block5;
                    }
                    finally {
                        this.releaseWriteLock();
                        ++attempts;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error(this, "Error during write of data for file '" + this.getName() + "' " + attempts + "-th attempt", e, new Object[0]);
                this.reopenFile(attempts, e);
                continue;
            }
            break;
        }
    }

    @Override
    public void synch() {
        this.acquireWriteLock();
        try {
            this.flushHeader();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void flushHeader() {
        this.acquireWriteLock();
        try {
            if (this.headerDirty || this.dirty) {
                this.dirty = false;
                this.headerDirty = false;
                try {
                    this.channel.force(false);
                }
                catch (IOException e) {
                    OLogManager.instance().warn((Object)this, "Error during flush of file %s. Data may be lost in case of power failure", this.getName(), e);
                }
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void create() throws IOException {
        this.acquireWriteLock();
        try {
            this.acquireExclusiveAccess();
            this.openChannel();
            this.init();
            this.setVersion(2);
            this.version = 2;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkRegions(long iOffset, long iLength) {
        this.acquireReadLock();
        try {
            if (iOffset < 0L || iOffset + iLength > this.size) {
                throw new OIOException("You cannot access outside the file size (" + this.size + " bytes). You have requested portion " + iOffset + "-" + (iOffset + iLength) + " bytes. File: " + this.toString());
            }
            long l = iOffset + 1024L;
            return l;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private ByteBuffer readData(long iOffset, int iSize) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(iSize);
        OIOUtils.readByteBuffer(buffer, this.channel, iOffset, true);
        buffer.rewind();
        return buffer;
    }

    private void writeBuffer(ByteBuffer buffer, long offset) throws IOException {
        buffer.rewind();
        OIOUtils.writeByteBuffer(buffer, this.channel, offset);
    }

    private void setVersion(int version) throws IOException {
        this.acquireWriteLock();
        try {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)version);
            this.writeBuffer(buffer, 48L);
            this.setHeaderDirty();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void setSize(long size) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(size);
        this.writeBuffer(buffer, 52L);
        this.setHeaderDirty();
    }

    private long getSize() throws IOException {
        if (this.channel.size() == 0L) {
            return 0L;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        OIOUtils.readByteBuffer(buffer, this.channel, 52L, true);
        return buffer.getLong(0);
    }

    @Override
    public void open() {
        this.acquireWriteLock();
        try {
            if (!Files.exists(this.osFile, new LinkOption[0])) {
                throw new FileNotFoundException("File: " + this.osFile);
            }
            this.acquireExclusiveAccess();
            this.openChannel();
            this.init();
            OLogManager.instance().debug((Object)this, "Checking file integrity of " + this.osFile.getFileName() + "...", new Object[0]);
            if (this.version < 2) {
                this.setVersion(2);
                this.version = 2;
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OIOException("Error during file open"), e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void acquireExclusiveAccess() {
        block14: {
            FileUser newFileUser;
            FileUser fileUser;
            if (!this.exclusiveFileAccess) break block14;
            do {
                int usersCount;
                if ((usersCount = (fileUser = openedFilesMap.computeIfAbsent(this.osFile.toAbsolutePath(), p -> {
                    if (this.trackFileOpen) {
                        return new FileUser(0, Thread.currentThread().getStackTrace());
                    }
                    return new FileUser(0, null);
                })).users) > 0) {
                    if (!this.trackFileOpen) {
                        throw new IllegalStateException("File is allowed to be opened only once, to get more information start JVM with system property " + OGlobalConfiguration.STORAGE_TRACK_FILE_ACCESS.getKey() + " set to true.");
                    }
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    Throwable throwable = null;
                    try {
                        try {
                            pw.append("File is allowed to be opened only once.\n");
                            if (fileUser.openStackTrace != null) {
                                pw.append("File is already opened under: \n");
                                pw.append("----------------------------------------------------------------------------------------------------\n");
                                for (StackTraceElement se : fileUser.openStackTrace) {
                                    pw.append("\t").append(se.toString()).append("\n");
                                }
                                pw.append("----------------------------------------------------------------------------------------------------\n");
                            }
                            pw.flush();
                            throw new IllegalStateException(sw.toString());
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (pw != null) {
                            if (throwable != null) {
                                try {
                                    pw.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                pw.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                newFileUser = new FileUser(1, Thread.currentThread().getStackTrace());
            } while (!openedFilesMap.replace(this.osFile.toAbsolutePath(), fileUser, newFileUser));
        }
    }

    private void releaseExclusiveAccess() {
        block1: {
            FileUser newFileUser;
            FileUser fileUser;
            if (!this.exclusiveFileAccess) break block1;
            do {
                fileUser = openedFilesMap.get(this.osFile.toAbsolutePath());
                newFileUser = this.trackFileOpen ? new FileUser(fileUser.users - 1, Thread.currentThread().getStackTrace()) : new FileUser(fileUser.users - 1, null);
            } while (!openedFilesMap.replace(this.osFile.toAbsolutePath(), fileUser, newFileUser));
        }
    }

    @Override
    public void close() {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    if (this.channel != null && this.channel.isOpen()) {
                        this.channel.close();
                        this.channel = null;
                    }
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
                this.releaseExclusiveAccess();
                break;
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Error during closing of file '" + this.getName() + "' " + attempts + "-th attempt", ioe, new Object[0]);
                try {
                    this.reopenFile(attempts, ioe);
                }
                catch (IOException e) {
                    throw OException.wrapException(new OIOException("Error during file close"), e);
                }
            }
        }
    }

    @Override
    public void delete() throws IOException {
        int attempts = 0;
        while (true) {
            try {
                this.acquireWriteLock();
                try {
                    this.close();
                    if (this.osFile != null) {
                        Files.deleteIfExists(this.osFile);
                    }
                }
                finally {
                    this.releaseWriteLock();
                    ++attempts;
                }
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Error during deletion of file '" + this.getName() + "' " + attempts + "-th attempt", ioe, new Object[0]);
                this.reopenFile(attempts, ioe);
                continue;
            }
            break;
        }
    }

    private void openChannel() throws IOException {
        this.acquireWriteLock();
        try {
            for (int i = 0; i < 10; ++i) {
                try {
                    this.channel = FileChannel.open(this.osFile, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
                    break;
                }
                catch (FileNotFoundException e) {
                    if (i == 9) {
                        throw e;
                    }
                    Files.createDirectories(this.osFile.getParent(), new FileAttribute[0]);
                    continue;
                }
            }
            if (this.channel == null) {
                throw new FileNotFoundException(this.osFile.toString());
            }
            if (this.channel.size() == 0L) {
                ByteBuffer buffer = ByteBuffer.allocate(1024);
                OIOUtils.writeByteBuffer(buffer, this.channel, 0L);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void init() throws IOException {
        this.size = this.getSize();
        if (this.size == 0L) {
            this.size = this.channel.size() - 1024L;
        }
        assert (this.size >= 0L);
        ByteBuffer buffer = ByteBuffer.allocate(1);
        this.channel.read(buffer, 48L);
        buffer.position(0);
        this.version = buffer.get();
    }

    @Override
    public boolean isOpen() {
        this.acquireReadLock();
        try {
            boolean bl = this.channel != null;
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public boolean exists() {
        this.acquireReadLock();
        try {
            boolean bl = this.osFile != null && Files.exists(this.osFile, new LinkOption[0]);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void setDirty() {
        this.acquireWriteLock();
        try {
            if (!this.dirty) {
                this.dirty = true;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void setHeaderDirty() {
        this.acquireWriteLock();
        try {
            if (!this.headerDirty) {
                this.headerDirty = true;
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public String getName() {
        this.acquireReadLock();
        try {
            if (this.osFile == null) {
                String string = null;
                return string;
            }
            String string = this.osFile.getFileName().toString();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public String getPath() {
        this.acquireReadLock();
        try {
            String string = this.osFile.toString();
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void renameTo(Path newFile) throws IOException {
        this.acquireWriteLock();
        try {
            this.close();
            this.osFile = Files.move(this.osFile, newFile, new CopyOption[0]);
            this.open();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public void replaceContentWith(Path newContentFile) throws IOException {
        this.acquireWriteLock();
        try {
            this.close();
            Files.copy(newContentFile, this.osFile, StandardCopyOption.REPLACE_EXISTING);
            this.open();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void acquireWriteLock() {
        this.lock.writeLock().lock();
    }

    private void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    private void acquireReadLock() {
        this.lock.readLock().lock();
    }

    private void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("File: ");
        builder.append(this.osFile.getFileName());
        if (this.channel != null) {
            builder.append(" os-size=");
            try {
                builder.append(this.channel.size());
            }
            catch (IOException ignore) {
                builder.append("?");
            }
        }
        builder.append(", stored=");
        builder.append(this.getFileSize());
        builder.append("");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reopenFile(int attempt, IOException e) throws IOException {
        if (attempt > 1 && e != null) {
            throw e;
        }
        this.acquireWriteLock();
        try {
            try {
                this.channel.close();
            }
            catch (IOException ioe) {
                OLogManager.instance().error(this, "Error during channel close for file '" + this.osFile + "', during IO exception handling", ioe, new Object[0]);
            }
            this.channel = null;
            this.openChannel();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private static final class FileUser {
        private final int users;
        private final StackTraceElement[] openStackTrace;

        FileUser(int users, StackTraceElement[] openStackTrace) {
            this.users = users;
            this.openStackTrace = openStackTrace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileUser fileUser = (FileUser)o;
            return this.users == fileUser.users && Arrays.equals(this.openStackTrace, fileUser.openStackTrace);
        }

        public int hashCode() {
            int result = Objects.hash(this.users);
            result = 31 * result + Arrays.hashCode(this.openStackTrace);
            return result;
        }
    }
}

