/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.cache.local;

import com.orientechnologies.common.collection.closabledictionary.OClosableEntry;
import com.orientechnologies.common.collection.closabledictionary.OClosableLinkedContainer;
import com.orientechnologies.common.concur.lock.OInterruptedException;
import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OPartitionedLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.thread.OScheduledThreadPoolExecutorWithLogging;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.common.util.OTriple;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OWriteCacheException;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.OChecksumMode;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.cache.OAbstractWriteCache;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.cache.OPageDataVerificationError;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.cache.local.OBackgroundExceptionListener;
import com.orientechnologies.orient.core.storage.fs.OFileClassic;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceInformation;
import com.orientechnologies.orient.core.storage.impl.local.OLowDiskSpaceListener;
import com.orientechnologies.orient.core.storage.impl.local.OPageIsBrokenListener;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.zip.CRC32;

public class OWOWCache
extends OAbstractWriteCache
implements OWriteCache,
OCachePointer.WritersListener {
    private static final long WAL_SIZE_TO_START_FLUSH = OGlobalConfiguration.DISK_CACHE_WAL_SIZE_TO_START_FLUSH.getValueAsLong();
    private static final long WAL_SIZE_TO_STOP_FLUSH = OGlobalConfiguration.DISK_CACHE_WAL_SIZE_TO_STOP_FLUSH.getValueAsLong();
    private static final double EXCLUSIVE_PAGES_BOUNDARY = OGlobalConfiguration.DISK_CACHE_EXCLUSIVE_PAGES_BOUNDARY.getValueAsFloat();
    private static final int MAX_CHUNK_DISTANCE = OGlobalConfiguration.DISK_CACHE_CHUNK_SIZE.getValueAsInteger();
    private static final double EXCLUSIVE_BOUNDARY_UNLOCK_LIMIT = OGlobalConfiguration.DISK_CACHE_EXCLUSIVE_FLUSH_BOUNDARY.getValueAsFloat();
    private static final long WAL_SEGMENT_SIZE = (long)OGlobalConfiguration.WAL_MAX_SEGMENT_SIZE.getValueAsInteger() * 1024L * 1024L;
    private static final int CHUNK_SIZE = 32;
    public static final String NAME_ID_MAP_EXTENSION = ".cm";
    private static final String NAME_ID_MAP_V1 = "name_id_map.cm";
    private static final String NAME_ID_MAP_V2 = "name_id_map_v2.cm";
    private static final String NAME_ID_MAP_V2_T = "name_id_map_v2_t.cm";
    private static final int MIN_CACHE_SIZE = 16;
    public static final long MAGIC_NUMBER_WITH_CHECKSUM = 4207608830L;
    private static final long MAGIC_NUMBER_WITHOUT_CHECKSUM = 4012948655L;
    private static final int MAGIC_NUMBER_OFFSET = 0;
    private static final int CHECKSUM_OFFSET = 8;
    private static final int PAGE_OFFSET_TO_CHECKSUM_FROM = 12;
    private final long freeSpaceLimit = OGlobalConfiguration.DISK_CACHE_FREE_SPACE_LIMIT.getValueAsLong() * 1024L * 1024L;
    private final int diskSizeCheckInterval = OGlobalConfiguration.DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES.getValueAsInteger();
    private final int backgroundFlushInterval = OGlobalConfiguration.DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL.getValueAsInteger() * 1000 * 1000;
    private final List<WeakReference<OLowDiskSpaceListener>> lowDiskSpaceListeners = new CopyOnWriteArrayList<WeakReference<OLowDiskSpaceListener>>();
    private final List<WeakReference<OPageIsBrokenListener>> pageIsBrokenListeners = new CopyOnWriteArrayList<WeakReference<OPageIsBrokenListener>>();
    private final AtomicLong lastDiskSpaceCheck = new AtomicLong(0L);
    private final Path storagePath;
    private final OClosableLinkedContainer<Long, OFileClassic> files;
    private final ConcurrentSkipListMap<PageKey, OCachePointer> writeCachePages = new ConcurrentSkipListMap();
    private final ConcurrentSkipListSet<PageKey> exclusiveWritePages = new ConcurrentSkipListSet();
    private final OReadersWriterSpinLock dirtyPagesLock = new OReadersWriterSpinLock();
    private final ConcurrentHashMap<PageKey, OLogSequenceNumber> dirtyPages = new ConcurrentHashMap();
    private final HashMap<PageKey, OLogSequenceNumber> localDirtyPages = new HashMap();
    private final TreeMap<OLogSequenceNumber, Set<PageKey>> localDirtyPagesByLSN = new TreeMap();
    private final AtomicLong countOfNotFlushedPages = new AtomicLong();
    private final AtomicLong amountOfNewPagesAdded = new AtomicLong();
    private final LongAdder writeCacheSize = new LongAdder();
    private final AtomicLong exclusiveWriteCacheSize = new AtomicLong();
    private final LongAdder cacheOverflowCount = new LongAdder();
    private final OBinarySerializer<String> stringSerializer;
    private final int pageSize;
    private final OWriteAheadLog writeAheadLog;
    private final OLockManager<PageKey> lockManager = new OPartitionedLockManager<PageKey>();
    private final AtomicReference<CountDownLatch> exclusivePagesLimitLatch = new AtomicReference();
    private final OLocalPaginatedStorage storageLocal;
    private final OReadersWriterSpinLock filesLock = new OReadersWriterSpinLock();
    private final OScheduledThreadPoolExecutorWithLogging commitExecutor;
    private final ExecutorService cacheEventsPublisher;
    private final ConcurrentMap<String, Integer> nameIdMap = new ConcurrentHashMap<String, Integer>();
    private final ConcurrentMap<Integer, String> idNameMap = new ConcurrentHashMap<Integer, String>();
    private FileChannel nameIdMapHolder;
    private final int exclusiveWriteCacheMaxSize;
    private int nextInternalId = 1;
    private Path nameIdMapHolderPath;
    private final int id;
    private final OPerformanceStatisticManager performanceStatisticManager;
    private final OByteBufferPool bufferPool;
    private volatile OChecksumMode checksumMode;
    private FLUSH_MODE flushMode = FLUSH_MODE.IDLE;
    private Throwable flushError;
    private final List<WeakReference<OBackgroundExceptionListener>> backgroundExceptionListeners = new CopyOnWriteArrayList<WeakReference<OBackgroundExceptionListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWOWCache(int pageSize, OByteBufferPool bufferPool, OWriteAheadLog writeAheadLog, long pageFlushInterval, long exclusiveWriteCacheMaxSize, OLocalPaginatedStorage storageLocal, boolean checkMinSize, OClosableLinkedContainer<Long, OFileClassic> files, int id, OChecksumMode checksumMode) {
        this.filesLock.acquireWriteLock();
        try {
            this.id = id;
            this.files = files;
            this.pageSize = pageSize;
            this.writeAheadLog = writeAheadLog;
            this.bufferPool = bufferPool;
            this.checksumMode = checksumMode;
            int exclusiveWriteNormalizedSize = this.normalizeMemory(exclusiveWriteCacheMaxSize, pageSize);
            if (checkMinSize && exclusiveWriteNormalizedSize < 16) {
                exclusiveWriteNormalizedSize = 16;
            }
            this.exclusiveWriteCacheMaxSize = exclusiveWriteNormalizedSize;
            this.storageLocal = storageLocal;
            this.storagePath = storageLocal.getStoragePath();
            this.performanceStatisticManager = storageLocal.getPerformanceStatisticManager();
            OBinarySerializerFactory binarySerializerFactory = storageLocal.getComponentsFactory().binarySerializerFactory;
            this.stringSerializer = binarySerializerFactory.getObjectSerializer(OType.STRING);
            this.commitExecutor = new OScheduledThreadPoolExecutorWithLogging(1, new FlushThreadFactory(storageLocal.getName()));
            this.commitExecutor.setMaximumPoolSize(1);
            this.cacheEventsPublisher = new OThreadPoolExecutorWithLogging(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new CacheEventsPublisherFactory(storageLocal.getName()));
            if (pageFlushInterval > 0L) {
                this.commitExecutor.scheduleWithFixedDelay(new PeriodicFlushTask(), pageFlushInterval, pageFlushInterval, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    public void loadRegisteredFiles() throws IOException, InterruptedException {
        this.filesLock.acquireWriteLock();
        try {
            this.initNameIdMapping();
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public void addBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        this.backgroundExceptionListeners.add(new WeakReference<OBackgroundExceptionListener>(listener));
    }

    @Override
    public void removeBackgroundExceptionListener(OBackgroundExceptionListener listener) {
        ArrayList<WeakReference<OBackgroundExceptionListener>> itemsToRemove = new ArrayList<WeakReference<OBackgroundExceptionListener>>();
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener l = (OBackgroundExceptionListener)ref.get();
            if (l == null || !l.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.backgroundExceptionListeners.removeAll(itemsToRemove);
    }

    private void fireBackgroundDataFlushExceptionEvent(Throwable e) {
        for (WeakReference<OBackgroundExceptionListener> ref : this.backgroundExceptionListeners) {
            OBackgroundExceptionListener listener = (OBackgroundExceptionListener)ref.get();
            if (listener == null) continue;
            listener.onException(e);
        }
    }

    private int normalizeMemory(long maxSize, int pageSize) {
        long tmpMaxSize = maxSize / (long)pageSize;
        if (tmpMaxSize >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)tmpMaxSize;
    }

    @Override
    public Path getRootDirectory() {
        return this.storagePath;
    }

    @Override
    public OPerformanceStatisticManager getPerformanceStatisticManager() {
        return this.performanceStatisticManager;
    }

    @Override
    public void addLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        this.lowDiskSpaceListeners.add(new WeakReference<OLowDiskSpaceListener>(listener));
    }

    @Override
    public void addPageIsBrokenListener(OPageIsBrokenListener listener) {
        this.pageIsBrokenListeners.add(new WeakReference<OPageIsBrokenListener>(listener));
    }

    @Override
    public void removePageIsBrokenListener(OPageIsBrokenListener listener) {
        ArrayList<WeakReference<OPageIsBrokenListener>> itemsToRemove = new ArrayList<WeakReference<OPageIsBrokenListener>>();
        for (WeakReference<OPageIsBrokenListener> ref : this.pageIsBrokenListeners) {
            OPageIsBrokenListener pageIsBrokenListener = (OPageIsBrokenListener)ref.get();
            if (pageIsBrokenListener != null && !pageIsBrokenListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.pageIsBrokenListeners.removeAll(itemsToRemove);
    }

    @Override
    public void removeLowDiskSpaceListener(OLowDiskSpaceListener listener) {
        ArrayList<WeakReference<OLowDiskSpaceListener>> itemsToRemove = new ArrayList<WeakReference<OLowDiskSpaceListener>>();
        for (WeakReference<OLowDiskSpaceListener> ref : this.lowDiskSpaceListeners) {
            OLowDiskSpaceListener lowDiskSpaceListener = (OLowDiskSpaceListener)ref.get();
            if (lowDiskSpaceListener != null && !lowDiskSpaceListener.equals(listener)) continue;
            itemsToRemove.add(ref);
        }
        this.lowDiskSpaceListeners.removeAll(itemsToRemove);
    }

    private void freeSpaceCheckAfterNewPageAdd(int pagesAdded) throws IOException {
        long lastSpaceCheck;
        long newPagesAdded = this.amountOfNewPagesAdded.addAndGet(pagesAdded);
        if (newPagesAdded - (lastSpaceCheck = this.lastDiskSpaceCheck.get()) > (long)this.diskSizeCheckInterval || lastSpaceCheck == 0L) {
            long notFlushedSpace;
            long freeSpace = Files.getFileStore(this.storagePath).getUsableSpace();
            if (freeSpace - (notFlushedSpace = this.countOfNotFlushedPages.get() * (long)this.pageSize) < this.freeSpaceLimit) {
                this.callLowSpaceListeners(new OLowDiskSpaceInformation(freeSpace, this.freeSpaceLimit));
            }
            this.lastDiskSpaceCheck.lazySet(newPagesAdded);
        }
    }

    private void callLowSpaceListeners(final OLowDiskSpaceInformation information) {
        this.cacheEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference lowDiskSpaceListenerWeakReference : OWOWCache.this.lowDiskSpaceListeners) {
                    OLowDiskSpaceListener listener = (OLowDiskSpaceListener)lowDiskSpaceListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.lowDiskSpace(information);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during notification of low disk space for storage " + OWOWCache.this.storageLocal.getName(), e, new Object[0]);
                    }
                }
            }
        });
    }

    private void callPageIsBrokenListeners(final String fileName, final long pageIndex) {
        this.cacheEventsPublisher.execute(new Runnable(){

            @Override
            public void run() {
                for (WeakReference pageIsBrokenListenerWeakReference : OWOWCache.this.pageIsBrokenListeners) {
                    OPageIsBrokenListener listener = (OPageIsBrokenListener)pageIsBrokenListenerWeakReference.get();
                    if (listener == null) continue;
                    try {
                        listener.pageIsBroken(fileName, pageIndex);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error during notification of page is broken for storage " + OWOWCache.this.storageLocal.getName(), e, new Object[0]);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bookFileId(String fileName) {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null) {
                if (fileId < 0) {
                    long l = OWOWCache.composeFileId(this.id, -fileId.intValue());
                    return l;
                }
                throw new OStorageException("File " + fileName + " has already been added to the storage");
            }
            ++this.nextInternalId;
            long l = OWOWCache.composeFileId(this.id, this.nextInternalId);
            return l;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public boolean fileIdsAreEqual(long firsId, long secondId) {
        int secondIntId;
        int firstIntId = OWOWCache.extractFileId(firsId);
        return firstIntId == (secondIntId = OWOWCache.extractFileId(secondId));
    }

    @Override
    public long loadFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                long externalId = OWOWCache.composeFileId(this.id, fileId);
                OFileClassic fileClassic = this.files.get(externalId);
                if (fileClassic != null) {
                    long l = externalId;
                    return l;
                }
                throw new OStorageException("File with given name " + fileName + " only partially registered in storage");
            }
            if (fileId == null) {
                ++this.nextInternalId;
                fileId = this.nextInternalId;
            } else {
                fileId = -fileId.intValue();
            }
            OFileClassic fileClassic = this.createFileInstance(fileName, fileId);
            if (!fileClassic.exists()) {
                throw new OStorageException("File with name " + fileName + " does not exist in storage " + this.storageLocal.getName());
            }
            OLogManager.instance().debug((Object)this, "File '" + fileName + "' is not registered in 'file name - id' map, but exists in file system. Registering it", new Object[0]);
            this.openFile(fileClassic);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.idNameMap.put(fileId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId, fileClassic.getName()), true);
            long l = externalId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Load file was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long addFile(String fileName) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer fileId = (Integer)this.nameIdMap.get(fileName);
            if (fileId != null && fileId >= 0) {
                throw new OStorageException("File with name " + fileName + " already exists in storage " + this.storageLocal.getName());
            }
            if (fileId == null) {
                ++this.nextInternalId;
                fileId = this.nextInternalId;
            } else {
                fileId = -fileId.intValue();
            }
            OFileClassic fileClassic = this.createFileInstance(fileName, fileId);
            this.createFile(fileClassic);
            long externalId = OWOWCache.composeFileId(this.id, fileId);
            this.files.add(externalId, fileClassic);
            this.nameIdMap.put(fileName, fileId);
            this.idNameMap.put(fileId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, fileId, fileClassic.getName()), true);
            long l = externalId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File add was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public long fileIdByName(String fileName) {
        Integer intId = (Integer)this.nameIdMap.get(fileName);
        if (intId == null || intId < 0) {
            return -1L;
        }
        return OWOWCache.composeFileId(this.id, intId);
    }

    @Override
    public int internalFileId(long fileId) {
        return OWOWCache.extractFileId(fileId);
    }

    @Override
    public long externalFileId(int fileId) {
        return OWOWCache.composeFileId(this.id, fileId);
    }

    @Override
    public OLogSequenceNumber getMinimalNotFlushedLSN() {
        Future<OLogSequenceNumber> future = this.commitExecutor.submit(new FindMinDirtyLSN());
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDirtyPagesTable(OCachePointer pointer) {
        if (this.writeAheadLog == null) {
            return;
        }
        long fileId = pointer.getFileId();
        long pageIndex = pointer.getPageIndex();
        PageKey pageKey = new PageKey(this.internalFileId(fileId), pageIndex);
        OLogSequenceNumber dirtyLSN = this.writeAheadLog.end();
        if (dirtyLSN == null) {
            dirtyLSN = new OLogSequenceNumber(0L, 0L);
        }
        this.dirtyPagesLock.acquireReadLock();
        try {
            this.dirtyPages.putIfAbsent(pageKey, dirtyLSN);
        }
        finally {
            this.dirtyPagesLock.releaseReadLock();
        }
    }

    @Override
    public long addFile(String fileName, long fileId) throws IOException {
        this.filesLock.acquireWriteLock();
        try {
            Integer existingFileId = (Integer)this.nameIdMap.get(fileName);
            int intId = OWOWCache.extractFileId(fileId);
            if (existingFileId != null && existingFileId >= 0) {
                if (existingFileId == intId) {
                    throw new OStorageException("File with name '" + fileName + "'' already exists in storage '" + this.storageLocal.getName() + "'");
                }
                throw new OStorageException("File with given name '" + fileName + "' already exists but has different id " + existingFileId + " vs. proposed " + fileId);
            }
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFileClassic fileClassic = this.files.get(fileId);
            if (fileClassic != null) {
                if (!fileClassic.getName().equals(this.createInternalFileName(fileName, intId))) {
                    throw new OStorageException("File with given id exists but has different name " + fileClassic.getName() + " vs. proposed " + fileName);
                }
            } else {
                if (this.nextInternalId < intId) {
                    this.nextInternalId = intId;
                }
                fileClassic = this.createFileInstance(fileName, intId);
                this.createFile(fileClassic);
                this.files.add(fileId, fileClassic);
            }
            this.nameIdMap.put(fileName, intId);
            this.idNameMap.put(intId, fileName);
            this.writeNameIdEntry(new NameFileIdEntry(fileName, intId, fileClassic.getName()), true);
            long l = fileId;
            return l;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File add was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    @Override
    public boolean checkLowDiskSpace() throws IOException {
        long notFlushedSpace;
        long freeSpace = Files.getFileStore(this.storagePath).getUsableSpace();
        return freeSpace - (notFlushedSpace = this.countOfNotFlushedPages.get() * (long)this.pageSize) < this.freeSpaceLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeFuzzyCheckpoint(long segmentId) throws IOException {
        if (this.writeAheadLog != null) {
            this.filesLock.acquireReadLock();
            try {
                OLogSequenceNumber startLSN = this.writeAheadLog.begin(segmentId);
                if (startLSN == null) {
                    return;
                }
                this.writeAheadLog.logFuzzyCheckPointStart(startLSN);
                for (Integer intId : this.nameIdMap.values()) {
                    if (intId < 0) continue;
                    long fileId = OWOWCache.composeFileId(this.id, intId);
                    OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
                    try {
                        OFileClassic fileClassic = entry.get();
                        fileClassic.synch();
                    }
                    finally {
                        this.files.release(entry);
                    }
                }
                this.writeAheadLog.logFuzzyCheckPointEnd();
                this.writeAheadLog.flush();
                this.writeAheadLog.cutAllSegmentsSmallerThan(segmentId);
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OStorageException("Fuzzy checkpoint was interrupted"), e);
            }
            finally {
                this.filesLock.releaseReadLock();
            }
        }
    }

    @Override
    public void flushTillSegment(long segmentId) {
        Future<Void> future = this.commitExecutor.submit(new FlushTillSegmentTask(segmentId));
        try {
            future.get();
        }
        catch (Exception e) {
            throw ODatabaseException.wrapException(new OStorageException("Error during data flush"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String fileName) {
        this.filesLock.acquireReadLock();
        try {
            Integer intId;
            if (this.nameIdMap != null && (intId = (Integer)this.nameIdMap.get(fileName)) != null && intId >= 0) {
                OFileClassic fileClassic = this.files.get(this.externalFileId(intId));
                if (fileClassic == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = fileClassic.exists();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(long fileId) {
        this.filesLock.acquireReadLock();
        try {
            int intId = OWOWCache.extractFileId(fileId);
            fileId = OWOWCache.composeFileId(this.id, intId);
            OFileClassic file = this.files.get(fileId);
            if (file == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = file.exists();
            return bl;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CountDownLatch store(long fileId, long pageIndex, OCachePointer dataPointer) {
        CountDownLatch latch;
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireReadLock();
        try {
            PageKey pageKey = new PageKey(intId, pageIndex);
            Lock groupLock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                OCachePointer pagePointer = this.writeCachePages.get(pageKey);
                if (pagePointer == null) {
                    this.doPutInCache(dataPointer, pageKey);
                } else assert (pagePointer.equals(dataPointer));
            }
            finally {
                groupLock.unlock();
            }
            latch = this.exclusivePagesLimitLatch.get();
            if (latch != null) {
                CountDownLatch countDownLatch = latch;
                return countDownLatch;
            }
            if (this.exclusiveWriteCacheSize.get() > (long)this.exclusiveWriteCacheMaxSize) {
                this.cacheOverflowCount.increment();
                latch = new CountDownLatch(1);
                if (!this.exclusivePagesLimitLatch.compareAndSet(null, latch)) {
                    latch = this.exclusivePagesLimitLatch.get();
                }
                this.commitExecutor.submit(new PeriodicFlushTask());
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
        return latch;
    }

    private void doPutInCache(OCachePointer dataPointer, PageKey pageKey) {
        this.writeCachePages.put(pageKey, dataPointer);
        this.writeCacheSize.increment();
        dataPointer.setWritersListener(this);
        dataPointer.incrementWritersReferrer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Long> files() {
        this.filesLock.acquireReadLock();
        try {
            HashMap result = new HashMap();
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                result.put(entry.getKey(), OWOWCache.composeFileId(this.id, (Integer)entry.getValue()));
            }
            HashMap hashMap = result;
            return hashMap;
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OCachePointer[] load(long fileId, long startPageIndex, int pageCount, boolean addNewPages, OModifiableBoolean cacheHit, boolean verifyChecksums) throws IOException {
        intId = OWOWCache.extractFileId(fileId);
        if (pageCount < 1) {
            throw new IllegalArgumentException("Amount of pages to load should be not less than 1 but provided value is " + pageCount);
        }
        this.filesLock.acquireReadLock();
        try {
            block40: {
                block39: {
                    startPageKey = new PageKey(intId, startPageIndex);
                    startPageLock = this.lockManager.acquireSharedLock(startPageKey);
                    startPagePointer = this.writeCachePages.get(startPageKey);
                    if (startPagePointer != null) ** GOTO lbl94
                    if (pageCount > 1) {
                        startPageLock.unlock();
                        pageKeys = new PageKey[pageCount];
                        for (i = 0; i < pageCount; ++i) {
                            pageKeys[i] = new PageKey(intId, startPageIndex + (long)i);
                        }
                        pageLocks = this.lockManager.acquireSharedLocksInBatch((PageKey[])pageKeys);
                    } else {
                        pageLocks = new Lock[]{startPageLock};
                        pageKeys = new PageKey[]{startPageKey};
                    }
                    pagePointers = this.loadFileContent(intId, startPageIndex, pageCount, verifyChecksums);
                    if (pagePointers == null) break block39;
                    if (pagePointers.length == 0) {
                        var16_17 = pagePointers;
                        return var16_17;
                    }
                    break block40;
                    finally {
                        var17_21 = pageLocks;
                        var18_25 = var17_21.length;
                        var19_29 = 0;
                        while (true) {
                            if (var19_29 >= var18_25) {
                            }
                            pageLock = var17_21[var19_29];
                            pageLock.unlock();
                            ++var19_29;
                        }
                    }
                }
                if (!addNewPages) {
                    n = new OCachePointer[]{};
                    return n;
                }
                entry = this.files.acquire(fileId);
                try {
                    fileClassic = entry.get();
                    startAllocationIndex = fileClassic.getFileSize() / (long)this.pageSize;
                    stopAllocationIndex = startPageIndex;
                    allocationPageKeys = new PageKey[(int)(stopAllocationIndex - startAllocationIndex + 1L)];
                    for (pageIndex = startAllocationIndex; pageIndex <= stopAllocationIndex; ++pageIndex) {
                        index = (int)(pageIndex - startAllocationIndex);
                        allocationPageKeys[index] = new PageKey(intId, pageIndex);
                    }
                    locks = this.lockManager.acquireExclusiveLocksInBatch((PageKey[])allocationPageKeys);
                    try {
                        fileSize = fileClassic.getFileSize();
                        spaceToAllocate = (stopAllocationIndex + 1L) * (long)this.pageSize - fileSize;
                        resultPointer = null;
                        if (spaceToAllocate > 0L) {
                            fileClassic.allocateSpace(spaceToAllocate);
                            for (index = startAllocationIndex = fileSize / (long)this.pageSize; index <= stopAllocationIndex; ++index) {
                                buffer = this.bufferPool.acquireDirect(true);
                                buffer.putLong(0, 4012948655L);
                                cachePointer = new OCachePointer(buffer, this.bufferPool, fileId, index);
                                cachePointer.setNotFlushed(true);
                                this.countOfNotFlushedPages.incrementAndGet();
                                this.exclusiveWriteCacheSize.getAndIncrement();
                                this.doPutInCache(cachePointer, new PageKey(intId, index));
                                if (index != startPageIndex) continue;
                                resultPointer = cachePointer;
                            }
                            this.freeSpaceCheckAfterNewPageAdd((int)(stopAllocationIndex - startAllocationIndex + 1L));
                        }
                        if (resultPointer != null) {
                            resultPointer.incrementReadersReferrer();
                            cacheHit.setValue(true);
                            var29_50 = new OCachePointer[]{resultPointer};
                            return var29_50;
                        }
                    }
                    finally {
                        var30_55 = locks;
                        var31_52 = var30_55.length;
                        var32_54 = 0;
                        while (var32_54 < var31_52) {
                            lock = var30_55[var32_54];
                            lock.unlock();
                            ++var32_54;
                        }
                        return var29_50;
                    }
                }
                finally {
                    this.files.release(entry);
                }
lbl94:
                // 1 sources

                startPagePointer.incrementReadersReferrer();
                startPageLock.unlock();
                cacheHit.setValue(true);
                var13_16 = new OCachePointer[]{startPagePointer};
                return var13_16;
            }
            n = 0;
            while (true) {
                if (n >= pagePointers.length) {
                    n = pagePointers;
                    return n;
                }
                pagePointers[n].incrementReadersReferrer();
                if (n > 0) {
                    pagePointer /* !! */  = this.writeCachePages.get(pageKeys[n]);
                    if (!OWOWCache.$assertionsDisabled && PageKey.access$900(pageKeys[n]) != pagePointers[n].getPageIndex()) {
                        throw new AssertionError();
                    }
                    if (pagePointer /* !! */  != null) {
                        pagePointers[n].decrementReadersReferrer();
                        pagePointers[n] = pagePointer /* !! */ ;
                        pagePointers[n].incrementReadersReferrer();
                    }
                }
                ++n;
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Load was interrupted"), e);
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public void addOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.incrementAndGet();
        this.exclusiveWritePages.add(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void removeOnlyWriters(long fileId, long pageIndex) {
        this.exclusiveWriteCacheSize.decrementAndGet();
        this.exclusiveWritePages.remove(new PageKey(OWOWCache.extractFileId(fileId), pageIndex));
    }

    @Override
    public void flush(long fileId) {
        Future<Void> future = this.commitExecutor.submit(new FileFlushTask(OWOWCache.extractFileId(fileId)));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw OException.wrapException(new OInterruptedException("File flush was interrupted"), e);
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File flush was abnormally terminated"), e);
        }
    }

    @Override
    public void flush() {
        Iterator iterator = this.nameIdMap.values().iterator();
        while (iterator.hasNext()) {
            int intId = (Integer)iterator.next();
            if (intId < 0) continue;
            this.flush(intId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilledUpTo(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireReadLock();
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                long l = entry.get().getFileSize() / (long)this.pageSize;
                this.files.release(entry);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.files.release(entry);
                    throw throwable;
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OStorageException("Calculation of file size was interrupted"), e);
                }
            }
        }
        finally {
            this.filesLock.releaseReadLock();
        }
    }

    @Override
    public long getExclusiveWriteCachePagesSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            String fileName = this.doDeleteFile(intId);
            if (fileName != null) {
                String name = (String)this.idNameMap.get(intId);
                this.nameIdMap.put(name, -intId);
                this.idNameMap.remove(intId);
                this.writeNameIdEntry(new NameFileIdEntry(name, -intId, fileName), true);
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void truncateFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            this.removeCachedPages(intId);
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                entry.get().shrink(0L);
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File truncation was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceFileContentWith(long fileId, Path newContentFile) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            this.removeCachedPages(intId);
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                entry.get().replaceContentWith(newContentFile);
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("File content replacement was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(long fileId, String newFileName) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            String oldOsFileName;
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            if (entry == null) {
                return;
            }
            String newOsFileName = this.createInternalFileName(newFileName, intId);
            try {
                OFileClassic file = entry.get();
                oldOsFileName = file.getName();
                Path newFile = this.storagePath.resolve(newOsFileName);
                file.renameTo(newFile);
            }
            finally {
                this.files.release(entry);
            }
            String oldFileName = (String)this.idNameMap.get(intId);
            this.nameIdMap.remove(oldFileName);
            this.nameIdMap.put(newFileName, intId);
            this.idNameMap.put(intId, newFileName);
            this.writeNameIdEntry(new NameFileIdEntry(oldFileName, -1, oldOsFileName), false);
            this.writeNameIdEntry(new NameFileIdEntry(newFileName, intId, newOsFileName), true);
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Rename of file was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public long[] close() throws IOException {
        this.flush();
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OWriteCacheException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error(this, "Data flush thread was interrupted", e, new Object[0]);
                Thread.interrupted();
                throw OException.wrapException(new OWriteCacheException("Data flush thread was interrupted"), e);
            }
        }
        this.filesLock.acquireWriteLock();
        try {
            Collection fileIds = this.nameIdMap.values();
            ArrayList<Long> closedIds = new ArrayList<Long>();
            HashMap<Integer, String> idFileNameMap = new HashMap<Integer, String>();
            for (Integer n : fileIds) {
                if (n < 0) continue;
                long extId = OWOWCache.composeFileId(this.id, n);
                OFileClassic fileClassic = this.files.remove(extId);
                idFileNameMap.put(n, fileClassic.getName());
                fileClassic.close();
                closedIds.add(extId);
            }
            if (this.nameIdMapHolder != null) {
                this.nameIdMapHolder.truncate(0L);
                for (Map.Entry entry : this.nameIdMap.entrySet()) {
                    String fileName = (Integer)entry.getValue() >= 0 ? (String)idFileNameMap.get(entry.getValue()) : (String)entry.getKey();
                    this.writeNameIdEntry(new NameFileIdEntry((String)entry.getKey(), (Integer)entry.getValue(), fileName), false);
                }
                this.nameIdMapHolder.force(true);
                this.nameIdMapHolder.close();
            }
            this.nameIdMap.clear();
            this.idNameMap.clear();
            long[] ids = new long[closedIds.size()];
            boolean bl = false;
            Object object = closedIds.iterator();
            while (object.hasNext()) {
                void var5_10;
                long id;
                ids[var5_10] = id = ((Long)object.next()).longValue();
                ++var5_10;
            }
            object = ids;
            return object;
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(long fileId, boolean flush) {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.filesLock.acquireWriteLock();
        try {
            if (flush) {
                this.flush(intId);
            } else {
                this.removeCachedPages(intId);
            }
            if (!this.files.close(fileId)) {
                throw new OStorageException("Can not close file with id " + this.internalFileId(fileId) + " because it is still in use");
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String restoreFileById(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        this.filesLock.acquireWriteLock();
        try {
            for (Map.Entry entry : this.nameIdMap.entrySet()) {
                if ((Integer)entry.getValue() != -intId) continue;
                this.addFile((String)entry.getKey(), fileId);
                String string = (String)entry.getKey();
                return string;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        return null;
    }

    @Override
    public OPageDataVerificationError[] checkStoredPages(OCommandOutputListener commandOutputListener) {
        int notificationTimeOut = 5000;
        ArrayList<OPageDataVerificationError> errors = new ArrayList<OPageDataVerificationError>();
        this.filesLock.acquireWriteLock();
        try {
            for (Integer intId : this.nameIdMap.values()) {
                if (intId < 0) continue;
                this.checkFileStoredPages(commandOutputListener, 5000, errors, intId);
            }
            OPageDataVerificationError[] oPageDataVerificationErrorArray = errors.toArray(new OPageDataVerificationError[errors.size()]);
            return oPageDataVerificationErrorArray;
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Thread was interrupted"), e);
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileStoredPages(OCommandOutputListener commandOutputListener, int notificationTimeOut, List<OPageDataVerificationError> errors, Integer intId) throws InterruptedException {
        boolean fileIsCorrect;
        long externalId = OWOWCache.composeFileId(this.id, intId);
        OClosableEntry<Long, OFileClassic> entry = this.files.acquire(externalId);
        OFileClassic fileClassic = entry.get();
        String fileName = (String)this.idNameMap.get(intId);
        try {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Flashing file " + fileName + "... ");
            }
            this.flush(intId.intValue());
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Start verification of content of " + fileName + "file ...\n");
            }
            long time = System.currentTimeMillis();
            long filledUpTo = fileClassic.getFileSize();
            fileIsCorrect = true;
            for (long pos = 0L; pos < filledUpTo; pos += (long)this.pageSize) {
                boolean checkSumIncorrect = false;
                boolean magicNumberIncorrect = false;
                byte[] data = new byte[this.pageSize];
                fileClassic.read(pos, data, data.length);
                long magicNumber = OLongSerializer.INSTANCE.deserializeNative(data, 0);
                if (magicNumber != 4207608830L && magicNumber != 4012948655L) {
                    magicNumberIncorrect = true;
                    if (commandOutputListener != null) {
                        commandOutputListener.onMessage("Error: Magic number for page " + pos / (long)this.pageSize + " in file '" + fileName + "' does not match!\n");
                    }
                    fileIsCorrect = false;
                }
                if (magicNumber != 4012948655L) {
                    int storedCRC32 = OIntegerSerializer.INSTANCE.deserializeNative(data, 8);
                    CRC32 crc32 = new CRC32();
                    crc32.update(data, 12, data.length - 12);
                    int calculatedCRC32 = (int)crc32.getValue();
                    if (storedCRC32 != calculatedCRC32) {
                        checkSumIncorrect = true;
                        if (commandOutputListener != null) {
                            commandOutputListener.onMessage("Error: Checksum for page " + pos / (long)this.pageSize + " in file '" + fileName + "' is incorrect!\n");
                        }
                        fileIsCorrect = false;
                    }
                }
                if (magicNumberIncorrect || checkSumIncorrect) {
                    errors.add(new OPageDataVerificationError(magicNumberIncorrect, checkSumIncorrect, pos / (long)this.pageSize, fileName));
                }
                if (commandOutputListener == null || System.currentTimeMillis() - time <= (long)notificationTimeOut) continue;
                time = notificationTimeOut;
                commandOutputListener.onMessage(pos / (long)this.pageSize + " pages were processed...\n");
            }
        }
        catch (IOException ioe) {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Error: Error during processing of file '" + fileName + "'. " + ioe.getMessage() + "\n");
            }
            fileIsCorrect = false;
        }
        finally {
            this.files.release(entry);
        }
        if (!fileIsCorrect) {
            if (commandOutputListener != null) {
                commandOutputListener.onMessage("Verification of file '" + fileName + "' is finished with errors.\n");
            }
        } else if (commandOutputListener != null) {
            commandOutputListener.onMessage("Verification of file '" + fileName + "' is successfully finished.\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] delete() throws IOException {
        ArrayList<Long> result = new ArrayList<Long>();
        this.filesLock.acquireWriteLock();
        try {
            Iterator iterator = this.nameIdMap.values().iterator();
            while (iterator.hasNext()) {
                int intId = (Integer)iterator.next();
                if (intId < 0) continue;
                long externalId = OWOWCache.composeFileId(this.id, intId);
                this.doDeleteFile(externalId);
                result.add(externalId);
            }
            if (this.nameIdMapHolderPath != null) {
                if (Files.exists(this.nameIdMapHolderPath, new LinkOption[0])) {
                    this.nameIdMapHolder.close();
                    Files.delete(this.nameIdMapHolderPath);
                }
                this.nameIdMapHolder = null;
                this.nameIdMapHolderPath = null;
            }
        }
        finally {
            this.filesLock.releaseWriteLock();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(5L, TimeUnit.MINUTES)) {
                    throw new OWriteCacheException("Background data flush task cannot be stopped.");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error(this, "Data flush thread was interrupted", e, new Object[0]);
                Thread.interrupted();
                throw OException.wrapException(new OInterruptedException("Data flush thread was interrupted"), e);
            }
        }
        long[] fIds = new long[result.size()];
        int n = 0;
        for (Long fid : result) {
            fIds[n] = fid;
            ++n;
        }
        return fIds;
    }

    @Override
    public String fileNameById(long fileId) {
        int intId = OWOWCache.extractFileId(fileId);
        return (String)this.idNameMap.get(intId);
    }

    @Override
    public String nativeFileNameById(long fileId) {
        OFileClassic fileClassic = this.files.get(fileId);
        if (fileClassic != null) {
            return fileClassic.getName();
        }
        return null;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public long getCacheOverflowCount() {
        return this.cacheOverflowCount.sum();
    }

    public long getWriteCacheSize() {
        return this.writeCacheSize.sum();
    }

    public long getExclusiveWriteCacheSize() {
        return this.exclusiveWriteCacheSize.get();
    }

    private void openFile(OFileClassic fileClassic) {
        if (fileClassic.exists()) {
            if (!fileClassic.isOpen()) {
                fileClassic.open();
            }
        } else {
            throw new OStorageException("File " + fileClassic + " does not exist.");
        }
    }

    private void createFile(OFileClassic fileClassic) throws IOException {
        if (fileClassic.exists()) {
            throw new OStorageException("File '" + fileClassic.getName() + "' already exists.");
        }
        fileClassic.create();
        fileClassic.synch();
    }

    private void initNameIdMapping() throws IOException, InterruptedException {
        if (this.nameIdMapHolder == null) {
            Path storagePath = this.storageLocal.getStoragePath();
            if (!Files.exists(storagePath, new LinkOption[0])) {
                Files.createDirectories(storagePath, new FileAttribute[0]);
            }
            Path nameIdMapHolderV1 = storagePath.resolve(NAME_ID_MAP_V1);
            Path nameIdMapHolderV2 = storagePath.resolve(NAME_ID_MAP_V2);
            if (Files.exists(nameIdMapHolderV1, new LinkOption[0])) {
                if (Files.exists(nameIdMapHolderV2, new LinkOption[0])) {
                    Files.delete(nameIdMapHolderV2);
                }
                this.nameIdMapHolderPath = nameIdMapHolderV1;
                this.nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.READ);
                this.readNameIdMapV1();
                this.convertNameIdMapFromV1ToV2();
                this.nameIdMapHolder.close();
                this.nameIdMapHolderPath = storagePath.resolve(NAME_ID_MAP_V2);
                Files.delete(nameIdMapHolderV1);
                this.nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.READ, StandardOpenOption.WRITE);
            } else {
                this.nameIdMapHolderPath = storagePath.resolve(NAME_ID_MAP_V2);
                this.nameIdMapHolder = FileChannel.open(this.nameIdMapHolderPath, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.CREATE);
                this.readNameIdMapV2();
            }
        }
    }

    private void convertNameIdMapFromV1ToV2() throws IOException {
        Path nameIdMapHolderFileV2T = this.storagePath.resolve(NAME_ID_MAP_V2_T);
        if (Files.exists(nameIdMapHolderFileV2T, new LinkOption[0])) {
            Files.delete(nameIdMapHolderFileV2T);
        }
        FileChannel v2NameIdMapHolder = FileChannel.open(nameIdMapHolderFileV2T, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            if ((Integer)nameIdEntry.getValue() >= 0) {
                OFileClassic fileClassic = this.files.get(this.externalFileId((Integer)nameIdEntry.getValue()));
                String fileSystemName = fileClassic.getName();
                NameFileIdEntry nameFileIdEntry = new NameFileIdEntry((String)nameIdEntry.getKey(), (Integer)nameIdEntry.getValue(), fileSystemName);
                this.writeNameIdEntry(v2NameIdMapHolder, nameFileIdEntry, false);
                continue;
            }
            NameFileIdEntry nameFileIdEntry = new NameFileIdEntry((String)nameIdEntry.getKey(), (Integer)nameIdEntry.getValue(), "");
            this.writeNameIdEntry(v2NameIdMapHolder, nameFileIdEntry, false);
        }
        v2NameIdMapHolder.force(true);
        v2NameIdMapHolder.close();
        Files.move(nameIdMapHolderFileV2T, this.storagePath.resolve(NAME_ID_MAP_V2), new CopyOption[0]);
    }

    private OFileClassic createFileInstance(String fileName, int fileId) {
        String internalFileName = this.createInternalFileName(fileName, fileId);
        return new OFileClassic(this.storagePath.resolve(internalFileName));
    }

    private String createInternalFileName(String fileName, int fileId) {
        int extSeparator = fileName.lastIndexOf(".");
        String prefix = extSeparator < 0 ? fileName : (extSeparator == 0 ? "" : fileName.substring(0, extSeparator));
        String suffix = extSeparator < 0 || extSeparator == fileName.length() - 1 ? "" : fileName.substring(extSeparator + 1);
        prefix = prefix + "_" + fileId;
        if (extSeparator >= 0) {
            return prefix + "." + suffix;
        }
        return prefix;
    }

    private void readNameIdMapV2() throws IOException, InterruptedException {
        NameFileIdEntry nameFileIdEntry;
        this.nameIdMap.clear();
        long localFileCounter = -1L;
        this.nameIdMapHolder.position(0L);
        HashMap<Integer, String> idFileNameMap = new HashMap<Integer, String>();
        while ((nameFileIdEntry = this.readNextNameIdEntryV2()) != null) {
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
            if (nameFileIdEntry.fileId >= 0) {
                this.idNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.name);
            }
            idFileNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.fileSystemName);
        }
        if (localFileCounter > 0L && (long)this.nextInternalId < localFileCounter) {
            this.nextInternalId = (int)localFileCounter;
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            long externalId;
            int fileId = (Integer)nameIdEntry.getValue();
            if (fileId < 0 || this.files.get(externalId = OWOWCache.composeFileId(this.id, (Integer)nameIdEntry.getValue())) != null) continue;
            String path = this.storageLocal.getVariableParser().resolveVariables(this.storageLocal.getStoragePath() + File.separator + (String)idFileNameMap.get(nameIdEntry.getValue()));
            OFileClassic fileClassic = new OFileClassic(Paths.get(path, new String[0]));
            if (fileClassic.exists()) {
                fileClassic.open();
                this.files.add(externalId, fileClassic);
                continue;
            }
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId);
            this.idNameMap.remove(fileId);
        }
    }

    private void readNameIdMapV1() throws IOException, InterruptedException {
        Set<String> files;
        NameFileIdEntry nameFileIdEntry;
        HashMap<Integer, HashSet<String>> filesWithNegativeIds = new HashMap<Integer, HashSet<String>>();
        this.nameIdMap.clear();
        long localFileCounter = -1L;
        this.nameIdMapHolder.position(0L);
        while ((nameFileIdEntry = this.readNextNameIdEntryV1()) != null) {
            Integer existingId;
            long absFileId = Math.abs(nameFileIdEntry.fileId);
            if (localFileCounter < absFileId) {
                localFileCounter = absFileId;
            }
            if ((existingId = (Integer)this.nameIdMap.get(nameFileIdEntry.name)) != null && existingId < 0 && (files = (HashSet<String>)filesWithNegativeIds.get(existingId)) != null) {
                files.remove(nameFileIdEntry.name);
                if (files.isEmpty()) {
                    filesWithNegativeIds.remove(existingId);
                }
            }
            if (nameFileIdEntry.fileId < 0) {
                files = (Set)filesWithNegativeIds.get(nameFileIdEntry.fileId);
                if (files == null) {
                    files = new HashSet<String>();
                    files.add(nameFileIdEntry.name);
                    filesWithNegativeIds.put(nameFileIdEntry.fileId, (HashSet<String>)files);
                } else {
                    files.add(nameFileIdEntry.name);
                }
            }
            this.nameIdMap.put(nameFileIdEntry.name, nameFileIdEntry.fileId);
            this.idNameMap.put(nameFileIdEntry.fileId, nameFileIdEntry.name);
        }
        if (localFileCounter > 0L && (long)this.nextInternalId < localFileCounter) {
            this.nextInternalId = (int)localFileCounter;
        }
        for (Map.Entry nameIdEntry : this.nameIdMap.entrySet()) {
            long externalId;
            if ((Integer)nameIdEntry.getValue() < 0 || this.files.get(externalId = OWOWCache.composeFileId(this.id, (Integer)nameIdEntry.getValue())) != null) continue;
            OFileClassic fileClassic = new OFileClassic(this.storagePath.resolve((String)nameIdEntry.getKey()));
            if (fileClassic.exists()) {
                fileClassic.open();
                this.files.add(externalId, fileClassic);
                continue;
            }
            Integer fileId = (Integer)this.nameIdMap.get(nameIdEntry.getKey());
            if (fileId == null || fileId <= 0) continue;
            this.nameIdMap.put((String)nameIdEntry.getKey(), -fileId.intValue());
            this.idNameMap.remove(fileId);
            this.idNameMap.put(-fileId.intValue(), (String)nameIdEntry.getKey());
        }
        HashSet<String> fixedFiles = new HashSet<String>();
        for (Map.Entry entry : filesWithNegativeIds.entrySet()) {
            files = (Set)entry.getValue();
            if (files.size() <= 1) continue;
            this.idNameMap.remove(entry.getKey());
            for (String fileName : files) {
                ++this.nextInternalId;
                int nextId = -this.nextInternalId;
                this.nameIdMap.put(fileName, nextId);
                this.idNameMap.put(nextId, fileName);
                fixedFiles.add(fileName);
            }
        }
        if (!fixedFiles.isEmpty()) {
            OLogManager.instance().warn((Object)this, "Removed files " + fixedFiles + " had duplicated ids. Problem is fixed automatically.", new Object[0]);
        }
    }

    private NameFileIdEntry readNextNameIdEntryV1() throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(4);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            int nameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(nameSize + 8);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            String name = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            int fileId = (int)buffer.getLong();
            return new NameFileIdEntry(name, fileId);
        }
        catch (EOFException ignore) {
            return null;
        }
    }

    private NameFileIdEntry readNextNameIdEntryV2() throws IOException {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(8);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            int fileId = buffer.getInt();
            int nameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(nameSize);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            String name = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            buffer = ByteBuffer.allocate(4);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            int fileNameSize = buffer.getInt();
            buffer = ByteBuffer.allocate(fileNameSize);
            OIOUtils.readByteBuffer(buffer, this.nameIdMapHolder);
            buffer.rewind();
            String fileName = this.stringSerializer.deserializeFromByteBufferObject(buffer);
            return new NameFileIdEntry(name, fileId, fileName);
        }
        catch (EOFException ignore) {
            return null;
        }
    }

    private void writeNameIdEntry(NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        this.writeNameIdEntry(this.nameIdMapHolder, nameFileIdEntry, sync);
    }

    private void writeNameIdEntry(FileChannel nameIdMapHolder, NameFileIdEntry nameFileIdEntry, boolean sync) throws IOException {
        int nameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.name, new Object[0]);
        int fileNameSize = this.stringSerializer.getObjectSize(nameFileIdEntry.fileSystemName, new Object[0]);
        ByteBuffer serializedRecord = ByteBuffer.allocate(12 + nameSize + fileNameSize);
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(nameFileIdEntry.fileId, serializedRecord, new Object[]{0});
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(nameSize, serializedRecord, new Object[]{4});
        this.stringSerializer.serializeInByteBufferObject(nameFileIdEntry.name, serializedRecord, 8);
        OIntegerSerializer.INSTANCE.serializeInByteBufferObject(fileNameSize, serializedRecord, new Object[]{8 + nameSize});
        this.stringSerializer.serializeInByteBufferObject(nameFileIdEntry.fileSystemName, serializedRecord, 12 + nameSize);
        serializedRecord.position(0);
        OIOUtils.writeByteBuffer(serializedRecord, nameIdMapHolder, nameIdMapHolder.size());
        nameIdMapHolder.write(serializedRecord);
        if (sync) {
            nameIdMapHolder.force(true);
        }
    }

    private String doDeleteFile(long fileId) throws IOException {
        int intId = OWOWCache.extractFileId(fileId);
        fileId = OWOWCache.composeFileId(this.id, intId);
        this.removeCachedPages(intId);
        OFileClassic fileClassic = this.files.remove(fileId);
        String name = null;
        if (fileClassic != null) {
            name = fileClassic.getName();
            if (fileClassic.exists()) {
                fileClassic.delete();
            }
        }
        return name;
    }

    private void removeCachedPages(int fileId) {
        if (this.commitExecutor.isShutdown()) {
            return;
        }
        Future<Void> future = this.commitExecutor.submit(new RemoveFilePagesTask(fileId));
        try {
            future.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw OException.wrapException(new OInterruptedException("File data removal was interrupted"), e);
        }
        catch (Exception e) {
            throw OException.wrapException(new OWriteCacheException("File data removal was abnormally terminated"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OCachePointer[] loadFileContent(int intId, long startPageIndex, int pageCount, boolean verifyChecksums) throws IOException {
        long fileId = OWOWCache.composeFileId(this.id, intId);
        try {
            OClosableEntry<Long, OFileClassic> entry = this.files.acquire(fileId);
            try {
                OFileClassic fileClassic = entry.get();
                if (fileClassic == null) {
                    throw new IllegalArgumentException("File with id " + intId + " not found in WOW Cache");
                }
                long firstPageStartPosition = startPageIndex * (long)this.pageSize;
                long firstPageEndPosition = firstPageStartPosition + (long)this.pageSize;
                if (fileClassic.getFileSize() >= firstPageEndPosition) {
                    OSessionStoragePerformanceStatistic sessionStoragePerformanceStatistic = this.performanceStatisticManager.getSessionPerformanceStatistic();
                    if (sessionStoragePerformanceStatistic != null) {
                        sessionStoragePerformanceStatistic.startPageReadFromFileTimer();
                    }
                    int pagesRead = 0;
                    try {
                        int i;
                        if (pageCount == 1) {
                            ByteBuffer buffer = this.bufferPool.acquireDirect(false);
                            assert (buffer.position() == 0);
                            fileClassic.read(firstPageStartPosition, buffer, false);
                            if (verifyChecksums && (this.checksumMode == OChecksumMode.StoreAndVerify || this.checksumMode == OChecksumMode.StoreAndThrow || this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode)) {
                                this.verifyMagicAndChecksum(buffer, fileId, startPageIndex, null);
                            }
                            buffer.position(0);
                            OCachePointer dataPointer = new OCachePointer(buffer, this.bufferPool, fileId, startPageIndex);
                            pagesRead = 1;
                            OCachePointer[] oCachePointerArray = new OCachePointer[]{dataPointer};
                            return oCachePointerArray;
                        }
                        long maxPageCount = (fileClassic.getFileSize() - firstPageStartPosition) / (long)this.pageSize;
                        int realPageCount = Math.min((int)maxPageCount, pageCount);
                        ByteBuffer[] buffers = new ByteBuffer[realPageCount];
                        for (i = 0; i < buffers.length; ++i) {
                            buffers[i] = this.bufferPool.acquireDirect(false);
                            assert (buffers[i].position() == 0);
                        }
                        fileClassic.read(firstPageStartPosition, buffers, false);
                        if (verifyChecksums && (this.checksumMode == OChecksumMode.StoreAndVerify || this.checksumMode == OChecksumMode.StoreAndThrow || this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode)) {
                            for (i = 0; i < buffers.length; ++i) {
                                this.verifyMagicAndChecksum(buffers[i], fileId, startPageIndex + (long)i, buffers);
                            }
                        }
                        OCachePointer[] dataPointers = new OCachePointer[buffers.length];
                        for (int n = 0; n < buffers.length; ++n) {
                            buffers[n].position(0);
                            dataPointers[n] = new OCachePointer(buffers[n], this.bufferPool, fileId, startPageIndex + (long)n);
                        }
                        pagesRead = dataPointers.length;
                        OCachePointer[] oCachePointerArray = dataPointers;
                        return oCachePointerArray;
                    }
                    finally {
                        if (sessionStoragePerformanceStatistic != null) {
                            sessionStoragePerformanceStatistic.stopPageReadFromFileTimer(pagesRead);
                        }
                    }
                }
                OCachePointer[] oCachePointerArray = null;
                return oCachePointerArray;
            }
            finally {
                this.files.release(entry);
            }
        }
        catch (InterruptedException e) {
            throw OException.wrapException(new OStorageException("Data load was interrupted"), e);
        }
    }

    private void addMagicAndChecksum(ByteBuffer buffer) {
        assert (buffer.order() == ByteOrder.nativeOrder());
        buffer.position(0);
        OLongSerializer.INSTANCE.serializeInByteBufferObject(this.checksumMode == OChecksumMode.Off ? 4012948655L : 4207608830L, buffer, new Object[0]);
        if (this.checksumMode != OChecksumMode.Off) {
            buffer.position(12);
            CRC32 crc32 = new CRC32();
            crc32.update(buffer);
            int computedChecksum = (int)crc32.getValue();
            buffer.position(8);
            OIntegerSerializer.INSTANCE.serializeInByteBufferObject(computedChecksum, buffer, new Object[0]);
        }
    }

    private void verifyMagicAndChecksum(ByteBuffer buffer, long fileId, long pageIndex, ByteBuffer[] buffersToRelease) {
        assert (buffer.order() == ByteOrder.nativeOrder());
        buffer.position(0);
        long magicNumber = OLongSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        if (magicNumber != 4207608830L) {
            if (magicNumber != 4012948655L) {
                String message = "Magic number verification failed for page `" + pageIndex + "` of `" + this.fileNameById(fileId) + "`.";
                OLogManager.instance().error(this, "%s", null, message);
                if (this.checksumMode == OChecksumMode.StoreAndThrow) {
                    if (buffersToRelease == null) {
                        this.bufferPool.release(buffer);
                    } else {
                        for (ByteBuffer bufferToRelease : buffersToRelease) {
                            this.bufferPool.release(bufferToRelease);
                        }
                    }
                    throw new OStorageException(message);
                }
                if (this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode) {
                    this.callPageIsBrokenListeners(this.fileNameById(fileId), pageIndex);
                }
            }
            return;
        }
        buffer.position(8);
        int storedChecksum = OIntegerSerializer.INSTANCE.deserializeFromByteBufferObject(buffer);
        buffer.position(12);
        CRC32 crc32 = new CRC32();
        crc32.update(buffer);
        int computedChecksum = (int)crc32.getValue();
        if (computedChecksum != storedChecksum) {
            String message = "Checksum verification failed for page `" + pageIndex + "` of `" + this.fileNameById(fileId) + "`.";
            OLogManager.instance().error(this, "%s", null, message);
            if (this.checksumMode == OChecksumMode.StoreAndThrow) {
                if (buffersToRelease == null) {
                    this.bufferPool.release(buffer);
                } else {
                    for (ByteBuffer bufferToRelease : buffersToRelease) {
                        this.bufferPool.release(bufferToRelease);
                    }
                }
                throw new OStorageException(message);
            }
            if (this.checksumMode == OChecksumMode.StoreAndSwitchReadOnlyMode) {
                this.callPageIsBrokenListeners(this.fileNameById(fileId), pageIndex);
            }
        }
    }

    private void flushWALTillPageLSN(ByteBuffer buffer) {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = ODurablePage.getLogSequenceNumberFromPage(buffer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLsn();
            while (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
                flushedLSN = this.writeAheadLog.getFlushedLsn();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushPage(int fileId, long pageIndex, ByteBuffer buffer) throws IOException, InterruptedException {
        if (this.writeAheadLog != null) {
            OLogSequenceNumber lsn = ODurablePage.getLogSequenceNumberFromPage(buffer);
            OLogSequenceNumber flushedLSN = this.writeAheadLog.getFlushedLsn();
            while (flushedLSN == null || flushedLSN.compareTo(lsn) < 0) {
                this.writeAheadLog.flush();
                flushedLSN = this.writeAheadLog.getFlushedLsn();
            }
        }
        long externalId = OWOWCache.composeFileId(this.id, fileId);
        OClosableEntry<Long, OFileClassic> entry = this.files.acquire(externalId);
        try {
            OFileClassic fileClassic = entry.get();
            this.addMagicAndChecksum(buffer);
            buffer.position(0);
            fileClassic.write(pageIndex * (long)this.pageSize, buffer);
        }
        finally {
            this.files.release(entry);
        }
    }

    public void setChecksumMode(OChecksumMode checksumMode) {
        this.checksumMode = checksumMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertSharedDirtyPagesToLocal() {
        this.dirtyPagesLock.acquireWriteLock();
        try {
            for (Map.Entry<PageKey, OLogSequenceNumber> entry : this.dirtyPages.entrySet()) {
                OLogSequenceNumber localLSN = this.localDirtyPages.get(entry.getKey());
                if (localLSN != null && localLSN.compareTo(entry.getValue()) <= 0) continue;
                this.localDirtyPages.put(entry.getKey(), entry.getValue());
                Set<PageKey> pages = this.localDirtyPagesByLSN.get(entry.getValue());
                if (pages == null) {
                    pages = new HashSet<PageKey>();
                    pages.add(entry.getKey());
                    this.localDirtyPagesByLSN.put(entry.getValue(), pages);
                    continue;
                }
                pages.add(entry.getKey());
            }
            this.dirtyPages.clear();
        }
        finally {
            this.dirtyPagesLock.releaseWriteLock();
        }
    }

    private void removeFromDirtyPages(PageKey pageKey) {
        this.dirtyPages.remove(pageKey);
        OLogSequenceNumber lsn = this.localDirtyPages.remove(pageKey);
        if (lsn != null) {
            Set<PageKey> pages = this.localDirtyPagesByLSN.get(lsn);
            assert (pages != null);
            boolean removed = pages.remove(pageKey);
            if (pages.isEmpty()) {
                this.localDirtyPagesByLSN.remove(lsn);
            }
            assert (removed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flushWriteCacheFromMinLSN() throws IOException, InterruptedException {
        this.convertSharedDirtyPagesToLocal();
        long startTs = System.nanoTime();
        int flushedPages = 0;
        int copiedPages = 0;
        ArrayList<OTriple<Long, ByteBuffer, OCachePointer>> chunk = new ArrayList<OTriple<Long, ByteBuffer, OCachePointer>>(32);
        long endTs = startTs;
        block8: while (endTs - startTs < (long)this.backgroundFlushInterval) {
            Iterator<Map.Entry<PageKey, OCachePointer>> pageIterator;
            long lastFileId = -1L;
            long lastPageIndex = -1L;
            assert (chunk.isEmpty());
            Map.Entry<OLogSequenceNumber, Set<PageKey>> firstMinLSNEntry = this.localDirtyPagesByLSN.firstEntry();
            if (firstMinLSNEntry != null) {
                PageKey minPageKey = firstMinLSNEntry.getValue().iterator().next();
                pageIterator = this.writeCachePages.tailMap((Object)minPageKey).entrySet().iterator();
            } else {
                pageIterator = this.writeCachePages.entrySet().iterator();
            }
            if (!pageIterator.hasNext()) {
                pageIterator = this.writeCachePages.entrySet().iterator();
            }
            if (!pageIterator.hasNext()) {
                flushedPages += this.flushPagesChunk(chunk);
                this.releaseExclusiveLatch();
                break;
            }
            long firstPageIndex = -1L;
            long firstFileId = -1L;
            try {
                while (chunk.size() < 32 && endTs - startTs < (long)this.backgroundFlushInterval) {
                    long version;
                    if (!pageIterator.hasNext()) {
                        flushedPages += this.flushPagesChunk(chunk);
                        this.releaseExclusiveLatch();
                        if (lastFileId != firstFileId || lastPageIndex == -1L || lastPageIndex - firstPageIndex > (long)MAX_CHUNK_DISTANCE) continue block8;
                        endTs = System.nanoTime();
                        pageIterator = this.writeCachePages.entrySet().iterator();
                        if (!pageIterator.hasNext()) break;
                    }
                    Map.Entry<PageKey, OCachePointer> cacheEntry = pageIterator.next();
                    PageKey pageKey = cacheEntry.getKey();
                    if (firstFileId == -1L) {
                        firstFileId = pageKey.fileId;
                        firstPageIndex = pageKey.pageIndex;
                    }
                    ByteBuffer copy = this.bufferPool.acquireDirect(false);
                    OCachePointer pointer = cacheEntry.getValue();
                    pointer.acquireSharedLock();
                    try {
                        version = pointer.getVersion();
                        ByteBuffer buffer = pointer.getBufferDuplicate();
                        buffer.position(0);
                        copy.position(0);
                        copy.put(buffer);
                        this.removeFromDirtyPages(pageKey);
                        ++copiedPages;
                    }
                    finally {
                        pointer.releaseSharedLock();
                    }
                    this.flushWALTillPageLSN(copy);
                    copy.position(0);
                    if (chunk.isEmpty()) {
                        chunk.add(new OTriple<Long, ByteBuffer, OCachePointer>(version, copy, pointer));
                    } else if (lastFileId != pointer.getFileId() || lastPageIndex != pointer.getPageIndex() - 1L) {
                        flushedPages += this.flushPagesChunk(chunk);
                        this.releaseExclusiveLatch();
                        if ((long)pageKey.fileId != firstFileId || pageKey.pageIndex - firstPageIndex > (long)MAX_CHUNK_DISTANCE) {
                            chunk.add(new OTriple<Long, ByteBuffer, OCachePointer>(version, copy, pointer));
                            flushedPages += this.flushPagesChunk(chunk);
                            this.releaseExclusiveLatch();
                            continue block8;
                        }
                        endTs = System.nanoTime();
                        chunk.add(new OTriple<Long, ByteBuffer, OCachePointer>(version, copy, pointer));
                    } else {
                        chunk.add(new OTriple<Long, ByteBuffer, OCachePointer>(version, copy, pointer));
                    }
                    lastFileId = pointer.getFileId();
                    lastPageIndex = pointer.getPageIndex();
                }
                flushedPages += this.flushPagesChunk(chunk);
                this.releaseExclusiveLatch();
            }
            finally {
                endTs = System.nanoTime();
            }
        }
        if (!chunk.isEmpty()) {
            throw new IllegalStateException("Chunk is not empty !");
        }
        if (copiedPages != flushedPages) {
            throw new IllegalStateException("Copied pages (" + copiedPages + " ) != flushed pages (" + flushedPages + ")");
        }
        this.releaseExclusiveLatch();
        return flushedPages;
    }

    private void releaseExclusiveLatch() {
        long ewcSize = this.exclusiveWriteCacheSize.get();
        double exclusiveWriteCacheThreshold = (double)ewcSize / (double)this.exclusiveWriteCacheMaxSize;
        if (exclusiveWriteCacheThreshold <= EXCLUSIVE_BOUNDARY_UNLOCK_LIMIT) {
            CountDownLatch latch = this.exclusivePagesLimitLatch.get();
            if (latch != null) {
                latch.countDown();
            }
            this.exclusivePagesLimitLatch.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flushPagesChunk(ArrayList<OTriple<Long, ByteBuffer, OCachePointer>> chunk) throws IOException, InterruptedException {
        if (chunk.isEmpty()) {
            return 0;
        }
        ByteBuffer[] buffers = new ByteBuffer[chunk.size()];
        for (int i = 0; i < buffers.length; ++i) {
            ByteBuffer buffer = (ByteBuffer)chunk.get(i).getValue().getKey();
            this.addMagicAndChecksum(buffer);
            buffer.position(0);
            buffers[i] = buffer;
        }
        OTriple<Long, ByteBuffer, OCachePointer> firstChunk = chunk.get(0);
        OCachePointer firstCachePointer = firstChunk.getValue().getValue();
        long firstFileId = firstCachePointer.getFileId();
        long firstPageIndex = firstCachePointer.getPageIndex();
        OClosableEntry<Long, OFileClassic> fileEntry = this.files.acquire(firstFileId);
        try {
            ByteBuffer[] file = fileEntry.get();
            file.write(firstPageIndex * (long)this.pageSize, buffers);
        }
        finally {
            this.files.release(fileEntry);
        }
        for (ByteBuffer buffer : buffers) {
            this.bufferPool.release(buffer);
        }
        for (OTriple oTriple : chunk) {
            OCachePointer pointer = (OCachePointer)oTriple.getValue().getValue();
            PageKey pageKey = new PageKey(this.internalFileId(pointer.getFileId()), pointer.getPageIndex());
            long version = (Long)oTriple.getKey();
            Lock lock = this.lockManager.acquireExclusiveLock(pageKey);
            try {
                if (!pointer.tryAcquireSharedLock()) continue;
                try {
                    if (version == pointer.getVersion()) {
                        this.writeCachePages.remove(pageKey);
                        this.writeCacheSize.decrement();
                        pointer.decrementWritersReferrer();
                        pointer.setWritersListener(null);
                    }
                }
                finally {
                    pointer.releaseSharedLock();
                }
                if (!pointer.isNotFlushed()) continue;
                pointer.setNotFlushed(false);
                this.countOfNotFlushedPages.decrementAndGet();
            }
            finally {
                lock.unlock();
            }
        }
        int flushedPages = chunk.size();
        chunk.clear();
        return flushedPages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int flushExclusiveWriteCache() throws IOException, InterruptedException {
        Iterator<PageKey> iterator = this.exclusiveWritePages.iterator();
        int flushedPages = 0;
        int copiedPages = 0;
        long ewcSize = this.exclusiveWriteCacheSize.get();
        double exclusiveWriteCacheThreshold = (double)ewcSize / (double)this.exclusiveWriteCacheMaxSize;
        double flushThreshold = exclusiveWriteCacheThreshold - EXCLUSIVE_PAGES_BOUNDARY;
        long pagesToFlush = Math.max((long)Math.ceil(flushThreshold * (double)this.exclusiveWriteCacheMaxSize), 1L);
        ArrayList<OTriple<Long, ByteBuffer, OCachePointer>> chunk = new ArrayList<OTriple<Long, ByteBuffer, OCachePointer>>(32);
        block3: while ((long)flushedPages < pagesToFlush) {
            long lastFileId = -1L;
            long lastPageIndex = -1L;
            while (chunk.size() < 32 && (long)flushedPages < pagesToFlush) {
                long version;
                if (!iterator.hasNext()) {
                    flushedPages += this.flushPagesChunk(chunk);
                    this.releaseExclusiveLatch();
                    iterator = this.exclusiveWritePages.iterator();
                }
                if (!iterator.hasNext()) {
                    flushedPages += this.flushPagesChunk(chunk);
                    this.releaseExclusiveLatch();
                    break block3;
                }
                PageKey pageKey = iterator.next();
                OCachePointer pointer = this.writeCachePages.get(pageKey);
                if (pointer == null) {
                    iterator.remove();
                    continue;
                }
                pointer.acquireSharedLock();
                ByteBuffer copy = this.bufferPool.acquireDirect(false);
                try {
                    version = pointer.getVersion();
                    ByteBuffer buffer = pointer.getBufferDuplicate();
                    buffer.position(0);
                    copy.position(0);
                    copy.put(buffer);
                    this.removeFromDirtyPages(pageKey);
                    ++copiedPages;
                }
                finally {
                    pointer.releaseSharedLock();
                }
                this.flushWALTillPageLSN(copy);
                copy.position(0);
                if (chunk.isEmpty()) {
                    chunk.add(new OTriple<Long, ByteBuffer, OCachePointer>(version, copy, pointer));
                } else if (lastFileId != pointer.getFileId() || lastPageIndex != pointer.getPageIndex() - 1L) {
                    flushedPages += this.flushPagesChunk(chunk);
                    this.releaseExclusiveLatch();
                    chunk.add(new OTriple<Long, ByteBuffer, OCachePointer>(version, copy, pointer));
                } else {
                    chunk.add(new OTriple<Long, ByteBuffer, OCachePointer>(version, copy, pointer));
                }
                lastFileId = pointer.getFileId();
                lastPageIndex = pointer.getPageIndex();
            }
            flushedPages += this.flushPagesChunk(chunk);
            this.releaseExclusiveLatch();
        }
        this.releaseExclusiveLatch();
        if (!chunk.isEmpty()) {
            throw new IllegalStateException("Chunk is not empty !");
        }
        if (copiedPages != flushedPages) {
            throw new IllegalStateException("Copied pages (" + copiedPages + " ) != flushed pages (" + flushedPages + ")");
        }
        return flushedPages;
    }

    private static enum FLUSH_MODE {
        IDLE,
        LSN,
        EXCLUSIVE;

    }

    private static class CacheEventsPublisherFactory
    implements ThreadFactory {
        private final String storageName;

        private CacheEventsPublisherFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setName("OrientDB Write Cache Event Publisher (" + this.storageName + ")");
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        }
    }

    private static class FlushThreadFactory
    implements ThreadFactory {
        private final String storageName;

        private FlushThreadFactory(String storageName) {
            this.storageName = storageName;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(OStorageAbstract.storageThreadGroup, r);
            thread.setDaemon(true);
            thread.setPriority(10);
            thread.setName("OrientDB Write Cache Flush Task (" + this.storageName + ")");
            thread.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
            return thread;
        }
    }

    private final class RemoveFilePagesTask
    implements Callable<Void> {
        private final int fileId;

        private RemoveFilePagesTask(int fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            PageKey firstKey = new PageKey(this.fileId, 0L);
            PageKey lastKey = new PageKey(this.fileId, Long.MAX_VALUE);
            Iterator entryIterator = OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true).entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                OCachePointer pagePointer = (OCachePointer)entry.getValue();
                PageKey pageKey = (PageKey)entry.getKey();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    pagePointer.acquireExclusiveLock();
                    try {
                        pagePointer.decrementWritersReferrer();
                        pagePointer.setWritersListener(null);
                        OWOWCache.this.writeCacheSize.decrement();
                        OWOWCache.this.removeFromDirtyPages(pageKey);
                    }
                    finally {
                        pagePointer.releaseExclusiveLock();
                    }
                    entryIterator.remove();
                }
                finally {
                    groupLock.unlock();
                }
                if (!pagePointer.isNotFlushed()) continue;
                pagePointer.setNotFlushed(false);
                OWOWCache.this.countOfNotFlushedPages.decrementAndGet();
            }
            return null;
        }
    }

    private final class FileFlushTask
    implements Callable<Void> {
        private final int fileId;

        private FileFlushTask(int fileId) {
            this.fileId = fileId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not flush file data because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            PageKey firstKey = new PageKey(this.fileId, 0L);
            PageKey lastKey = new PageKey(this.fileId, Long.MAX_VALUE);
            Iterator entryIterator = OWOWCache.this.writeCachePages.subMap(firstKey, true, lastKey, true).entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry entry = entryIterator.next();
                PageKey pageKey = (PageKey)entry.getKey();
                OCachePointer pagePointer = (OCachePointer)entry.getValue();
                Lock groupLock = OWOWCache.this.lockManager.acquireExclusiveLock(pageKey);
                try {
                    if (!pagePointer.tryAcquireSharedLock()) continue;
                    try {
                        ByteBuffer buffer = pagePointer.getBufferDuplicate();
                        OWOWCache.this.flushPage(pageKey.fileId, pageKey.pageIndex, buffer);
                        OWOWCache.this.removeFromDirtyPages(pageKey);
                    }
                    finally {
                        pagePointer.releaseSharedLock();
                    }
                    pagePointer.decrementWritersReferrer();
                    pagePointer.setWritersListener(null);
                    entryIterator.remove();
                }
                finally {
                    groupLock.unlock();
                    continue;
                }
                if (pagePointer.isNotFlushed()) {
                    pagePointer.setNotFlushed(false);
                    OWOWCache.this.countOfNotFlushedPages.decrementAndGet();
                }
                OWOWCache.this.writeCacheSize.decrement();
            }
            long finalId = OAbstractWriteCache.composeFileId(OWOWCache.this.id, this.fileId);
            OClosableEntry entry = OWOWCache.this.files.acquire(finalId);
            try {
                ((OFileClassic)entry.get()).synch();
            }
            finally {
                OWOWCache.this.files.release(entry);
            }
            return null;
        }
    }

    final class FindMinDirtyLSN
    implements Callable<OLogSequenceNumber> {
        FindMinDirtyLSN() {
        }

        @Override
        public OLogSequenceNumber call() {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not calculate minimum LSN because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            OWOWCache.this.convertSharedDirtyPagesToLocal();
            if (OWOWCache.this.localDirtyPagesByLSN.isEmpty()) {
                return null;
            }
            return (OLogSequenceNumber)OWOWCache.this.localDirtyPagesByLSN.firstKey();
        }
    }

    private final class PeriodicFlushTask
    implements Runnable {
        private PeriodicFlushTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not flush data because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return;
            }
            OSessionStoragePerformanceStatistic statistic = OWOWCache.this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startWriteCacheFlushTimer();
            }
            int flushedPages = 0;
            try {
                if (OWOWCache.this.writeCachePages.isEmpty()) {
                    return;
                }
                flushedPages = this.flushExclusivePagesIfNeeded(flushedPages);
                if (!OWOWCache.this.flushMode.equals((Object)FLUSH_MODE.EXCLUSIVE)) {
                    if (OWOWCache.this.writeAheadLog != null) {
                        long activeSegment = OWOWCache.this.writeAheadLog.activeSegment();
                        OWOWCache.this.convertSharedDirtyPagesToLocal();
                        Map.Entry lsnEntry = OWOWCache.this.localDirtyPagesByLSN.firstEntry();
                        if (lsnEntry != null) {
                            if (!OWOWCache.this.flushMode.equals((Object)FLUSH_MODE.LSN)) {
                                if ((activeSegment - ((OLogSequenceNumber)lsnEntry.getKey()).getSegment()) * WAL_SEGMENT_SIZE > WAL_SIZE_TO_START_FLUSH) {
                                    OWOWCache.this.flushMode = FLUSH_MODE.LSN;
                                    flushedPages += OWOWCache.this.flushWriteCacheFromMinLSN();
                                    activeSegment = OWOWCache.this.writeAheadLog.activeSegment();
                                    OWOWCache.this.convertSharedDirtyPagesToLocal();
                                    lsnEntry = OWOWCache.this.localDirtyPagesByLSN.firstEntry();
                                    if (lsnEntry == null || (activeSegment - ((OLogSequenceNumber)lsnEntry.getKey()).getSegment()) * WAL_SEGMENT_SIZE <= WAL_SIZE_TO_START_FLUSH) {
                                        OWOWCache.this.flushMode = FLUSH_MODE.IDLE;
                                    }
                                }
                            } else {
                                flushedPages += OWOWCache.this.flushWriteCacheFromMinLSN();
                                activeSegment = OWOWCache.this.writeAheadLog.activeSegment();
                                OWOWCache.this.convertSharedDirtyPagesToLocal();
                                lsnEntry = OWOWCache.this.localDirtyPagesByLSN.firstEntry();
                                if (lsnEntry == null || (activeSegment - ((OLogSequenceNumber)lsnEntry.getKey()).getSegment()) * WAL_SEGMENT_SIZE <= WAL_SIZE_TO_STOP_FLUSH) {
                                    OWOWCache.this.flushMode = FLUSH_MODE.IDLE;
                                }
                            }
                        }
                    } else {
                        flushedPages += OWOWCache.this.flushWriteCacheFromMinLSN();
                    }
                }
            }
            catch (Error | Exception t) {
                OLogManager.instance().error(this, "Exception during data flush", t, new Object[0]);
                OWOWCache.this.fireBackgroundDataFlushExceptionEvent(t);
                OWOWCache.this.flushError = t;
            }
            finally {
                if (statistic != null) {
                    statistic.stopWriteCacheFlushTimer(flushedPages);
                }
            }
        }

        private int flushExclusivePagesIfNeeded(int flushedPages) throws IOException, InterruptedException {
            long ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
            assert (ewcSize >= 0L);
            double exclusiveWriteCacheThreshold = (double)ewcSize / (double)OWOWCache.this.exclusiveWriteCacheMaxSize;
            if (exclusiveWriteCacheThreshold > EXCLUSIVE_PAGES_BOUNDARY) {
                if (!OWOWCache.this.flushMode.equals((Object)FLUSH_MODE.EXCLUSIVE)) {
                    OWOWCache.this.flushMode = FLUSH_MODE.EXCLUSIVE;
                    flushedPages += OWOWCache.this.flushExclusiveWriteCache();
                    ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
                    exclusiveWriteCacheThreshold = (double)ewcSize / (double)OWOWCache.this.exclusiveWriteCacheMaxSize;
                    if (exclusiveWriteCacheThreshold <= EXCLUSIVE_PAGES_BOUNDARY) {
                        OWOWCache.this.flushMode = FLUSH_MODE.IDLE;
                    }
                } else {
                    flushedPages += OWOWCache.this.flushExclusiveWriteCache();
                    ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
                    exclusiveWriteCacheThreshold = (double)ewcSize / (double)OWOWCache.this.exclusiveWriteCacheMaxSize;
                    if (exclusiveWriteCacheThreshold <= EXCLUSIVE_PAGES_BOUNDARY) {
                        OWOWCache.this.flushMode = FLUSH_MODE.IDLE;
                    }
                }
            } else {
                OWOWCache.this.releaseExclusiveLatch();
            }
            return flushedPages;
        }
    }

    private final class FlushTillSegmentTask
    implements Callable<Void> {
        private final long segmentId;

        private FlushTillSegmentTask(long segmentId) {
            this.segmentId = segmentId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            if (OWOWCache.this.flushError != null) {
                OLogManager.instance().errorNoDb(this, "Can not flush data till provided segment because of issue during data write, %s", null, OWOWCache.this.flushError.getMessage());
                return null;
            }
            try {
                OWOWCache.this.convertSharedDirtyPagesToLocal();
                Map.Entry firstEntry = OWOWCache.this.localDirtyPagesByLSN.firstEntry();
                if (firstEntry == null) {
                    Void void_ = null;
                    return void_;
                }
                OLogSequenceNumber minDirtyLSN = (OLogSequenceNumber)firstEntry.getKey();
                while (minDirtyLSN.getSegment() < this.segmentId) {
                    this.flushExclusivePagesIfNeeded();
                    OWOWCache.this.flushWriteCacheFromMinLSN();
                    firstEntry = OWOWCache.this.localDirtyPagesByLSN.firstEntry();
                    if (firstEntry == null) {
                        Void void_ = null;
                        return void_;
                    }
                    minDirtyLSN = (OLogSequenceNumber)firstEntry.getKey();
                }
                Void void_ = null;
                return void_;
            }
            finally {
                OWOWCache.this.flushMode = FLUSH_MODE.IDLE;
            }
        }

        private void flushExclusivePagesIfNeeded() throws IOException, InterruptedException {
            long ewcSize = OWOWCache.this.exclusiveWriteCacheSize.get();
            assert (ewcSize >= 0L);
            double exclusiveWriteCacheThreshold = (double)ewcSize / (double)OWOWCache.this.exclusiveWriteCacheMaxSize;
            if (exclusiveWriteCacheThreshold > EXCLUSIVE_PAGES_BOUNDARY) {
                OWOWCache.this.flushExclusiveWriteCache();
            } else {
                OWOWCache.this.releaseExclusiveLatch();
            }
        }
    }

    private static final class PageKey
    implements Comparable<PageKey> {
        private final int fileId;
        private final long pageIndex;

        private PageKey(int fileId, long pageIndex) {
            this.fileId = fileId;
            this.pageIndex = pageIndex;
        }

        @Override
        public int compareTo(PageKey other) {
            if (this.fileId > other.fileId) {
                return 1;
            }
            if (this.fileId < other.fileId) {
                return -1;
            }
            return Long.compare(this.pageIndex, other.pageIndex);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageKey pageKey = (PageKey)o;
            if (this.fileId != pageKey.fileId) {
                return false;
            }
            return this.pageIndex == pageKey.pageIndex;
        }

        public int hashCode() {
            int result = this.fileId;
            result = 31 * result + (int)(this.pageIndex ^ this.pageIndex >>> 32);
            return result;
        }

        public String toString() {
            return "PageKey{fileId=" + this.fileId + ", pageIndex=" + this.pageIndex + '}';
        }

        public PageKey previous() {
            return this.pageIndex == -1L ? this : new PageKey(this.fileId, this.pageIndex - 1L);
        }
    }

    private static final class NameFileIdEntry {
        private final String name;
        private final int fileId;
        private final String fileSystemName;

        private NameFileIdEntry(String name, int fileId) {
            this.name = name;
            this.fileId = fileId;
            this.fileSystemName = name;
        }

        private NameFileIdEntry(String name, int fileId, String fileSystemName) {
            this.name = name;
            this.fileId = fileId;
            this.fileSystemName = fileSystemName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameFileIdEntry that = (NameFileIdEntry)o;
            if (this.fileId != that.fileId) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.fileSystemName.equals(that.fileSystemName);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.fileId;
            result = 31 * result + this.fileSystemName.hashCode();
            return result;
        }
    }
}

