/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.query;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.sql.query.OBasicLegacyResultSet;
import com.orientechnologies.orient.core.sql.query.OLegacyResultSet;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class OConcurrentLegacyResultSet<T>
implements OLegacyResultSet<T> {
    protected final transient Object waitForNextItem = new Object();
    protected final transient Object waitForCompletion = new Object();
    protected final transient OBasicLegacyResultSet<T> wrapped;
    protected volatile transient boolean completed = false;

    public OConcurrentLegacyResultSet() {
        this.wrapped = new OBasicLegacyResultSet();
    }

    public OConcurrentLegacyResultSet(OBasicLegacyResultSet<T> wrapped) {
        this.wrapped = wrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OConcurrentLegacyResultSet<T> setCompleted() {
        this.completed = true;
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
        object = this.waitForCompletion;
        synchronized (object) {
            this.waitForCompletion.notifyAll();
        }
        return this;
    }

    @Override
    public int getLimit() {
        return this.wrapped.getLimit();
    }

    @Override
    public OLegacyResultSet<T> setLimit(int limit) {
        return this.wrapped.setLimit(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OLegacyResultSet<T> copy() {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            OConcurrentLegacyResultSet<T> copy = new OConcurrentLegacyResultSet<T>(this.wrapped.copy());
            copy.completed = true;
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmptyNoWait() {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, T element) {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            this.wrapped.add(index, element);
        }
        this.notifyNewItem();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator() {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.listIterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator<T> listIterator(int index) {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.listIterator(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.subList(fromIndex, toIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.waitForCompletion();
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int currentSize() {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        boolean empty;
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            empty = this.wrapped.isEmpty();
        }
        if (empty) {
            this.waitForNewItemOrCompleted();
            oBasicLegacyResultSet = this.wrapped;
            synchronized (oBasicLegacyResultSet) {
                empty = this.wrapped.isEmpty();
            }
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        this.waitForCompletion();
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.contains(o);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                int size;
                OBasicLegacyResultSet oBasicLegacyResultSet = OConcurrentLegacyResultSet.this.wrapped;
                synchronized (oBasicLegacyResultSet) {
                    size = OConcurrentLegacyResultSet.this.wrapped.size();
                }
                while (!OConcurrentLegacyResultSet.this.completed) {
                    if (this.index < size) {
                        return true;
                    }
                    OConcurrentLegacyResultSet.this.waitForNewItemOrCompleted();
                    oBasicLegacyResultSet = OConcurrentLegacyResultSet.this.wrapped;
                    synchronized (oBasicLegacyResultSet) {
                        size = OConcurrentLegacyResultSet.this.wrapped.size();
                    }
                }
                return this.index < OConcurrentLegacyResultSet.this.wrapped.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T next() {
                int size;
                OBasicLegacyResultSet oBasicLegacyResultSet = OConcurrentLegacyResultSet.this.wrapped;
                synchronized (oBasicLegacyResultSet) {
                    size = OConcurrentLegacyResultSet.this.wrapped.size();
                }
                while (!OConcurrentLegacyResultSet.this.completed && this.index >= size) {
                    OConcurrentLegacyResultSet.this.waitForNewItemOrCompleted();
                    oBasicLegacyResultSet = OConcurrentLegacyResultSet.this.wrapped;
                    synchronized (oBasicLegacyResultSet) {
                        size = OConcurrentLegacyResultSet.this.wrapped.size();
                    }
                }
                if (this.index > size || size == 0) {
                    throw new NoSuchElementException("Error on browsing at element " + this.index + " while the resultset contains only " + size + " items");
                }
                oBasicLegacyResultSet = OConcurrentLegacyResultSet.this.wrapped;
                synchronized (oBasicLegacyResultSet) {
                    return OConcurrentLegacyResultSet.this.wrapped.get(this.index++);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("OLegacyResultSet.iterator.remove()");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        this.waitForCompletion();
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T1> T1[] toArray(T1[] a) {
        this.waitForCompletion();
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t) {
        boolean result;
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            result = this.wrapped.add(t);
        }
        this.notifyNewItem();
        return result;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result;
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            result = this.wrapped.addAll(c);
        }
        this.notifyNewItem();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result;
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            result = this.wrapped.addAll(index, c);
        }
        this.notifyNewItem();
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            this.wrapped.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            this.wrapped.writeExternal(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            this.wrapped.readExternal(in);
        }
        this.completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        OBasicLegacyResultSet<T> oBasicLegacyResultSet = this.wrapped;
        synchronized (oBasicLegacyResultSet) {
            return this.wrapped.equals(obj);
        }
    }

    public String toString() {
        return "size=" + this.wrapped.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForCompletion() {
        Object object = this.waitForCompletion;
        synchronized (object) {
            if (!this.completed) {
                try {
                    this.waitForCompletion.wait();
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error(this, "Thread was interrupted", e, new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForNewItemOrCompleted() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            if (!this.completed) {
                try {
                    this.waitForNextItem.wait();
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error(this, "Thread was interrupted", e, new Object[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyNewItem() {
        Object object = this.waitForNextItem;
        synchronized (object) {
            this.waitForNextItem.notifyAll();
        }
    }
}

