/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.executor.PatternEdge;
import com.orientechnologies.orient.core.sql.executor.PatternNode;
import com.orientechnologies.orient.core.sql.parser.OMatchExpression;
import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class Pattern {
    public Map<String, PatternNode> aliasToNode = new LinkedHashMap<String, PatternNode>();
    public int numOfEdges = 0;

    public void addExpression(OMatchExpression expression) {
        PatternNode originNode = this.getOrCreateNode(expression.origin);
        for (OMatchPathItem item : expression.items) {
            String nextAlias = item.filter.getAlias();
            PatternNode nextNode = this.getOrCreateNode(item.filter);
            this.numOfEdges += originNode.addEdge(item, nextNode);
            originNode = nextNode;
        }
    }

    private PatternNode getOrCreateNode(OMatchFilter origin) {
        PatternNode originNode = this.get(origin.getAlias());
        if (originNode == null) {
            originNode = new PatternNode();
            originNode.alias = origin.getAlias();
            this.aliasToNode.put(originNode.alias, originNode);
        }
        if (origin.isOptional()) {
            originNode.optional = true;
        }
        return originNode;
    }

    public PatternNode get(String alias) {
        return this.aliasToNode.get(alias);
    }

    public int getNumOfEdges() {
        return this.numOfEdges;
    }

    public void validate() {
        for (PatternNode node : this.aliasToNode.values()) {
            if (!node.isOptionalNode()) continue;
            if (node.out.size() > 0) {
                throw new OCommandSQLParsingException("In current MATCH version, optional nodes are allowed only on right terminal nodes, eg. {} --> {optional:true} is allowed, {optional:true} <-- {} is not. ");
            }
            if (node.in.size() != 0) continue;
            throw new OCommandSQLParsingException("In current MATCH version, optional nodes must have at least one incoming pattern edge");
        }
    }

    public List<Pattern> getDisjointPatterns() {
        IdentityHashMap<PatternNode, String> reverseMap = new IdentityHashMap<PatternNode, String>();
        reverseMap.putAll(this.aliasToNode.entrySet().stream().collect(Collectors.toMap(x -> (PatternNode)x.getValue(), x -> (String)x.getKey())));
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        while (!reverseMap.isEmpty()) {
            Pattern pattern = new Pattern();
            result.add(pattern);
            Map.Entry nextNode = reverseMap.entrySet().iterator().next();
            HashSet<Object> toVisit = new HashSet<Object>();
            toVisit.add(nextNode.getKey());
            while (toVisit.size() > 0) {
                PatternNode currentNode = (PatternNode)toVisit.iterator().next();
                toVisit.remove(currentNode);
                if (!reverseMap.containsKey(currentNode)) continue;
                pattern.aliasToNode.put((String)reverseMap.get(currentNode), currentNode);
                reverseMap.remove(currentNode);
                for (PatternEdge x2 : currentNode.out) {
                    toVisit.add(x2.in);
                }
                for (PatternEdge x2 : currentNode.in) {
                    toVisit.add(x2.out);
                }
            }
            pattern.recalculateNumOfEdges();
        }
        return result;
    }

    private void recalculateNumOfEdges() {
        IdentityHashMap<PatternEdge, PatternEdge> edges = new IdentityHashMap<PatternEdge, PatternEdge>();
        for (PatternNode node : this.aliasToNode.values()) {
            for (PatternEdge edge : node.out) {
                edges.put(edge, edge);
            }
            for (PatternEdge edge : node.in) {
                edges.put(edge, edge);
            }
        }
        this.numOfEdges = edges.size();
    }

    public Map<String, PatternNode> getAliasToNode() {
        return this.aliasToNode;
    }

    public void setAliasToNode(Map<String, PatternNode> aliasToNode) {
        this.aliasToNode = aliasToNode;
    }

    public void setNumOfEdges(int numOfEdges) {
        this.numOfEdges = numOfEdges;
    }
}

