/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OUpdateRemoveItem
extends SimpleNode {
    OExpression left;
    OExpression right;

    public OUpdateRemoveItem(int id) {
        super(id);
    }

    public OUpdateRemoveItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        if (this.right != null) {
            builder.append(" = ");
            this.right.toString(params, builder);
        }
    }

    @Override
    public OUpdateRemoveItem copy() {
        OUpdateRemoveItem result = new OUpdateRemoveItem(-1);
        result.left = this.left == null ? null : this.left.copy();
        result.right = this.right == null ? null : this.right.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OUpdateRemoveItem that = (OUpdateRemoveItem)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public void applyUpdate(OResultInternal result, OCommandContext ctx) {
        if (this.right != null) {
            Object leftVal = this.left.execute(result, ctx);
            Object rightVal = this.right.execute(result, ctx);
            if (OMultiValue.isMultiValue(leftVal)) {
                OMultiValue.remove(leftVal, rightVal, false);
            }
        } else {
            this.left.applyRemove(result, ctx);
        }
    }
}

