/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OBaseIdentifier;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OTraverseProjectionItem
extends SimpleNode {
    protected OBaseIdentifier base;
    protected OModifier modifier;

    public OTraverseProjectionItem(int id) {
        super(id);
    }

    public OTraverseProjectionItem(OrientSql p, int id) {
        super(p, id);
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        if (this.isStar()) {
            return this.handleStar(iCurrentRecord, ctx);
        }
        Object result = this.base.execute(iCurrentRecord, ctx);
        if (this.modifier != null) {
            result = this.modifier.execute(iCurrentRecord, result, ctx);
        }
        return result;
    }

    private boolean isStar() {
        return this.base.toString().equals("*") && this.modifier == null;
    }

    private Object handleStar(OResult iCurrentRecord, OCommandContext ctx) {
        HashSet<Object> result = new HashSet<Object>();
        for (String prop : iCurrentRecord.getPropertyNames()) {
            Object val = iCurrentRecord.getProperty(prop);
            if (this.isOResult(val) || this.isValidIdentifiable(val)) {
                result.add(val);
                continue;
            }
            if (val instanceof Iterable) {
                val = ((Iterable)val).iterator();
            }
            if (val instanceof Iterator) {
                while (((Iterator)val).hasNext()) {
                    Object sub = ((Iterator)val).next();
                    if (!this.isOResult(sub) && !this.isValidIdentifiable(sub)) continue;
                    result.add(sub);
                }
                continue;
            }
            if (!(val instanceof OResultSet)) continue;
            while (((OResultSet)val).hasNext()) {
                result.add(((OResultSet)val).next());
            }
        }
        return result;
    }

    private boolean isValidIdentifiable(Object val) {
        if (!(val instanceof OIdentifiable)) {
            return false;
        }
        return ((OIdentifiable)val).getIdentity().isPersistent();
    }

    private boolean isOResult(Object val) {
        return val instanceof OResult;
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.base.toString(params, builder);
        if (this.modifier != null) {
            this.modifier.toString(params, builder);
        }
    }

    @Override
    public OTraverseProjectionItem copy() {
        OTraverseProjectionItem result = new OTraverseProjectionItem(-1);
        result.base = this.base == null ? null : this.base.copy();
        result.modifier = this.modifier == null ? null : this.modifier.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTraverseProjectionItem that = (OTraverseProjectionItem)o;
        if (this.base != null ? !this.base.equals(that.base) : that.base != null) {
            return false;
        }
        return !(this.modifier != null ? !this.modifier.equals(that.modifier) : that.modifier != null);
    }

    public int hashCode() {
        int result = this.base != null ? this.base.hashCode() : 0;
        result = 31 * result + (this.modifier != null ? this.modifier.hashCode() : 0);
        return result;
    }
}

