/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.ORecordAttribute;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OSuffixIdentifier
extends SimpleNode {
    protected OIdentifier identifier;
    protected ORecordAttribute recordAttribute;
    protected boolean star = false;

    public OSuffixIdentifier(int id) {
        super(id);
    }

    public OSuffixIdentifier(OrientSql p, int id) {
        super(p, id);
    }

    public OSuffixIdentifier(OIdentifier identifier) {
        this.identifier = identifier;
    }

    public OSuffixIdentifier(ORecordAttribute attr) {
        this.recordAttribute = attr;
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.identifier != null) {
            this.identifier.toString(params, builder);
        } else if (this.recordAttribute != null) {
            this.recordAttribute.toString(params, builder);
        } else if (this.star) {
            builder.append("*");
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.star) {
            return iCurrentRecord;
        }
        if (this.identifier != null) {
            String varName = this.identifier.getStringValue();
            if (ctx != null && ctx.getVariable(varName) != null) {
                return ctx.getVariable(varName);
            }
            if (iCurrentRecord != null) {
                Map<String, Object> meta;
                if (iCurrentRecord instanceof OContextualRecordId && (meta = ((OContextualRecordId)iCurrentRecord).getContext()) != null && meta.containsKey(varName)) {
                    return meta.get(varName);
                }
                return ((OElement)iCurrentRecord.getRecord()).getProperty(varName);
            }
            return null;
        }
        if (this.recordAttribute != null) {
            return ((OElement)iCurrentRecord.getRecord()).getProperty(this.recordAttribute.name);
        }
        return null;
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        if (this.star) {
            return iCurrentRecord;
        }
        if (this.identifier != null) {
            String varName = this.identifier.getStringValue();
            if (ctx != null && varName.equalsIgnoreCase("$parent")) {
                return ctx.getParent();
            }
            if (ctx != null && ctx.getVariable(varName) != null) {
                return ctx.getVariable(varName);
            }
            if (iCurrentRecord != null) {
                if (iCurrentRecord.hasProperty(varName)) {
                    return iCurrentRecord.getProperty(varName);
                }
                if (iCurrentRecord.getMetadataKeys().contains(varName)) {
                    return iCurrentRecord.getMetadata(varName);
                }
            }
            return null;
        }
        if (iCurrentRecord != null && this.recordAttribute != null) {
            return this.recordAttribute.evaluate(iCurrentRecord, ctx);
        }
        return null;
    }

    public Object execute(Map iCurrentRecord, OCommandContext ctx) {
        if (this.star) {
            OResultInternal result = new OResultInternal();
            if (iCurrentRecord != null) {
                for (Map.Entry x : iCurrentRecord.entrySet()) {
                    result.setProperty("" + x.getKey(), x.getValue());
                }
                return result;
            }
            return iCurrentRecord;
        }
        if (this.identifier != null) {
            String varName = this.identifier.getStringValue();
            if (ctx != null && varName.equalsIgnoreCase("$parent")) {
                return ctx.getParent();
            }
            if (ctx != null && ctx.getVariable(varName) != null) {
                return ctx.getVariable(varName);
            }
            if (iCurrentRecord != null) {
                return iCurrentRecord.get(varName);
            }
            return null;
        }
        if (this.recordAttribute != null) {
            return iCurrentRecord.get(this.recordAttribute.name);
        }
        return null;
    }

    public Object execute(Iterable iterable, OCommandContext ctx) {
        if (this.star) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object o : iterable) {
            result.add(this.execute(o, ctx));
        }
        return result;
    }

    public Object execute(Iterator iterator, OCommandContext ctx) {
        if (this.star) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            result.add(this.execute(iterator.next(), ctx));
        }
        if (iterator instanceof OResultSet) {
            try {
                ((OResultSet)iterator).reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public Object execute(OCommandContext iCurrentRecord) {
        if (this.star) {
            return null;
        }
        if (this.identifier != null) {
            String varName = this.identifier.getStringValue();
            if (iCurrentRecord != null) {
                return iCurrentRecord.getVariable(varName);
            }
            return null;
        }
        if (this.recordAttribute != null && iCurrentRecord != null) {
            return iCurrentRecord.getVariable(this.recordAttribute.name);
        }
        return null;
    }

    public Object execute(Object currentValue, OCommandContext ctx) {
        if (currentValue instanceof OResult) {
            return this.execute((OResult)currentValue, ctx);
        }
        if (currentValue instanceof OIdentifiable) {
            return this.execute((OIdentifiable)currentValue, ctx);
        }
        if (currentValue instanceof Map) {
            return this.execute((Map)currentValue, ctx);
        }
        if (currentValue instanceof OCommandContext) {
            return this.execute((OCommandContext)currentValue);
        }
        if (currentValue instanceof Iterable) {
            return this.execute((Iterable)currentValue, ctx);
        }
        if (currentValue instanceof Iterator) {
            return this.execute((Iterator)currentValue, ctx);
        }
        if (currentValue == null) {
            return this.execute((OResult)null, ctx);
        }
        return null;
    }

    public boolean isBaseIdentifier() {
        return this.identifier != null;
    }

    public boolean needsAliases(Set<String> aliases) {
        if (this.identifier != null) {
            return aliases.contains(this.identifier.getStringValue());
        }
        if (this.recordAttribute != null) {
            for (String s : aliases) {
                if (!s.equalsIgnoreCase(this.recordAttribute.name)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAggregate() {
        return false;
    }

    public boolean isCount() {
        return false;
    }

    public OSuffixIdentifier splitForAggregation(AggregateProjectionSplit aggregateProj) {
        return this;
    }

    public boolean isEarlyCalculated() {
        return this.identifier != null && this.identifier.internalAlias;
    }

    public void aggregate(Object value, OCommandContext ctx) {
        throw new UnsupportedOperationException("this operation does not support plain aggregation: " + this.toString());
    }

    public AggregationContext getAggregationContext(OCommandContext ctx) {
        throw new UnsupportedOperationException("this operation does not support plain aggregation: " + this.toString());
    }

    @Override
    public OSuffixIdentifier copy() {
        OSuffixIdentifier result = new OSuffixIdentifier(-1);
        result.identifier = this.identifier == null ? null : this.identifier.copy();
        result.recordAttribute = this.recordAttribute == null ? null : this.recordAttribute.copy();
        result.star = this.star;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSuffixIdentifier that = (OSuffixIdentifier)o;
        if (this.star != that.star) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        return !(this.recordAttribute != null ? !this.recordAttribute.equals(that.recordAttribute) : that.recordAttribute != null);
    }

    public int hashCode() {
        int result = this.identifier != null ? this.identifier.hashCode() : 0;
        result = 31 * result + (this.recordAttribute != null ? this.recordAttribute.hashCode() : 0);
        result = 31 * result + (this.star ? 1 : 0);
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
    }

    public boolean refersToParent() {
        return this.identifier != null && this.identifier.getStringValue().equalsIgnoreCase("$parent");
    }

    public void setValue(Object target, Object value, OCommandContext ctx) {
        if (target instanceof OResult) {
            this.setValue((OResult)target, value, ctx);
        } else if (target instanceof OIdentifiable) {
            this.setValue((OIdentifiable)target, value, ctx);
        } else if (target instanceof Map) {
            this.setValue((Map)target, value, ctx);
        }
    }

    public void setValue(OIdentifiable target, Object value, OCommandContext ctx) {
        if (target == null) {
            return;
        }
        OElement doc = null;
        if (target instanceof OElement) {
            doc = (OElement)target;
        } else {
            Object rec = target.getRecord();
            if (rec instanceof OElement) {
                doc = (OElement)rec;
            }
        }
        if (doc == null) {
            throw new OCommandExecutionException("Cannot set record attribute " + this.recordAttribute + " on existing document");
        }
        doc.setProperty(this.identifier.getStringValue(), value);
    }

    public void setValue(Map target, Object value, OCommandContext ctx) {
        if (target == null) {
            return;
        }
        if (this.identifier != null) {
            target.put(this.identifier.getStringValue(), value);
        } else if (this.recordAttribute != null) {
            target.put(this.recordAttribute.getName(), value);
        }
    }

    public void setValue(OResult target, Object value, OCommandContext ctx) {
        if (target == null) {
            return;
        }
        if (target instanceof OResultInternal) {
            OResultInternal intTarget = (OResultInternal)target;
            if (this.identifier != null) {
                intTarget.setProperty(this.identifier.getStringValue(), value);
            } else if (this.recordAttribute != null) {
                intTarget.setProperty(this.recordAttribute.getName(), value);
            }
        } else {
            throw new OCommandExecutionException("Cannot set property on unmodifiable target: " + target);
        }
    }

    public void applyRemove(Object currentValue, OCommandContext ctx) {
        if (currentValue == null) {
            return;
        }
        if (this.identifier != null) {
            if (currentValue instanceof OResultInternal) {
                ((OResultInternal)currentValue).removeProperty(this.identifier.getStringValue());
            } else if (currentValue instanceof OElement) {
                ((OElement)currentValue).removeProperty(this.identifier.getStringValue());
            } else if (currentValue instanceof Map) {
                ((Map)currentValue).remove(this.identifier.getStringValue());
            }
        }
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.identifier != null) {
            result.setProperty("identifier", this.identifier.serialize());
        }
        if (this.recordAttribute != null) {
            result.setProperty("recordAttribute", this.recordAttribute.serialize());
        }
        result.setProperty("star", this.star);
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("identifier") != null) {
            this.identifier = new OIdentifier(-1);
            OIdentifier.deserialize((OResult)fromResult.getProperty("identifier"));
        }
        if (fromResult.getProperty("recordAttribute") != null) {
            this.recordAttribute = new ORecordAttribute(-1);
            this.recordAttribute.deserialize((OResult)fromResult.getProperty("recordAttribute"));
        }
        this.star = (Boolean)fromResult.getProperty("star");
    }

    public boolean isDefinedFor(OResult currentRecord) {
        if (this.identifier != null) {
            return currentRecord.hasProperty(this.identifier.getStringValue());
        }
        return true;
    }

    public boolean isDefinedFor(OElement currentRecord) {
        if (this.identifier != null) {
            return ((ODocument)currentRecord.getRecord()).containsField(this.identifier.getStringValue());
        }
        return true;
    }

    public OCollate getCollate(OResult currentRecord, OCommandContext ctx) {
        if (this.identifier != null) {
            return currentRecord.getRecord().map(x -> (OElement)x).flatMap(elem -> elem.getSchemaType()).map(clazz -> clazz.getProperty(this.identifier.getStringValue())).map(prop -> prop.getCollate()).orElse(null);
        }
        return null;
    }

    public boolean isCacheable() {
        return true;
    }
}

