/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.ParseException;
import com.orientechnologies.orient.core.sql.parser.TokenMgrError;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;

public class OStatementCache {
    Map<String, OStatement> map;
    int mapSize;

    public OStatementCache(int size) {
        this.mapSize = size;
        this.map = new LinkedHashMap<String, OStatement>(size){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, OStatement> eldest) {
                return super.size() > OStatementCache.this.mapSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String statement) {
        Map<String, OStatement> map = this.map;
        synchronized (map) {
            return this.map.containsKey(statement);
        }
    }

    public static OStatement get(String statement, ODatabaseDocumentInternal db) {
        if (db == null) {
            return OStatementCache.parse(statement);
        }
        OStatementCache resource = db.getSharedContext().getStatementCache();
        return resource.get(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStatement get(String statement) {
        OStatement result;
        Map<String, OStatement> map = this.map;
        synchronized (map) {
            result = this.map.remove(statement);
            if (result != null) {
                this.map.put(statement, result);
            }
        }
        if (result == null) {
            result = OStatementCache.parse(statement);
            map = this.map;
            synchronized (map) {
                this.map.put(statement, result);
            }
        }
        return result;
    }

    protected static OStatement parse(String statement) throws OCommandSQLParsingException {
        try {
            ByteArrayInputStream is;
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
            if (db == null) {
                is = new ByteArrayInputStream(statement.getBytes());
            } else {
                try {
                    is = new ByteArrayInputStream(statement.getBytes(db.getStorage().getConfiguration().getCharset()));
                }
                catch (UnsupportedEncodingException e2) {
                    OLogManager.instance().warn(null, "Unsupported charset for database " + db + " " + db.getStorage().getConfiguration().getCharset(), new Object[0]);
                    is = new ByteArrayInputStream(statement.getBytes());
                }
            }
            OrientSql osql = null;
            if (db == null) {
                osql = new OrientSql(is);
            } else {
                try {
                    osql = new OrientSql(is, db.getStorage().getConfiguration().getCharset());
                }
                catch (UnsupportedEncodingException e2) {
                    OLogManager.instance().warn(null, "Unsupported charset for database " + db + " " + db.getStorage().getConfiguration().getCharset(), new Object[0]);
                    osql = new OrientSql(is);
                }
            }
            OStatement result = osql.parse();
            result.originalStatement = statement;
            return result;
        }
        catch (ParseException e) {
            OStatementCache.throwParsingException(e, statement);
        }
        catch (TokenMgrError e2) {
            OStatementCache.throwParsingException(e2, statement);
        }
        return null;
    }

    protected static void throwParsingException(ParseException e, String statement) {
        throw new OCommandSQLParsingException(e, statement);
    }

    protected static void throwParsingException(TokenMgrError e, String statement) {
        throw new OCommandSQLParsingException(e, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, OStatement> map = this.map;
        synchronized (map) {
            this.map.clear();
        }
    }
}

