/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class ORid
extends SimpleNode {
    protected OInteger cluster;
    protected OInteger position;
    protected OExpression expression;
    protected boolean legacy;

    public ORid(int id) {
        super(id);
    }

    public ORid(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String toString(String prefix) {
        return "#" + this.cluster.getValue() + ":" + this.position.getValue();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.legacy) {
            builder.append("#" + this.cluster.getValue() + ":" + this.position.getValue());
        } else {
            builder.append("{\"@rid\":");
            this.expression.toString(params, builder);
            builder.append("}");
        }
    }

    public ORecordId toRecordId(OResult target, OCommandContext ctx) {
        if (this.legacy) {
            return new ORecordId(this.cluster.value.intValue(), this.position.value.longValue());
        }
        Object result = this.expression.execute(target, ctx);
        if (result == null) {
            return null;
        }
        if (result instanceof OIdentifiable) {
            return (ORecordId)((OIdentifiable)result).getIdentity();
        }
        if (result instanceof String) {
            return new ORecordId((String)result);
        }
        return null;
    }

    public ORecordId toRecordId(OIdentifiable target, OCommandContext ctx) {
        if (this.legacy) {
            return new ORecordId(this.cluster.value.intValue(), this.position.value.longValue());
        }
        Object result = this.expression.execute(target, ctx);
        if (result == null) {
            return null;
        }
        if (result instanceof OIdentifiable) {
            return (ORecordId)((OIdentifiable)result).getIdentity();
        }
        if (result instanceof String) {
            return new ORecordId((String)result);
        }
        return null;
    }

    @Override
    public ORid copy() {
        ORid result = new ORid(-1);
        result.cluster = this.cluster == null ? null : this.cluster.copy();
        result.position = this.position == null ? null : this.position.copy();
        result.expression = this.expression == null ? null : this.expression.copy();
        result.legacy = this.legacy;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ORid oRid = (ORid)o;
        if (this.cluster != null ? !this.cluster.equals(oRid.cluster) : oRid.cluster != null) {
            return false;
        }
        if (this.position != null ? !this.position.equals(oRid.position) : oRid.position != null) {
            return false;
        }
        if (this.expression != null ? !this.expression.equals(oRid.expression) : oRid.expression != null) {
            return false;
        }
        return this.legacy == oRid.legacy;
    }

    public int hashCode() {
        int result = this.cluster != null ? this.cluster.hashCode() : 0;
        result = 31 * result + (this.position != null ? this.position.hashCode() : 0);
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        return result;
    }

    public void setCluster(OInteger cluster) {
        this.cluster = cluster;
    }

    public void setPosition(OInteger position) {
        this.position = position;
    }

    public void setLegacy(boolean b) {
        this.legacy = b;
    }

    public OInteger getCluster() {
        ORecordId rid;
        if (this.expression != null && (rid = this.toRecordId((OResult)null, (OCommandContext)new OBasicCommandContext())) == null) {
            OInteger result = new OInteger(-1);
            result.setValue(rid.getClusterId());
            return result;
        }
        return this.cluster;
    }

    public OInteger getPosition() {
        ORecordId rid;
        if (this.expression != null && (rid = this.toRecordId((OResult)null, (OCommandContext)new OBasicCommandContext())) == null) {
            OInteger result = new OInteger(-1);
            result.setValue(rid.getClusterPosition());
            return result;
        }
        return this.position;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.cluster != null) {
            result.setProperty("cluster", this.cluster.serialize());
        }
        if (this.position != null) {
            result.setProperty("position", this.position.serialize());
        }
        if (this.expression != null) {
            result.setProperty("expression", this.expression.serialize());
        }
        result.setProperty("legacy", this.legacy);
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("cluster") != null) {
            this.cluster = new OInteger(-1);
            this.cluster.deserialize((OResult)fromResult.getProperty("cluster"));
        }
        if (fromResult.getProperty("position") != null) {
            this.position = new OInteger(-1);
            this.position.deserialize((OResult)fromResult.getProperty("position"));
        }
        if (fromResult.getProperty("expression") != null) {
            this.expression = new OExpression(-1);
            this.expression.deserialize((OResult)fromResult.getProperty("expression"));
        }
        this.legacy = (Boolean)fromResult.getProperty("legacy");
    }
}

