/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.ONestedProjection;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Map;

public class OProjectionItem
extends SimpleNode {
    protected boolean all = false;
    protected OIdentifier alias;
    protected OExpression expression;
    protected Boolean aggregate;
    protected ONestedProjection nestedProjection;

    public OProjectionItem(OExpression expression, OIdentifier alias, ONestedProjection nestedProjection) {
        super(-1);
        this.expression = expression;
        this.alias = alias;
        this.nestedProjection = nestedProjection;
    }

    public OProjectionItem(int id) {
        super(id);
    }

    public OProjectionItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isAll() {
        if (this.all) {
            return true;
        }
        return this.expression != null && "*".equals(this.expression.toString());
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public OIdentifier getAlias() {
        return this.alias;
    }

    public void setAlias(OIdentifier alias) {
        this.alias = alias;
    }

    public OExpression getExpression() {
        return this.expression;
    }

    public void setExpression(OExpression expression) {
        this.expression = expression;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.all) {
            builder.append("*");
        } else {
            if (this.expression != null) {
                this.expression.toString(params, builder);
            }
            if (this.nestedProjection != null) {
                builder.append(" ");
                this.nestedProjection.toString(params, builder);
            }
            if (this.alias != null) {
                builder.append(" AS ");
                this.alias.toString(params, builder);
            }
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        Object result = this.all ? iCurrentRecord : this.expression.execute(iCurrentRecord, ctx);
        if (this.nestedProjection != null) {
            result = this.nestedProjection.apply(this.expression, result, ctx);
        }
        return this.convert(result);
    }

    private Object convert(Object value) {
        if (value instanceof ORidBag) {
            ArrayList result = new ArrayList();
            ((ORidBag)value).forEach(x -> result.add(x));
            return result;
        }
        return value;
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        Object result = this.all ? iCurrentRecord : this.expression.execute(iCurrentRecord, ctx);
        if (this.nestedProjection != null) {
            result = this.nestedProjection.apply(this.expression, result, ctx);
        }
        return this.convert(result);
    }

    public String getProjectionAliasAsString() {
        return this.getProjectionAlias().getStringValue();
    }

    public OIdentifier getProjectionAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        OIdentifier result = this.all ? new OIdentifier("*") : new OIdentifier(this.expression.toString());
        return result;
    }

    public boolean isExpand() {
        return this.expression.isExpand();
    }

    public OProjectionItem getExpandContent() {
        OProjectionItem result = new OProjectionItem(-1);
        result.setExpression(this.expression.getExpandContent());
        return result;
    }

    public boolean isAggregate() {
        if (this.aggregate != null) {
            return this.aggregate;
        }
        if (this.all) {
            this.aggregate = false;
            return false;
        }
        if (this.expression.isAggregate()) {
            this.aggregate = true;
            return true;
        }
        this.aggregate = false;
        return false;
    }

    public OProjectionItem splitForAggregation(AggregateProjectionSplit aggregateSplit) {
        if (this.isAggregate()) {
            OProjectionItem result = new OProjectionItem(-1);
            result.alias = this.getProjectionAlias();
            result.expression = this.expression.splitForAggregation(aggregateSplit);
            result.nestedProjection = this.nestedProjection;
            return result;
        }
        return this;
    }

    public AggregationContext getAggregationContext(OCommandContext ctx) {
        if (this.expression == null) {
            throw new OCommandExecutionException("Cannot aggregate on this projection: " + this.toString());
        }
        return this.expression.getAggregationContext(ctx);
    }

    @Override
    public OProjectionItem copy() {
        OProjectionItem result = new OProjectionItem(-1);
        result.all = this.all;
        result.alias = this.alias == null ? null : this.alias.copy();
        result.expression = this.expression == null ? null : this.expression.copy();
        result.nestedProjection = this.nestedProjection == null ? null : this.nestedProjection.copy();
        result.aggregate = this.aggregate;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OProjectionItem that = (OProjectionItem)o;
        if (this.all != that.all) {
            return false;
        }
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        if (this.nestedProjection != null ? !this.nestedProjection.equals(that.nestedProjection) : that.nestedProjection != null) {
            return false;
        }
        return !(this.aggregate != null ? !this.aggregate.equals(that.aggregate) : that.aggregate != null);
    }

    public int hashCode() {
        int result = this.all ? 1 : 0;
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.nestedProjection != null ? this.nestedProjection.hashCode() : 0);
        result = 31 * result + (this.aggregate != null ? this.aggregate.hashCode() : 0);
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.expression != null) {
            this.expression.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        if (this.expression != null) {
            return this.expression.refersToParent();
        }
        return false;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("all", this.all);
        if (this.alias != null) {
            result.setProperty("alias", this.alias.serialize());
        }
        if (this.expression != null) {
            result.setProperty("expression", this.expression.serialize());
        }
        result.setProperty("aggregate", this.aggregate);
        if (this.nestedProjection != null) {
            result.setProperty("nestedProjection", this.nestedProjection.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.all = (Boolean)fromResult.getProperty("all");
        if (fromResult.getProperty("alias") != null) {
            this.alias = OIdentifier.deserialize((OResult)fromResult.getProperty("alias"));
        }
        if (fromResult.getProperty("expression") != null) {
            this.expression = new OExpression(-1);
            this.expression.deserialize((OResult)fromResult.getProperty("expression"));
        }
        this.aggregate = (Boolean)fromResult.getProperty("aggregate");
        if (fromResult.getProperty("nestedProjection") != null) {
            this.nestedProjection = new ONestedProjection(-1);
            this.nestedProjection.deserialize((OResult)fromResult.getProperty("nestedProjection"));
        }
    }

    public void setNestedProjection(ONestedProjection nestedProjection) {
        this.nestedProjection = nestedProjection;
    }

    public boolean isCacheable() {
        if (this.expression != null) {
            return this.expression.isCacheable();
        }
        return true;
    }
}

