/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class ONamedParameter
extends OInputParameter {
    protected int paramNumber;
    protected String paramName;

    public ONamedParameter(int id) {
        super(id);
    }

    public ONamedParameter(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String toString() {
        return ":" + this.paramName;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        Object finalValue = this.bindFromInputParams(params);
        if (finalValue == this) {
            builder.append(":" + this.paramName);
        } else if (finalValue instanceof String) {
            builder.append("\"");
            builder.append(OExpression.encode(finalValue.toString()));
            builder.append("\"");
        } else if (finalValue instanceof SimpleNode) {
            ((SimpleNode)finalValue).toString(params, builder);
        } else {
            builder.append(finalValue);
        }
    }

    @Override
    public Object getValue(Map<Object, Object> params) {
        Object result = null;
        if (params != null) {
            String key = this.paramName;
            result = params.containsKey(key) ? params.get(key) : params.get(this.paramNumber);
        }
        return result;
    }

    @Override
    public Object bindFromInputParams(Map<Object, Object> params) {
        if (params != null) {
            String key = this.paramName;
            if (params.containsKey(key)) {
                return this.toParsedTree(params.get(key));
            }
            return this.toParsedTree(params.get(this.paramNumber));
        }
        return this;
    }

    @Override
    public ONamedParameter copy() {
        ONamedParameter result = new ONamedParameter(-1);
        result.paramName = this.paramName;
        result.paramNumber = this.paramNumber;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ONamedParameter that = (ONamedParameter)o;
        if (this.paramNumber != that.paramNumber) {
            return false;
        }
        return !(this.paramName != null ? !this.paramName.equals(that.paramName) : that.paramName != null);
    }

    public int hashCode() {
        int result = this.paramNumber;
        result = 31 * result + (this.paramName != null ? this.paramName.hashCode() : 0);
        return result;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = (OResultInternal)super.serialize();
        result.setProperty("paramNumber", this.paramNumber);
        result.setProperty("paramName", this.paramName);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        this.paramNumber = (Integer)fromResult.getProperty("paramNumber");
        this.paramName = (String)fromResult.getProperty("paramName");
    }
}

