/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.sql.executor.AggregationContext;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.AggregateProjectionSplit;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OMathExpression
extends SimpleNode {
    private static final Object NULL_VALUE = new Object();
    protected List<OMathExpression> childExpressions = new ArrayList<OMathExpression>();
    protected List<Operator> operators = new ArrayList<Operator>();

    public OExpression getExpandContent() {
        throw new OCommandExecutionException("Invalid expand expression");
    }

    public boolean isDefinedFor(OResult currentRecord) {
        return true;
    }

    public boolean isDefinedFor(OElement currentRecord) {
        return true;
    }

    public OMathExpression(int id) {
        super(id);
    }

    public OMathExpression(OrientSql p, int id) {
        super(p, id);
    }

    public boolean isCacheable() {
        for (OMathExpression exp : this.childExpressions) {
            if (exp.isCacheable()) continue;
            return false;
        }
        return true;
    }

    public Object execute(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        if (this.childExpressions.size() == 0) {
            return null;
        }
        if (this.childExpressions.size() == 1) {
            return this.childExpressions.get(0).execute(iCurrentRecord, ctx);
        }
        if (this.childExpressions.size() == 2) {
            Object leftValue = this.childExpressions.get(0).execute(iCurrentRecord, ctx);
            Object rightValue = this.childExpressions.get(1).execute(iCurrentRecord, ctx);
            return this.operators.get(0).apply(leftValue, rightValue);
        }
        return this.calculateWithOpPriority(iCurrentRecord, ctx);
    }

    public Object execute(OResult iCurrentRecord, OCommandContext ctx) {
        if (this.childExpressions.size() == 0) {
            return null;
        }
        if (this.childExpressions.size() == 1) {
            return this.childExpressions.get(0).execute(iCurrentRecord, ctx);
        }
        if (this.childExpressions.size() == 2) {
            Object leftValue = this.childExpressions.get(0).execute(iCurrentRecord, ctx);
            Object rightValue = this.childExpressions.get(1).execute(iCurrentRecord, ctx);
            return this.operators.get(0).apply(leftValue, rightValue);
        }
        return this.calculateWithOpPriority(iCurrentRecord, ctx);
    }

    private Object calculateWithOpPriority(OResult iCurrentRecord, OCommandContext ctx) {
        ArrayDeque<Object> valuesStack = new ArrayDeque<Object>();
        ArrayDeque<Operator> operatorsStack = new ArrayDeque<Operator>();
        OMathExpression nextExpression = this.childExpressions.get(0);
        Object val = nextExpression.execute(iCurrentRecord, ctx);
        valuesStack.push(val == null ? NULL_VALUE : val);
        for (int i = 0; i < this.operators.size() && i + 1 < this.childExpressions.size(); ++i) {
            Operator nextOperator = this.operators.get(i);
            Object rightValue = this.childExpressions.get(i + 1).execute(iCurrentRecord, ctx);
            if (!operatorsStack.isEmpty() && ((Operator)((Object)operatorsStack.peek())).getPriority() <= nextOperator.getPriority()) {
                Object right = valuesStack.poll();
                right = right == NULL_VALUE ? null : right;
                Object left = valuesStack.poll();
                left = left == NULL_VALUE ? null : left;
                Object calculatedValue = ((Operator)((Object)operatorsStack.poll())).apply(left, right);
                valuesStack.push(calculatedValue == null ? NULL_VALUE : calculatedValue);
            }
            operatorsStack.push(nextOperator);
            valuesStack.push(rightValue == null ? NULL_VALUE : rightValue);
        }
        return this.iterateOnPriorities(valuesStack, operatorsStack);
    }

    private Object calculateWithOpPriority(OIdentifiable iCurrentRecord, OCommandContext ctx) {
        ArrayDeque<Object> valuesStack = new ArrayDeque<Object>();
        ArrayDeque<Operator> operatorsStack = new ArrayDeque<Operator>();
        OMathExpression nextExpression = this.childExpressions.get(0);
        Object val = nextExpression.execute(iCurrentRecord, ctx);
        valuesStack.push(val == null ? NULL_VALUE : val);
        for (int i = 0; i < this.operators.size() && i + 1 < this.childExpressions.size(); ++i) {
            Operator nextOperator = this.operators.get(i);
            Object rightValue = this.childExpressions.get(i + 1).execute(iCurrentRecord, ctx);
            if (!operatorsStack.isEmpty() && ((Operator)((Object)operatorsStack.peek())).getPriority() <= nextOperator.getPriority()) {
                Object right = valuesStack.poll();
                right = right == NULL_VALUE ? null : right;
                Object left = valuesStack.poll();
                left = left == NULL_VALUE ? null : left;
                Object calculatedValue = ((Operator)((Object)operatorsStack.poll())).apply(left, right);
                valuesStack.push(calculatedValue == null ? NULL_VALUE : calculatedValue);
            }
            operatorsStack.push(nextOperator);
            valuesStack.push(rightValue == null ? NULL_VALUE : rightValue);
        }
        return this.iterateOnPriorities(valuesStack, operatorsStack);
    }

    private Object iterateOnPriorities(Deque values, Deque<Operator> operators) {
        while (values.size() != 0) {
            if (values.size() == 1) {
                return values.getFirst();
            }
            ArrayDeque<Object> valuesStack = new ArrayDeque<Object>();
            ArrayDeque<Operator> operatorsStack = new ArrayDeque<Operator>();
            valuesStack.push(values.removeLast());
            while (!operators.isEmpty()) {
                Operator nextOperator = operators.removeLast();
                Object rightValue = values.removeLast();
                if (!operatorsStack.isEmpty() && ((Operator)((Object)operatorsStack.peek())).getPriority() <= nextOperator.getPriority()) {
                    Object right = valuesStack.poll();
                    right = right == NULL_VALUE ? null : right;
                    Object left = valuesStack.poll();
                    left = left == NULL_VALUE ? null : left;
                    Object calculatedValue = ((Operator)((Object)operatorsStack.poll())).apply(left, right);
                    valuesStack.push(calculatedValue == null ? NULL_VALUE : calculatedValue);
                }
                operatorsStack.push(nextOperator);
                valuesStack.push(rightValue == null ? NULL_VALUE : rightValue);
            }
            if (!operatorsStack.isEmpty()) {
                Object right = valuesStack.poll();
                right = right == NULL_VALUE ? null : right;
                Object left = valuesStack.poll();
                left = left == NULL_VALUE ? null : left;
                Object val = ((Operator)((Object)operatorsStack.poll())).apply(left, right);
                valuesStack.push(val == null ? NULL_VALUE : val);
            }
            values = valuesStack;
            operators = operatorsStack;
        }
        return null;
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public List<OMathExpression> getChildExpressions() {
        return this.childExpressions;
    }

    public void setChildExpressions(List<OMathExpression> childExpressions) {
        this.childExpressions = childExpressions;
    }

    public List<Operator> getOperators() {
        return this.operators;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        for (int i = 0; i < this.childExpressions.size(); ++i) {
            if (i > 0) {
                builder.append(" ");
                switch (this.operators.get(i - 1)) {
                    case PLUS: {
                        builder.append("+");
                        break;
                    }
                    case MINUS: {
                        builder.append("-");
                        break;
                    }
                    case STAR: {
                        builder.append("*");
                        break;
                    }
                    case SLASH: {
                        builder.append("/");
                        break;
                    }
                    case REM: {
                        builder.append("%");
                        break;
                    }
                    case LSHIFT: {
                        builder.append("<<");
                        break;
                    }
                    case RSHIFT: {
                        builder.append(">>");
                        break;
                    }
                    case RUNSIGNEDSHIFT: {
                        builder.append(">>>");
                        break;
                    }
                    case BIT_AND: {
                        builder.append("&");
                        break;
                    }
                    case BIT_OR: {
                        builder.append("|");
                        break;
                    }
                    case XOR: {
                        builder.append("^");
                    }
                }
                builder.append(" ");
            }
            this.childExpressions.get(i).toString(params, builder);
        }
    }

    protected boolean supportsBasicCalculation() {
        for (OMathExpression expr : this.childExpressions) {
            if (expr.supportsBasicCalculation()) continue;
            return false;
        }
        return true;
    }

    public boolean isIndexedFunctionCall() {
        if (this.childExpressions.size() != 1) {
            return false;
        }
        return this.childExpressions.get(0).isIndexedFunctionCall();
    }

    public long estimateIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.childExpressions.size() != 1) {
            return -1L;
        }
        return this.childExpressions.get(0).estimateIndexedFunction(target, context, operator, right);
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.childExpressions.size() != 1) {
            return null;
        }
        return this.childExpressions.get(0).executeIndexedFunction(target, context, operator, right);
    }

    public boolean canExecuteIndexedFunctionWithoutIndex(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.childExpressions.size() != 1) {
            return false;
        }
        return this.childExpressions.get(0).canExecuteIndexedFunctionWithoutIndex(target, context, operator, right);
    }

    public boolean allowsIndexedFunctionExecutionOnTarget(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.childExpressions.size() != 1) {
            return false;
        }
        return this.childExpressions.get(0).allowsIndexedFunctionExecutionOnTarget(target, context, operator, right);
    }

    public boolean executeIndexedFunctionAfterIndexSearch(OFromClause target, OCommandContext context, OBinaryCompareOperator operator, Object right) {
        if (this.childExpressions.size() != 1) {
            return false;
        }
        return this.childExpressions.get(0).executeIndexedFunctionAfterIndexSearch(target, context, operator, right);
    }

    public boolean isBaseIdentifier() {
        if (this.childExpressions.size() == 1) {
            return this.childExpressions.get(0).isBaseIdentifier();
        }
        return false;
    }

    public OCollate getCollate(OResult currentRecord, OCommandContext ctx) {
        if (this.childExpressions.size() == 1) {
            return this.childExpressions.get(0).getCollate(currentRecord, ctx);
        }
        return null;
    }

    public boolean isEarlyCalculated() {
        for (OMathExpression exp : this.childExpressions) {
            if (exp.isEarlyCalculated()) continue;
            return false;
        }
        return true;
    }

    public boolean needsAliases(Set<String> aliases) {
        for (OMathExpression expr : this.childExpressions) {
            if (!expr.needsAliases(aliases)) continue;
            return true;
        }
        return false;
    }

    public boolean isExpand() {
        for (OMathExpression expr : this.childExpressions) {
            if (!expr.isExpand()) continue;
            if (this.childExpressions.size() > 1) {
                throw new OCommandExecutionException("Cannot calculate expand() with other expressions");
            }
            return true;
        }
        return false;
    }

    public boolean isAggregate() {
        for (OMathExpression expr : this.childExpressions) {
            if (!expr.isAggregate()) continue;
            return true;
        }
        return false;
    }

    public boolean isCount() {
        if (this.childExpressions.size() != 1) {
            return false;
        }
        return this.childExpressions.get(0).isCount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleNode splitForAggregation(AggregateProjectionSplit aggregateProj) {
        if (!this.isAggregate()) return this;
        OMathExpression result = new OMathExpression(-1);
        int i = 0;
        for (OMathExpression expr : this.childExpressions) {
            SimpleNode splitResult;
            if (i > 0) {
                result.operators.add(this.operators.get(i - 1));
            }
            if ((splitResult = expr.splitForAggregation(aggregateProj)) instanceof OMathExpression) {
                OMathExpression res = (OMathExpression)splitResult;
                if (!res.isEarlyCalculated() && !res.isAggregate()) throw new OCommandExecutionException("Cannot mix aggregate and single record attribute values in the same projection");
                result.childExpressions.add(res);
            } else if (splitResult instanceof OExpression) {
                result.childExpressions.add(((OExpression)splitResult).mathExpression);
            }
            ++i;
        }
        return result;
    }

    public AggregationContext getAggregationContext(OCommandContext ctx) {
        throw new UnsupportedOperationException("multiple math expressions do not allow plain aggregation");
    }

    @Override
    public OMathExpression copy() {
        OMathExpression result = null;
        try {
            result = (OMathExpression)this.getClass().getConstructor(Integer.TYPE).newInstance(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.childExpressions = this.childExpressions.stream().map(x -> x.copy()).collect(Collectors.toList());
        result.operators.addAll(this.operators);
        return result;
    }

    public void extractSubQueries(OIdentifier letAlias, SubQueryCollector collector) {
        for (OMathExpression expr : this.childExpressions) {
            expr.extractSubQueries(letAlias, collector);
        }
    }

    public void extractSubQueries(SubQueryCollector collector) {
        for (OMathExpression expr : this.childExpressions) {
            expr.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        for (OMathExpression expr : this.childExpressions) {
            if (!expr.refersToParent()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMathExpression that = (OMathExpression)o;
        if (this.childExpressions != null ? !this.childExpressions.equals(that.childExpressions) : that.childExpressions != null) {
            return false;
        }
        return !(this.operators != null ? !this.operators.equals(that.operators) : that.operators != null);
    }

    public int hashCode() {
        int result = this.childExpressions != null ? this.childExpressions.hashCode() : 0;
        result = 31 * result + (this.operators != null ? this.operators.hashCode() : 0);
        return result;
    }

    public List<String> getMatchPatternInvolvedAliases() {
        ArrayList<String> result = new ArrayList<String>();
        for (OMathExpression exp : this.childExpressions) {
            List<String> x = exp.getMatchPatternInvolvedAliases();
            if (x == null) continue;
            result.addAll(x);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    public void applyRemove(OResultInternal result, OCommandContext ctx) {
        if (this.childExpressions.size() != 1) {
            throw new OCommandExecutionException("cannot apply REMOVE " + this.toString());
        }
        this.childExpressions.get(0).applyRemove(result, ctx);
    }

    public static OMathExpression deserializeFromResult(OResult fromResult) {
        String className = (String)fromResult.getProperty("__class");
        try {
            OMathExpression result = (OMathExpression)Class.forName(className).getConstructor(Integer.class).newInstance(-1);
            result.deserialize(fromResult);
            return result;
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("__class", this.getClass().getName());
        if (this.childExpressions != null) {
            result.setProperty("childExpressions", this.childExpressions.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        if (this.operators != null) {
            result.setProperty("operators", this.operators.stream().map(x -> this.serializeOperator((Operator)((Object)x))).collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        List ser;
        if (fromResult.getProperty("childExpressions") != null) {
            ser = (List)fromResult.getProperty("childExpressions");
            this.childExpressions = ser.stream().map(x -> OMathExpression.deserializeFromResult(x)).collect(Collectors.toList());
        }
        if (fromResult.getProperty("operators") != null) {
            ser = (List)fromResult.getProperty("operators");
            this.operators = ser.stream().map(x -> this.deserializeOperator((String)x)).collect(Collectors.toList());
        }
    }

    private String serializeOperator(Operator x) {
        return x.toString();
    }

    private Operator deserializeOperator(String x) {
        return Operator.valueOf(x);
    }

    public static enum Operator {
        STAR(10){

            @Override
            public Number apply(Integer left, Integer right) {
                return left * right;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left * right;
            }

            @Override
            public Number apply(Float left, Float right) {
                return Float.valueOf(left.floatValue() * right.floatValue());
            }

            @Override
            public Number apply(Double left, Double right) {
                return left * right;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return left.multiply(right);
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null || right == null) {
                    return null;
                }
                return super.apply(left, right);
            }
        }
        ,
        SLASH(10){

            @Override
            public Number apply(Integer left, Integer right) {
                if (left % right == 0) {
                    return left / right;
                }
                return (double)left.intValue() / (double)right.intValue();
            }

            @Override
            public Number apply(Long left, Long right) {
                if (left % right == 0L) {
                    return left / right;
                }
                return (double)left.longValue() / (double)right.longValue();
            }

            @Override
            public Number apply(Float left, Float right) {
                return Float.valueOf(left.floatValue() / right.floatValue());
            }

            @Override
            public Number apply(Double left, Double right) {
                return left / right;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return left.divide(right, 4);
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null || right == null) {
                    return null;
                }
                return super.apply(left, right);
            }
        }
        ,
        REM(10){

            @Override
            public Number apply(Integer left, Integer right) {
                return left % right;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left % right;
            }

            @Override
            public Number apply(Float left, Float right) {
                return Float.valueOf(left.floatValue() % right.floatValue());
            }

            @Override
            public Number apply(Double left, Double right) {
                return left % right;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return left.remainder(right);
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null || right == null) {
                    return null;
                }
                return super.apply(left, right);
            }
        }
        ,
        PLUS(20){

            @Override
            public Number apply(Integer left, Integer right) {
                Integer sum = left + right;
                if (sum < 0 && left > 0 && right > 0) {
                    return left.longValue() + (long)right.intValue();
                }
                return sum;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left + right;
            }

            @Override
            public Number apply(Float left, Float right) {
                return Float.valueOf(left.floatValue() + right.floatValue());
            }

            @Override
            public Number apply(Double left, Double right) {
                return left + right;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return left.add(right);
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null && right == null) {
                    return null;
                }
                if (left == null) {
                    return right;
                }
                if (right == null) {
                    return left;
                }
                if (left instanceof Number && right instanceof Number) {
                    return super.apply(left, right);
                }
                if (left instanceof Date || right instanceof Date) {
                    Number result = this.apply(Operator.toLong(left), Operator.toLong(right));
                    return new Date(result.longValue());
                }
                return String.valueOf(left) + String.valueOf(right);
            }
        }
        ,
        MINUS(20){

            @Override
            public Number apply(Integer left, Integer right) {
                int result = left - right;
                if (result > 0 && left < 0 && right > 0) {
                    return left.longValue() - (long)right.intValue();
                }
                return result;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left - right;
            }

            @Override
            public Number apply(Float left, Float right) {
                return Float.valueOf(left.floatValue() - right.floatValue());
            }

            @Override
            public Number apply(Double left, Double right) {
                return left - right;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return left.subtract(right);
            }

            @Override
            public Object apply(Object left, Object right) {
                Object result = null;
                if (left == null && right == null) {
                    result = null;
                } else if (left instanceof Number && right == null) {
                    result = left;
                } else if (right instanceof Number && left == null) {
                    result = this.apply(0, this, (Number)right);
                } else if (left instanceof Number && right instanceof Number) {
                    result = this.apply((Number)left, this, (Number)right);
                } else if (left instanceof Date || right instanceof Date) {
                    Number r = this.apply(Operator.toLong(left), Operator.toLong(right));
                    result = new Date(r.longValue());
                }
                return result;
            }
        }
        ,
        LSHIFT(30){

            @Override
            public Number apply(Integer left, Integer right) {
                return left << right;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left << (int)right.longValue();
            }

            @Override
            public Number apply(Float left, Float right) {
                return null;
            }

            @Override
            public Number apply(Double left, Double right) {
                return null;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return null;
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null || right == null) {
                    return null;
                }
                return super.apply(left, right);
            }
        }
        ,
        RSHIFT(30){

            @Override
            public Number apply(Integer left, Integer right) {
                return left >> right;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left >> (int)right.longValue();
            }

            @Override
            public Number apply(Float left, Float right) {
                return null;
            }

            @Override
            public Number apply(Double left, Double right) {
                return null;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return null;
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null || right == null) {
                    return null;
                }
                return super.apply(left, right);
            }
        }
        ,
        RUNSIGNEDSHIFT(30){

            @Override
            public Number apply(Integer left, Integer right) {
                return left >>> right;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left >>> (int)right.longValue();
            }

            @Override
            public Number apply(Float left, Float right) {
                return null;
            }

            @Override
            public Number apply(Double left, Double right) {
                return null;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return null;
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null || right == null) {
                    return null;
                }
                return super.apply(left, right);
            }
        }
        ,
        BIT_AND(40){

            @Override
            public Number apply(Integer left, Integer right) {
                return left & right;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left & right;
            }

            @Override
            public Number apply(Float left, Float right) {
                return null;
            }

            @Override
            public Number apply(Double left, Double right) {
                return null;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return null;
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null || right == null) {
                    return null;
                }
                return super.apply(left, right);
            }
        }
        ,
        XOR(50){

            @Override
            public Number apply(Integer left, Integer right) {
                return left ^ right;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left ^ right;
            }

            @Override
            public Number apply(Float left, Float right) {
                return null;
            }

            @Override
            public Number apply(Double left, Double right) {
                return null;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return null;
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null && right == null) {
                    return null;
                }
                if (left instanceof Number && right == null) {
                    return this.apply((Number)left, this, 0);
                }
                if (right instanceof Number && left == null) {
                    return this.apply(0, this, (Number)right);
                }
                if (left instanceof Number && right instanceof Number) {
                    return this.apply((Number)left, this, (Number)right);
                }
                return null;
            }
        }
        ,
        BIT_OR(60){

            @Override
            public Number apply(Integer left, Integer right) {
                return left | right;
            }

            @Override
            public Number apply(Long left, Long right) {
                return left | right;
            }

            @Override
            public Number apply(Float left, Float right) {
                return null;
            }

            @Override
            public Number apply(Double left, Double right) {
                return null;
            }

            @Override
            public Number apply(BigDecimal left, BigDecimal right) {
                return null;
            }

            @Override
            public Object apply(Object left, Object right) {
                if (left == null && right == null) {
                    return null;
                }
                return super.apply(left == null ? Integer.valueOf(0) : left, right == null ? Integer.valueOf(0) : right);
            }
        };

        private final int priority;

        private static Long toLong(Object left) {
            if (left instanceof Number) {
                return ((Number)left).longValue();
            }
            if (left instanceof Date) {
                return ((Date)left).getTime();
            }
            return null;
        }

        private Operator(int priority) {
            this.priority = priority;
        }

        public abstract Number apply(Integer var1, Integer var2);

        public abstract Number apply(Long var1, Long var2);

        public abstract Number apply(Float var1, Float var2);

        public abstract Number apply(Double var1, Double var2);

        public abstract Number apply(BigDecimal var1, BigDecimal var2);

        public Object apply(Object left, Object right) {
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            if (left instanceof Number && right instanceof Number) {
                return this.apply((Number)left, this, (Number)right);
            }
            return null;
        }

        public Number apply(Number a, Operator operation, Number b) {
            if (a == null || b == null) {
                throw new IllegalArgumentException("Cannot increment a null value");
            }
            if (a instanceof Integer || a instanceof Short) {
                if (b instanceof Integer || b instanceof Short) {
                    return operation.apply(a.intValue(), b.intValue());
                }
                if (b instanceof Long) {
                    return operation.apply(a.longValue(), b.longValue());
                }
                if (b instanceof Float) {
                    return operation.apply(Float.valueOf(a.floatValue()), Float.valueOf(b.floatValue()));
                }
                if (b instanceof Double) {
                    return operation.apply(a.doubleValue(), b.doubleValue());
                }
                if (b instanceof BigDecimal) {
                    return operation.apply(new BigDecimal((Integer)a), (BigDecimal)b);
                }
            } else if (a instanceof Long) {
                if (b instanceof Integer || b instanceof Long || b instanceof Short) {
                    return operation.apply(a.longValue(), b.longValue());
                }
                if (b instanceof Float) {
                    return operation.apply(Float.valueOf(a.floatValue()), Float.valueOf(b.floatValue()));
                }
                if (b instanceof Double) {
                    return operation.apply(a.doubleValue(), b.doubleValue());
                }
                if (b instanceof BigDecimal) {
                    return operation.apply(new BigDecimal((Long)a), (BigDecimal)b);
                }
            } else if (a instanceof Float) {
                if (b instanceof Short || b instanceof Integer || b instanceof Long || b instanceof Float) {
                    return operation.apply(Float.valueOf(a.floatValue()), Float.valueOf(b.floatValue()));
                }
                if (b instanceof Double) {
                    return operation.apply(a.doubleValue(), b.doubleValue());
                }
                if (b instanceof BigDecimal) {
                    return operation.apply(new BigDecimal(((Float)a).floatValue()), (BigDecimal)b);
                }
            } else if (a instanceof Double) {
                if (b instanceof Short || b instanceof Integer || b instanceof Long || b instanceof Float || b instanceof Double) {
                    return operation.apply(a.doubleValue(), b.doubleValue());
                }
                if (b instanceof BigDecimal) {
                    return operation.apply(new BigDecimal((Double)a), (BigDecimal)b);
                }
            } else if (a instanceof BigDecimal) {
                if (b instanceof Integer) {
                    return operation.apply((BigDecimal)a, new BigDecimal((Integer)b));
                }
                if (b instanceof Long) {
                    return operation.apply((BigDecimal)a, new BigDecimal((Long)b));
                }
                if (b instanceof Short) {
                    return operation.apply((BigDecimal)a, new BigDecimal(((Short)b).shortValue()));
                }
                if (b instanceof Float) {
                    return operation.apply((BigDecimal)a, new BigDecimal(((Float)b).floatValue()));
                }
                if (b instanceof Double) {
                    return operation.apply((BigDecimal)a, new BigDecimal((Double)b));
                }
                if (b instanceof BigDecimal) {
                    return operation.apply((BigDecimal)a, (BigDecimal)b);
                }
            }
            throw new IllegalArgumentException("Cannot increment value '" + a + "' (" + a.getClass() + ") with '" + b + "' (" + b.getClass() + ")");
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

