/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchStatement;
import com.orientechnologies.orient.core.sql.parser.OMethodCall;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;

public class OMatchPathItem
extends SimpleNode {
    protected OMethodCall method;
    protected OMatchFilter filter;

    public OMatchPathItem(int id) {
        super(id);
    }

    public OMatchPathItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isBidirectional() {
        if (this.filter.getWhileCondition() != null) {
            return false;
        }
        if (this.filter.getMaxDepth() != null) {
            return false;
        }
        if (this.filter.isOptional()) {
            return false;
        }
        return this.method.isBidirectional();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.method.toString(params, builder);
        if (this.filter != null) {
            this.filter.toString(params, builder);
        }
    }

    public Iterable<OIdentifiable> executeTraversal(OMatchStatement.MatchContext matchContext, OCommandContext iCommandContext, OIdentifiable startingPoint, int depth) {
        OWhereClause filter = null;
        OWhereClause whileCondition = null;
        Integer maxDepth = null;
        OClass oClass = null;
        if (this.filter != null) {
            filter = this.filter.getFilter();
            whileCondition = this.filter.getWhileCondition();
            maxDepth = this.filter.getMaxDepth();
            String className = this.filter.getClassName(iCommandContext);
            oClass = OMatchPathItem.getDatabase().getMetadata().getSchema().getClass(className);
        }
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        if (whileCondition == null && maxDepth == null) {
            Iterable<OIdentifiable> queryResult = this.traversePatternEdge(matchContext, startingPoint, iCommandContext);
            if (this.filter == null || this.filter.getFilter() == null) {
                return queryResult;
            }
            for (OIdentifiable origin : queryResult) {
                Object previousMatch = iCommandContext.getVariable("$currentMatch");
                iCommandContext.setVariable("$currentMatch", origin);
                if ((oClass == null || this.matchesClass(origin, oClass)) && (filter == null || filter.matchesFilters(origin, iCommandContext))) {
                    result.add(origin);
                }
                iCommandContext.setVariable("$currentMatch", previousMatch);
            }
        } else {
            iCommandContext.setVariable("$depth", depth);
            Object previousMatch = iCommandContext.getVariable("$currentMatch");
            iCommandContext.setVariable("$currentMatch", startingPoint);
            if ((oClass == null || this.matchesClass(startingPoint, oClass)) && (filter == null || filter.matchesFilters(startingPoint, iCommandContext))) {
                result.add(startingPoint);
            }
            if (!(maxDepth != null && depth >= maxDepth || whileCondition != null && !whileCondition.matchesFilters(startingPoint, iCommandContext))) {
                Iterable<OIdentifiable> queryResult = this.traversePatternEdge(matchContext, startingPoint, iCommandContext);
                for (OIdentifiable origin : queryResult) {
                    Iterable<OIdentifiable> subResult = this.executeTraversal(matchContext, iCommandContext, origin, depth + 1);
                    if (subResult instanceof Collection) {
                        result.addAll((Collection)subResult);
                        continue;
                    }
                    for (OIdentifiable i : subResult) {
                        result.add(i);
                    }
                }
            }
            iCommandContext.setVariable("$currentMatch", previousMatch);
        }
        return result;
    }

    private boolean matchesClass(OIdentifiable identifiable, OClass oClass) {
        if (identifiable == null) {
            return false;
        }
        Object record = identifiable.getRecord();
        if (record == null) {
            return false;
        }
        if (record instanceof ODocument) {
            return ((ODocument)record).getSchemaClass().isSubClassOf(oClass);
        }
        return false;
    }

    protected Iterable<OIdentifiable> traversePatternEdge(OMatchStatement.MatchContext matchContext, OIdentifiable startingPoint, OCommandContext iCommandContext) {
        Object qR;
        Iterable<Object> possibleResults = null;
        if (this.filter != null) {
            OIdentifiable matchedNode = matchContext.matched.get(this.filter.getAlias());
            possibleResults = matchedNode != null ? Collections.singleton(matchedNode) : (matchContext.matched.containsKey(this.filter.getAlias()) ? Collections.emptySet() : (matchContext.candidates == null ? null : matchContext.candidates.get(this.filter.getAlias())));
        }
        return (qR = this.method.execute(startingPoint, possibleResults, iCommandContext)) instanceof Iterable && !(qR instanceof ODocument) ? (Iterable)qR : Collections.singleton((OIdentifiable)qR);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OMatchPathItem that = (OMatchPathItem)o;
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        return !(this.filter != null ? !this.filter.equals(that.filter) : that.filter != null);
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }

    @Override
    public OMatchPathItem copy() {
        OMatchPathItem result = null;
        try {
            result = (OMatchPathItem)this.getClass().getConstructor(Integer.TYPE).newInstance(-1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        result.method = this.method == null ? null : this.method.copy();
        result.filter = this.filter == null ? null : this.filter.copy();
        return result;
    }

    public OMethodCall getMethod() {
        return this.method;
    }

    public void setMethod(OMethodCall method) {
        this.method = method;
    }

    public OMatchFilter getFilter() {
        return this.filter;
    }

    public void setFilter(OMatchFilter filter) {
        this.filter = filter;
    }
}

