/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class OLetStatement
extends OSimpleExecStatement {
    protected OIdentifier name;
    protected OStatement statement;
    protected OExpression expression;

    public OLetStatement(int id) {
        super(id);
    }

    public OLetStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        Object result;
        if (this.expression != null) {
            result = this.expression.execute((OResult)null, ctx);
        } else {
            Map<Object, Object> params = ctx.getInputParameters();
            result = this.statement.execute(ctx.getDatabase(), params, ctx);
        }
        if (result instanceof OResultSet) {
            OInternalResultSet rs = new OInternalResultSet();
            ((OResultSet)result).stream().forEach(x -> rs.add((OResult)x));
            rs.setPlan(((OResultSet)result).getExecutionPlan().orElse(null));
            ((OResultSet)result).close();
            result = rs;
        }
        if (ctx != null && ctx.getParent() != null) {
            ctx.getParent().setVariable(this.name.getStringValue(), result);
        }
        return new OInternalResultSet();
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("LET ");
        this.name.toString(params, builder);
        builder.append(" = ");
        if (this.statement != null) {
            this.statement.toString(params, builder);
        } else {
            this.expression.toString(params, builder);
        }
    }

    @Override
    public OLetStatement copy() {
        OLetStatement result = new OLetStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.statement = this.statement == null ? null : this.statement.copy();
        result.expression = this.expression == null ? null : this.expression.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLetStatement that = (OLetStatement)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.statement != null ? !this.statement.equals(that.statement) : that.statement != null) {
            return false;
        }
        return !(this.expression != null ? !this.expression.equals(that.expression) : that.expression != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.statement != null ? this.statement.hashCode() : 0);
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        return result;
    }
}

