/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.Map;

public class OLetItem
extends SimpleNode {
    OIdentifier varName;
    OExpression expression;
    OStatement query;

    public OLetItem(int id) {
        super(id);
    }

    public OLetItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.varName.toString(params, builder);
        builder.append(" = ");
        if (this.expression != null) {
            this.expression.toString(params, builder);
        } else if (this.query != null) {
            builder.append("(");
            this.query.toString(params, builder);
            builder.append(")");
        }
    }

    @Override
    public OLetItem copy() {
        OLetItem result = new OLetItem(-1);
        result.varName = this.varName.copy();
        result.expression = this.expression == null ? null : this.expression.copy();
        result.query = this.query == null ? null : this.query.copy();
        return result;
    }

    public void setVarName(OIdentifier varName) {
        this.varName = varName;
    }

    public void setExpression(OExpression expression) {
        this.expression = expression;
    }

    public void setQuery(OStatement query) {
        this.query = query;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLetItem oLetItem = (OLetItem)o;
        if (this.varName != null ? !this.varName.equals(oLetItem.varName) : oLetItem.varName != null) {
            return false;
        }
        if (this.expression != null ? !this.expression.equals(oLetItem.expression) : oLetItem.expression != null) {
            return false;
        }
        return !(this.query != null ? !this.query.equals(oLetItem.query) : oLetItem.query != null);
    }

    public int hashCode() {
        int result = this.varName != null ? this.varName.hashCode() : 0;
        result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
        result = 31 * result + (this.query != null ? this.query.hashCode() : 0);
        return result;
    }

    public boolean refersToParent() {
        if (this.expression != null && this.expression.refersToParent()) {
            return true;
        }
        return this.query != null && this.query.refersToParent();
    }

    public OIdentifier getVarName() {
        return this.varName;
    }

    public OExpression getExpression() {
        return this.expression;
    }

    public OStatement getQuery() {
        return this.query;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.expression != null) {
            this.expression.extractSubQueries(this.varName, collector);
        }
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.varName != null) {
            result.setProperty("varName", this.varName.serialize());
        }
        if (this.expression != null) {
            result.setProperty("expression", this.expression.serialize());
        }
        if (this.query != null) {
            result.setProperty("query", this.query.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("varName") != null) {
            this.varName = new OIdentifier(-1);
            OIdentifier.deserialize((OResult)fromResult.getProperty("varName"));
        }
        if (fromResult.getProperty("expression") != null) {
            this.expression = new OExpression(-1);
            this.expression.deserialize((OResult)fromResult.getProperty("expression"));
        }
        if (fromResult.getProperty("query") != null) {
            this.query = OStatement.deserializeFromOResult((OResult)fromResult.getProperty("expression"));
        }
    }

    public boolean isCacheable() {
        if (this.expression != null) {
            return this.expression.isCacheable();
        }
        if (this.query != null) {
            return this.expression.isCacheable();
        }
        return true;
    }
}

