/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.IfStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OIfExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OScriptExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OIfStatement
extends OStatement {
    protected OBooleanExpression expression;
    protected List<OStatement> statements = new ArrayList<OStatement>();
    protected List<OStatement> elseStatements = new ArrayList<OStatement>();

    public OIfStatement(int id) {
        super(id);
    }

    public OIfStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean isIdempotent() {
        for (OStatement stm : this.statements) {
            if (stm.isIdempotent()) continue;
            return false;
        }
        for (OStatement stm : this.elseStatements) {
            if (stm.isIdempotent()) continue;
            return false;
        }
        return true;
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OIfExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        OExecutionStepInternal last = executionPlan.executeUntilReturn();
        if (this.isIdempotent()) {
            OSelectExecutionPlan finalPlan = new OSelectExecutionPlan(ctx);
            finalPlan.chain(last);
            return new OLocalResultSet(finalPlan);
        }
        OUpdateExecutionPlan finalPlan = new OUpdateExecutionPlan(ctx);
        finalPlan.chain(last);
        finalPlan.executeInternal();
        return new OLocalResultSet(finalPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OIfExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        OExecutionStepInternal last = executionPlan.executeUntilReturn();
        if (this.isIdempotent()) {
            OSelectExecutionPlan finalPlan = new OSelectExecutionPlan(ctx);
            finalPlan.chain(last);
            return new OLocalResultSet(finalPlan);
        }
        OUpdateExecutionPlan finalPlan = new OUpdateExecutionPlan(ctx);
        finalPlan.chain(last);
        finalPlan.executeInternal();
        return new OLocalResultSet(finalPlan);
    }

    @Override
    public OIfExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OIfExecutionPlan plan = new OIfExecutionPlan(ctx);
        IfStep step = new IfStep(ctx, enableProfiling);
        step.setCondition(this.expression);
        plan.chain(step);
        OBasicCommandContext subCtx1 = new OBasicCommandContext();
        subCtx1.setParent(ctx);
        OScriptExecutionPlan positivePlan = new OScriptExecutionPlan(subCtx1);
        for (OStatement stm : this.statements) {
            positivePlan.chain(stm.createExecutionPlan(subCtx1, enableProfiling), enableProfiling);
        }
        step.setPositivePlan(positivePlan);
        if (this.elseStatements.size() > 0) {
            OBasicCommandContext subCtx2 = new OBasicCommandContext();
            subCtx2.setParent(ctx);
            OScriptExecutionPlan negativePlan = new OScriptExecutionPlan(subCtx2);
            for (OStatement stm : this.elseStatements) {
                negativePlan.chain(stm.createExecutionPlan(subCtx2, enableProfiling), enableProfiling);
            }
            step.setNegativePlan(negativePlan);
        }
        return plan;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("IF(");
        this.expression.toString(params, builder);
        builder.append("){\n");
        for (OStatement stm : this.statements) {
            stm.toString(params, builder);
            builder.append(";\n");
        }
        builder.append("}");
        if (this.elseStatements.size() > 0) {
            builder.append("\nELSE {\n");
            for (OStatement stm : this.elseStatements) {
                stm.toString(params, builder);
                builder.append(";\n");
            }
            builder.append("}");
        }
    }

    @Override
    public OIfStatement copy() {
        OIfStatement result = new OIfStatement(-1);
        result.expression = this.expression == null ? null : this.expression.copy();
        result.statements = this.statements == null ? null : this.statements.stream().map(OStatement::copy).collect(Collectors.toList());
        result.elseStatements = this.elseStatements == null ? null : this.elseStatements.stream().map(OStatement::copy).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIfStatement that = (OIfStatement)o;
        if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) {
            return false;
        }
        if (this.statements != null ? !this.statements.equals(that.statements) : that.statements != null) {
            return false;
        }
        return !(this.elseStatements != null ? !this.elseStatements.equals(that.elseStatements) : that.elseStatements != null);
    }

    public int hashCode() {
        int result = this.expression != null ? this.expression.hashCode() : 0;
        result = 31 * result + (this.statements != null ? this.statements.hashCode() : 0);
        result = 31 * result + (this.elseStatements != null ? this.elseStatements.hashCode() : 0);
        return result;
    }
}

