/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Map;

public class OIdentifier
extends SimpleNode {
    protected String value;
    protected boolean quoted = false;
    protected boolean internalAlias = false;

    public OIdentifier(OIdentifier copyFrom, boolean quoted) {
        this(-1);
        this.value = copyFrom.value;
        this.quoted = quoted;
    }

    public OIdentifier(String content) {
        this(-1);
        this.setStringValue(content);
    }

    protected OIdentifier(int id) {
        super(id);
    }

    public static OIdentifier deserialize(OResult fromResult) {
        OIdentifier identifier = new OIdentifier(-1);
        identifier.value = (String)fromResult.getProperty("value");
        identifier.quoted = (Boolean)fromResult.getProperty("quoted");
        return identifier;
    }

    public OIdentifier(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    private void setValue(String value) {
        this.value = value;
    }

    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value.contains("`")) {
            return this.value.replaceAll("\\\\`", "`");
        }
        return this.value;
    }

    private void setStringValue(String s) {
        this.value = s == null ? null : (s.contains("`") ? s.replaceAll("`", "\\\\`") : s);
    }

    @Override
    public String toString(String prefix) {
        if (this.quoted) {
            return '`' + this.value + '`';
        }
        return this.value;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.quoted) {
            builder.append('`' + this.value + '`');
        } else {
            builder.append(this.value);
        }
    }

    private void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    @Override
    public OIdentifier copy() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIdentifier that = (OIdentifier)o;
        if (this.quoted != that.quoted) {
            return false;
        }
        if (this.internalAlias != that.internalAlias) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.quoted ? 1 : 0);
        result = 31 * result + (this.internalAlias ? 1 : 0);
        return result;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("value", this.value);
        result.setProperty("quoted", this.quoted);
        return result;
    }
}

