/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.executor.OIteratorResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OHaStatusStatement
extends OStatement {
    public boolean servers = false;
    public boolean db = false;
    public boolean latency = false;
    public boolean messages = false;
    public boolean outputText = false;

    public OHaStatusStatement(int id) {
        super(id);
    }

    public OHaStatusStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("HA STATUS");
        if (this.servers) {
            builder.append(" -servers");
        }
        if (this.db) {
            builder.append(" -db");
        }
        if (this.latency) {
            builder.append(" -latency");
        }
        if (this.messages) {
            builder.append(" -messages");
        }
        if (this.outputText) {
            builder.append(" -output=text");
        }
        if (this.servers) {
            builder.append(" -servers");
        }
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentContext) {
        StringBuilder builder = new StringBuilder();
        HashMap<Object, Object> pars = new HashMap<Object, Object>();
        for (int i = 0; i < args.length; ++i) {
            pars.put(Integer.toString(i + 1), args[i]);
        }
        this.toString(pars, builder);
        Object result = db.command(new OCommandSQL(builder.toString())).execute(new Object[0]);
        List listResult = result instanceof List ? (List)result : Collections.singletonList(result);
        return new OIteratorResultSet(listResult.iterator());
    }

    @Override
    public OResultSet execute(ODatabase db, Map args, OCommandContext parentContext) {
        StringBuilder builder = new StringBuilder();
        this.toString(args, builder);
        Object result = db.command(new OCommandSQL(builder.toString())).execute(new Object[0]);
        List listResult = result instanceof List ? (List)result : Collections.singletonList(result);
        return new OIteratorResultSet(listResult.iterator());
    }
}

