/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OClusterList;
import com.orientechnologies.orient.core.sql.parser.OFunctionCall;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OMetadataIdentifier;
import com.orientechnologies.orient.core.sql.parser.OModifier;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OFromItem
extends SimpleNode {
    protected List<ORid> rids;
    protected List<OInputParameter> inputParams;
    protected OCluster cluster;
    protected OClusterList clusterList;
    protected OIndexIdentifier index;
    protected OMetadataIdentifier metadata;
    protected OStatement statement;
    protected OInputParameter inputParam;
    protected OIdentifier identifier;
    protected OFunctionCall functionCall;
    protected OModifier modifier;

    public OFromItem(int id) {
        super(id);
    }

    public OFromItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.rids != null && this.rids.size() > 0) {
            if (this.rids.size() == 1) {
                this.rids.get(0).toString(params, builder);
                return;
            }
            builder.append("[");
            boolean first = true;
            for (ORid rid : this.rids) {
                if (!first) {
                    builder.append(", ");
                }
                rid.toString(params, builder);
                first = false;
            }
            builder.append("]");
            return;
        }
        if (this.inputParams != null && this.inputParams.size() > 0) {
            if (this.inputParams.size() == 1) {
                this.inputParams.get(0).toString(params, builder);
                return;
            }
            builder.append("[");
            boolean first = true;
            for (OInputParameter rid : this.inputParams) {
                if (!first) {
                    builder.append(", ");
                }
                rid.toString(params, builder);
                first = false;
            }
            builder.append("]");
            return;
        }
        if (this.cluster != null) {
            this.cluster.toString(params, builder);
            return;
        }
        if (this.clusterList != null) {
            this.clusterList.toString(params, builder);
            return;
        }
        if (this.metadata != null) {
            this.metadata.toString(params, builder);
            return;
        }
        if (this.statement != null) {
            builder.append("(");
            this.statement.toString(params, builder);
            builder.append(")");
            return;
        }
        if (this.index != null) {
            this.index.toString(params, builder);
            return;
        }
        if (this.inputParam != null) {
            this.inputParam.toString(params, builder);
        } else if (this.functionCall != null) {
            this.functionCall.toString(params, builder);
        } else if (this.identifier != null) {
            this.identifier.toString(params, builder);
        }
        if (this.modifier != null) {
            this.modifier.toString(params, builder);
        }
    }

    public OIdentifier getIdentifier() {
        return this.identifier;
    }

    public List<ORid> getRids() {
        return this.rids;
    }

    public OCluster getCluster() {
        return this.cluster;
    }

    public OClusterList getClusterList() {
        return this.clusterList;
    }

    public OIndexIdentifier getIndex() {
        return this.index;
    }

    public OMetadataIdentifier getMetadata() {
        return this.metadata;
    }

    public OStatement getStatement() {
        return this.statement;
    }

    public OInputParameter getInputParam() {
        return this.inputParam;
    }

    public List<OInputParameter> getInputParams() {
        return this.inputParams;
    }

    public OFunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public OModifier getModifier() {
        return this.modifier;
    }

    @Override
    public OFromItem copy() {
        OFromItem result = new OFromItem(-1);
        if (this.rids != null) {
            result.rids = this.rids.stream().map(r -> r.copy()).collect(Collectors.toList());
        }
        if (this.inputParams != null) {
            result.inputParams = this.inputParams.stream().map(r -> r.copy()).collect(Collectors.toList());
        }
        result.cluster = this.cluster == null ? null : this.cluster.copy();
        result.clusterList = this.clusterList == null ? null : this.clusterList.copy();
        result.index = this.index == null ? null : this.index.copy();
        result.metadata = this.metadata == null ? null : this.metadata.copy();
        result.statement = this.statement == null ? null : this.statement.copy();
        result.inputParam = this.inputParam == null ? null : this.inputParam.copy();
        result.identifier = this.identifier == null ? null : this.identifier.copy();
        result.functionCall = this.functionCall == null ? null : this.functionCall.copy();
        result.modifier = this.modifier == null ? null : this.modifier.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OFromItem oFromItem = (OFromItem)o;
        if (this.rids != null ? !this.rids.equals(oFromItem.rids) : oFromItem.rids != null) {
            return false;
        }
        if (this.inputParams != null ? !this.inputParams.equals(oFromItem.inputParams) : oFromItem.inputParams != null) {
            return false;
        }
        if (this.cluster != null ? !this.cluster.equals(oFromItem.cluster) : oFromItem.cluster != null) {
            return false;
        }
        if (this.clusterList != null ? !this.clusterList.equals(oFromItem.clusterList) : oFromItem.clusterList != null) {
            return false;
        }
        if (this.index != null ? !this.index.equals(oFromItem.index) : oFromItem.index != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(oFromItem.metadata) : oFromItem.metadata != null) {
            return false;
        }
        if (this.statement != null ? !this.statement.equals(oFromItem.statement) : oFromItem.statement != null) {
            return false;
        }
        if (this.inputParam != null ? !this.inputParam.equals(oFromItem.inputParam) : oFromItem.inputParam != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(oFromItem.identifier) : oFromItem.identifier != null) {
            return false;
        }
        if (this.functionCall != null ? !this.functionCall.equals(oFromItem.functionCall) : oFromItem.functionCall != null) {
            return false;
        }
        return !(this.modifier != null ? !this.modifier.equals(oFromItem.modifier) : oFromItem.modifier != null);
    }

    public int hashCode() {
        int result = this.rids != null ? this.rids.hashCode() : 0;
        result = 31 * result + (this.inputParams != null ? this.inputParams.hashCode() : 0);
        result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
        result = 31 * result + (this.clusterList != null ? this.clusterList.hashCode() : 0);
        result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
        result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
        result = 31 * result + (this.statement != null ? this.statement.hashCode() : 0);
        result = 31 * result + (this.inputParam != null ? this.inputParam.hashCode() : 0);
        result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
        result = 31 * result + (this.functionCall != null ? this.functionCall.hashCode() : 0);
        result = 31 * result + (this.modifier != null ? this.modifier.hashCode() : 0);
        return result;
    }

    public void setRids(List<ORid> rids) {
        this.rids = rids;
    }

    public void setCluster(OCluster cluster) {
        this.cluster = cluster;
    }

    public void setClusterList(OClusterList clusterList) {
        this.clusterList = clusterList;
    }

    public void setIndex(OIndexIdentifier index) {
        this.index = index;
    }

    public void setMetadata(OMetadataIdentifier metadata) {
        this.metadata = metadata;
    }

    public void setStatement(OStatement statement) {
        this.statement = statement;
    }

    public void setInputParam(OInputParameter inputParam) {
        this.inputParam = inputParam;
    }

    public void setIdentifier(OIdentifier identifier) {
        this.identifier = identifier;
    }

    public void setFunctionCall(OFunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public void setModifier(OModifier modifier) {
        this.modifier = modifier;
    }

    public void setInputParams(List<OInputParameter> inputParams) {
        this.inputParams = inputParams;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        if (this.rids != null) {
            result.setProperty("rids", this.rids.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        if (this.inputParams != null) {
            result.setProperty("inputParams", this.rids.stream().map(x -> x.serialize()).collect(Collectors.toList()));
        }
        if (this.cluster != null) {
            result.setProperty("cluster", this.cluster.serialize());
        }
        if (this.clusterList != null) {
            result.setProperty("clusterList", this.clusterList.serialize());
        }
        if (this.index != null) {
            result.setProperty("index", this.index.serialize());
        }
        if (this.metadata != null) {
            result.setProperty("metadata", this.metadata.serialize());
        }
        if (this.statement != null) {
            result.setProperty("statement", this.statement.serialize());
        }
        if (this.inputParam != null) {
            result.setProperty("inputParam", this.inputParam.serialize());
        }
        if (this.identifier != null) {
            result.setProperty("identifier", this.identifier.serialize());
        }
        if (this.functionCall != null) {
            result.setProperty("functionCall", this.functionCall.serialize());
        }
        if (this.modifier != null) {
            result.setProperty("modifier", this.modifier.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        if (fromResult.getProperty("rids") != null) {
            List serRids = (List)fromResult.getProperty("rids");
            this.rids = new ArrayList<ORid>();
            for (OResult res : serRids) {
                ORid rid = new ORid(-1);
                rid.deserialize(res);
                this.rids.add(rid);
            }
        }
        if (fromResult.getProperty("inputParams") != null) {
            List ser = (List)fromResult.getProperty("inputParams");
            this.inputParams = new ArrayList<OInputParameter>();
            for (OResult res : ser) {
                this.inputParams.add(OInputParameter.deserializeFromOResult(res));
            }
        }
        if (fromResult.getProperty("cluster") != null) {
            this.cluster = new OCluster(-1);
            this.cluster.deserialize((OResult)fromResult.getProperty("cluster"));
        }
        if (fromResult.getProperty("clusterList") != null) {
            this.clusterList = new OClusterList(-1);
            this.clusterList.deserialize((OResult)fromResult.getProperty("clusterList"));
        }
        if (fromResult.getProperty("index") != null) {
            this.index = new OIndexIdentifier(-1);
            this.index.deserialize((OResult)fromResult.getProperty("index"));
        }
        if (fromResult.getProperty("metadata") != null) {
            this.metadata = new OMetadataIdentifier(-1);
            this.metadata.deserialize((OResult)fromResult.getProperty("metadata"));
        }
        if (fromResult.getProperty("statement") != null) {
            this.statement = OStatement.deserializeFromOResult((OResult)fromResult.getProperty("statement"));
        }
        if (fromResult.getProperty("inputParam") != null) {
            this.inputParam = OInputParameter.deserializeFromOResult((OResult)fromResult.getProperty("inputParam"));
        }
        if (fromResult.getProperty("identifier") != null) {
            this.identifier = new OIdentifier(-1);
            OIdentifier.deserialize((OResult)fromResult.getProperty("identifier"));
        }
        if (fromResult.getProperty("functionCall") != null) {
            this.functionCall = new OFunctionCall(-1);
            this.functionCall.deserialize((OResult)fromResult.getProperty("functionCall"));
        }
        if (fromResult.getProperty("modifier") != null) {
            this.modifier = new OModifier(-1);
            this.modifier.deserialize((OResult)fromResult.getProperty("modifier"));
        }
    }

    public boolean isCacheable() {
        if (this.modifier != null) {
            return false;
        }
        if (this.inputParam != null) {
            return false;
        }
        if (this.inputParams != null && !this.inputParams.isEmpty()) {
            return false;
        }
        if (this.statement != null) {
            return this.statement.executinPlanCanBeCached();
        }
        if (this.functionCall != null) {
            return this.functionCall.isCacheable();
        }
        return true;
    }
}

