/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.sql.executor.LetExpressionStep;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OForEachBlock
extends OStatement {
    static int FOREACH_VARIABLE_PROGR = 0;
    protected OIdentifier loopVariable;
    protected OExpression loopValues;
    protected List<OStatement> statements = new ArrayList<OStatement>();

    public OForEachBlock(int id) {
        super(id);
    }

    public OForEachBlock(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet execute(ODatabase db, Object[] args, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        HashMap<Object, Object> params = new HashMap<Object, Object>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(i, args[i]);
            }
        }
        ctx.setInputParameters(params);
        OUpdateExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OResultSet execute(ODatabase db, Map params, OCommandContext parentCtx) {
        OBasicCommandContext ctx = new OBasicCommandContext();
        if (parentCtx != null) {
            ctx.setParentWithoutOverridingChild(parentCtx);
        }
        ctx.setDatabase(db);
        ctx.setInputParameters(params);
        OUpdateExecutionPlan executionPlan = this.createExecutionPlan(ctx, false);
        executionPlan.executeInternal();
        return new OLocalResultSet(executionPlan);
    }

    @Override
    public OUpdateExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OUpdateExecutionPlan plan = new OUpdateExecutionPlan(ctx);
        int nextProg = ++FOREACH_VARIABLE_PROGR;
        if (FOREACH_VARIABLE_PROGR < 0) {
            FOREACH_VARIABLE_PROGR = 0;
        }
        OIdentifier varName = new OIdentifier("__ORIENTDB_FOREACH_VAR_" + nextProg);
        plan.chain(new LetExpressionStep(varName, this.loopValues, ctx, enableProfiling));
        return plan;
    }

    @Override
    public OStatement copy() {
        OForEachBlock result = new OForEachBlock(-1);
        result.loopVariable = this.loopVariable.copy();
        result.loopValues = this.loopValues.copy();
        result.statements = this.statements.stream().map(x -> x.copy()).collect(Collectors.toList());
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OForEachBlock that = (OForEachBlock)o;
        if (this.loopVariable != null ? !this.loopVariable.equals(that.loopVariable) : that.loopVariable != null) {
            return false;
        }
        if (this.loopValues != null ? !this.loopValues.equals(that.loopValues) : that.loopValues != null) {
            return false;
        }
        return this.statements != null ? this.statements.equals(that.statements) : that.statements == null;
    }

    public int hashCode() {
        int result = this.loopVariable != null ? this.loopVariable.hashCode() : 0;
        result = 31 * result + (this.loopValues != null ? this.loopValues.hashCode() : 0);
        result = 31 * result + (this.statements != null ? this.statements.hashCode() : 0);
        return result;
    }
}

