/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OFetchPlanItem
extends SimpleNode {
    protected Boolean star;
    protected OInteger leftDepth;
    protected boolean leftStar = false;
    protected OInteger rightDepth;
    protected List<String> fieldChain = new ArrayList<String>();

    public OFetchPlanItem(int id) {
        super(id);
    }

    public OFetchPlanItem(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (Boolean.TRUE.equals(this.star)) {
            builder.append("*");
        } else {
            if (this.leftDepth != null) {
                builder.append("[");
                this.leftDepth.toString(params, builder);
                builder.append("]");
            } else if (this.leftStar) {
                builder.append("[*]");
            }
            boolean first = true;
            for (String s : this.fieldChain) {
                if (!first) {
                    builder.append(".");
                }
                builder.append(s);
                first = false;
            }
        }
        builder.append(":");
        this.rightDepth.toString(params, builder);
    }

    @Override
    public OFetchPlanItem copy() {
        OFetchPlanItem result = new OFetchPlanItem(-1);
        result.star = this.star;
        result.leftDepth = this.leftDepth == null ? null : this.leftDepth.copy();
        result.leftStar = this.leftStar;
        result.rightDepth = this.rightDepth == null ? null : this.rightDepth.copy();
        result.fieldChain.addAll(this.fieldChain);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OFetchPlanItem that = (OFetchPlanItem)o;
        if (this.leftStar != that.leftStar) {
            return false;
        }
        if (this.star != null ? !this.star.equals(that.star) : that.star != null) {
            return false;
        }
        if (this.leftDepth != null ? !this.leftDepth.equals(that.leftDepth) : that.leftDepth != null) {
            return false;
        }
        if (this.rightDepth != null ? !this.rightDepth.equals(that.rightDepth) : that.rightDepth != null) {
            return false;
        }
        return !(this.fieldChain != null ? !this.fieldChain.equals(that.fieldChain) : that.fieldChain != null);
    }

    public int hashCode() {
        int result = this.star != null ? this.star.hashCode() : 0;
        result = 31 * result + (this.leftDepth != null ? this.leftDepth.hashCode() : 0);
        result = 31 * result + (this.leftStar ? 1 : 0);
        result = 31 * result + (this.rightDepth != null ? this.rightDepth.hashCode() : 0);
        result = 31 * result + (this.fieldChain != null ? this.fieldChain.hashCode() : 0);
        return result;
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("star", this.star);
        if (this.leftDepth != null) {
            result.setProperty("leftDepth", this.leftDepth.serialize());
        }
        result.setProperty("leftStar", this.leftStar);
        if (this.rightDepth != null) {
            result.setProperty("rightDepth", this.rightDepth.serialize());
        }
        if (this.fieldChain != null) {
            result.setProperty("rightDepth", this.fieldChain.stream().collect(Collectors.toList()));
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.star = (Boolean)fromResult.getProperty("star");
        if (fromResult.getProperty("leftDepth") != null) {
            this.leftDepth = new OInteger(-1);
            this.leftDepth.deserialize((OResult)fromResult.getProperty("leftDepth"));
        }
        this.leftStar = (Boolean)fromResult.getProperty("leftStar");
        if (fromResult.getProperty("rightDepth") != null) {
            this.rightDepth = new OInteger(-1);
            this.rightDepth.deserialize((OResult)fromResult.getProperty("rightDepth"));
        }
        if (fromResult.getProperty("fieldChain") != null) {
            List ser = (List)fromResult.getProperty("fieldChain");
            this.fieldChain = new ArrayList<String>();
            this.fieldChain.addAll(ser);
        }
    }
}

