/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import java.util.LinkedHashMap;
import java.util.Map;

public class OExecutionPlanCache
implements OMetadataUpdateListener {
    Map<String, OInternalExecutionPlan> map;
    int mapSize;
    protected long lastInvalidation = -1L;

    public OExecutionPlanCache(int size) {
        this.mapSize = size;
        this.map = new LinkedHashMap<String, OInternalExecutionPlan>(size){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, OInternalExecutionPlan> eldest) {
                return super.size() > OExecutionPlanCache.this.mapSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastInvalidation(ODatabaseDocumentInternal db) {
        OExecutionPlanCache resource;
        if (db == null) {
            throw new IllegalArgumentException("DB cannot be null");
        }
        OExecutionPlanCache oExecutionPlanCache = resource = db.getSharedContext().getExecutionPlanCache();
        synchronized (oExecutionPlanCache) {
            return resource.lastInvalidation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String statement) {
        Map<String, OInternalExecutionPlan> map = this.map;
        synchronized (map) {
            return this.map.containsKey(statement);
        }
    }

    public static OExecutionPlan get(String statement, OCommandContext ctx, ODatabaseDocumentInternal db) {
        if (db == null) {
            throw new IllegalArgumentException("DB cannot be null");
        }
        OExecutionPlanCache resource = db.getSharedContext().getExecutionPlanCache();
        OExecutionPlan result = resource.getInternal(statement, ctx, db);
        return result;
    }

    public static void put(String statement, OExecutionPlan plan, ODatabaseDocumentInternal db) {
        if (db == null) {
            throw new IllegalArgumentException("DB cannot be null");
        }
        OExecutionPlanCache resource = db.getSharedContext().getExecutionPlanCache();
        resource.putInternal(statement, plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putInternal(String statement, OExecutionPlan plan) {
        Map<String, OInternalExecutionPlan> map = this.map;
        synchronized (map) {
            OInternalExecutionPlan internal = (OInternalExecutionPlan)plan;
            internal = internal.copy(null);
            this.map.put(statement, internal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OExecutionPlan getInternal(String statement, OCommandContext ctx, ODatabaseDocumentInternal db) {
        OInternalExecutionPlan result;
        Map<String, OInternalExecutionPlan> map = this.map;
        synchronized (map) {
            result = this.map.remove(statement);
            if (result != null) {
                this.map.put(statement, result);
                result = result.copy(ctx);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        OExecutionPlanCache oExecutionPlanCache = this;
        synchronized (oExecutionPlanCache) {
            Map<String, OInternalExecutionPlan> map = this.map;
            synchronized (map) {
                this.map.clear();
            }
            this.lastInvalidation = System.currentTimeMillis();
        }
    }

    @Override
    public void onSchemaUpdate(String database, OSchemaShared schema) {
        this.invalidate();
    }

    @Override
    public void onIndexManagerUpdate(String database, OIndexManager indexManager) {
        this.invalidate();
    }

    @Override
    public void onFunctionLibraryUpdate(String database) {
        this.invalidate();
    }

    @Override
    public void onSequenceLibraryUpdate(String database) {
        this.invalidate();
    }

    @Override
    public void onStorageConfigurationUpdate(String database, OStorageConfiguration update) {
        this.invalidate();
    }

    public static OExecutionPlanCache instance(ODatabaseDocumentTx db) {
        if (db == null) {
            throw new IllegalArgumentException("DB cannot be null");
        }
        OExecutionPlanCache resource = db.getSharedContext().getExecutionPlanCache();
        return resource;
    }
}

