/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.comparator.OCaseInsentiveComparator;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ODropPropertyStatement
extends ODDLStatement {
    protected OIdentifier className;
    protected OIdentifier propertyName;
    protected boolean ifExists = false;
    protected boolean force = false;

    public ODropPropertyStatement(int id) {
        super(id);
    }

    public ODropPropertyStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OInternalResultSet rs = new OInternalResultSet();
        ODatabase database = ctx.getDatabase();
        OClassImpl sourceClass = (OClassImpl)database.getMetadata().getSchema().getClass(this.className.getStringValue());
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        if (sourceClass.getProperty(this.propertyName.getStringValue()) == null) {
            if (this.ifExists) {
                return rs;
            }
            throw new OCommandExecutionException("Property '" + this.propertyName + "' not found on class " + this.className);
        }
        List<OIndex<?>> indexes = this.relatedIndexes(this.propertyName.getStringValue(), database);
        if (!indexes.isEmpty()) {
            if (this.force) {
                for (OIndex<?> index : indexes) {
                    index.delete();
                    OResultInternal result = new OResultInternal();
                    result.setProperty("operation", "cascade drop index");
                    result.setProperty("indexName", index.getName());
                    rs.add(result);
                }
            } else {
                StringBuilder indexNames = new StringBuilder();
                boolean first = true;
                for (OIndex<?> index : sourceClass.getClassInvolvedIndexes(this.propertyName.getStringValue())) {
                    if (!first) {
                        indexNames.append(", ");
                    } else {
                        first = false;
                    }
                    indexNames.append(index.getName());
                }
                throw new OCommandExecutionException("Property used in indexes (" + indexNames.toString() + "). Please drop these indexes before removing property or use FORCE parameter.");
            }
        }
        sourceClass.dropProperty(this.propertyName.getStringValue());
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "drop property");
        result.setProperty("className", this.className.getStringValue());
        result.setProperty("propertyname", this.propertyName.getStringValue());
        rs.add(result);
        return rs;
    }

    private List<OIndex<?>> relatedIndexes(String fieldName, ODatabase database) {
        ArrayList result = new ArrayList();
        for (OIndex<?> oIndex : database.getMetadata().getIndexManager().getClassIndexes(this.className.getStringValue())) {
            if (OCollections.indexOf(oIndex.getDefinition().getFields(), fieldName, new OCaseInsentiveComparator()) <= -1) continue;
            result.add(oIndex);
        }
        return result;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DROP PROPERTY ");
        this.className.toString(params, builder);
        builder.append(".");
        this.propertyName.toString(params, builder);
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        }
        if (this.force) {
            builder.append(" FORCE");
        }
    }

    @Override
    public ODropPropertyStatement copy() {
        ODropPropertyStatement result = new ODropPropertyStatement(-1);
        result.className = this.className == null ? null : this.className.copy();
        result.propertyName = this.propertyName == null ? null : this.propertyName.copy();
        result.force = this.force;
        result.ifExists = this.ifExists;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODropPropertyStatement that = (ODropPropertyStatement)o;
        if (this.force != that.force) {
            return false;
        }
        if (this.ifExists != that.ifExists) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        return !(this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        result = 31 * result + (this.force ? 1 : 0);
        return result;
    }
}

