/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.Map;

public class ODropClassStatement
extends ODDLStatement {
    public OIdentifier name;
    public boolean ifExists = false;
    public boolean unsafe = false;

    public ODropClassStatement(int id) {
        super(id);
    }

    public ODropClassStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeDDL(OCommandContext ctx) {
        OSchema schema = ctx.getDatabase().getMetadata().getSchema();
        OClass clazz = schema.getClass(this.name.getStringValue());
        if (clazz == null) {
            if (this.ifExists) {
                return new OInternalResultSet();
            }
            throw new OCommandExecutionException("Class " + this.name.getStringValue() + " does not exist");
        }
        if (!this.unsafe && clazz.count() > 0L) {
            if (clazz.isVertexType()) {
                throw new OCommandExecutionException("'DROP CLASS' command cannot drop class '" + this.name.getStringValue() + "' because it contains Vertices. Use 'DELETE VERTEX' command first to avoid broken edges in a database, or apply the 'UNSAFE' keyword to force it");
            }
            if (clazz.isEdgeType()) {
                throw new OCommandExecutionException("'DROP CLASS' command cannot drop class '" + this.name.getStringValue() + "' because it contains Edges. Use 'DELETE EDGE' command first to avoid broken vertices in a database, or apply the 'UNSAFE' keyword to force it");
            }
        }
        schema.dropClass(this.name.getStringValue());
        OInternalResultSet rs = new OInternalResultSet();
        OResultInternal result = new OResultInternal();
        result.setProperty("operation", "drop class");
        result.setProperty("className", this.name.getStringValue());
        rs.add(result);
        return rs;
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("DROP CLASS ");
        this.name.toString(params, builder);
        if (this.ifExists) {
            builder.append(" IF EXISTS");
        }
        if (this.unsafe) {
            builder.append(" UNSAFE");
        }
    }

    @Override
    public ODropClassStatement copy() {
        ODropClassStatement result = new ODropClassStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.ifExists = this.ifExists;
        result.unsafe = this.unsafe;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ODropClassStatement that = (ODropClassStatement)o;
        if (this.unsafe != that.unsafe) {
            return false;
        }
        if (this.ifExists != that.ifExists) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.unsafe ? 1 : 0);
        return result;
    }
}

