/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCreateUserStatement
extends OSimpleExecStatement {
    private static final String USER_FIELD_NAME = "name";
    private static final String USER_FIELD_PASSWORD = "password";
    private static final String USER_FIELD_STATUS = "status";
    private static final String USER_FIELD_ROLES = "roles";
    private static final String DEFAULT_STATUS = "ACTIVE";
    private static final String DEFAULT_ROLE = "writer";
    private static final String ROLE_CLASS = "ORole";
    private static final String ROLE_FIELD_NAME = "name";
    protected OIdentifier name;
    protected OIdentifier passwordIdentifier;
    protected String passwordString;
    protected List<OIdentifier> roles = new ArrayList<OIdentifier>();

    public OCreateUserStatement(int id) {
        super(id);
    }

    public OCreateUserStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public OResultSet executeSimple(OCommandContext ctx) {
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO OUser SET ");
        sb.append("name");
        sb.append("=?");
        params.add(this.name.getStringValue());
        sb.append(',');
        sb.append(USER_FIELD_PASSWORD);
        sb.append("=");
        if (this.passwordString != null) {
            sb.append(this.passwordString);
        } else {
            sb.append("?");
            params.add(this.passwordIdentifier.getStringValue());
        }
        sb.append(',');
        sb.append(USER_FIELD_STATUS);
        sb.append("='");
        sb.append(DEFAULT_STATUS);
        sb.append("'");
        ArrayList<OIdentifier> roles = new ArrayList<OIdentifier>();
        roles.addAll(this.roles);
        if (roles.size() == 0) {
            roles.add(new OIdentifier(DEFAULT_ROLE));
        }
        sb.append(',');
        sb.append(USER_FIELD_ROLES);
        sb.append("=(SELECT FROM ");
        sb.append(ROLE_CLASS);
        sb.append(" WHERE ");
        sb.append("name");
        sb.append(" IN [");
        OSecurity security = ctx.getDatabase().getMetadata().getSecurity();
        for (int i = 0; i < this.roles.size(); ++i) {
            String roleName = this.roles.get(i).getStringValue();
            ORole role = security.getRole(roleName);
            if (role == null) {
                throw new OCommandExecutionException("Cannot create user " + this.name + ": role " + roleName + " does not exist");
            }
            if (i > 0) {
                sb.append(", ");
            }
            if (roleName.startsWith("'") || roleName.startsWith("\"")) {
                sb.append(roleName);
                continue;
            }
            sb.append("'");
            sb.append(roleName);
            sb.append("'");
        }
        sb.append("])");
        return ctx.getDatabase().command(sb.toString(), params.toArray());
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        builder.append("CREATE USER ");
        this.name.toString(params, builder);
        builder.append(" IDENTIFIED BY ");
        if (this.passwordIdentifier != null) {
            this.passwordIdentifier.toString(params, builder);
        } else {
            builder.append(this.passwordString);
        }
        if (!this.roles.isEmpty()) {
            builder.append("ROLE [");
            boolean first = true;
            for (OIdentifier role : this.roles) {
                if (!first) {
                    builder.append(", ");
                }
                role.toString(params, builder);
                first = false;
            }
            builder.append("]");
        }
    }

    @Override
    public OCreateUserStatement copy() {
        OCreateUserStatement result = new OCreateUserStatement(-1);
        result.name = this.name == null ? null : this.name.copy();
        result.passwordIdentifier = this.passwordIdentifier == null ? null : this.passwordIdentifier.copy();
        result.passwordString = this.passwordString;
        this.roles.forEach(x -> result.roles.add(x.copy()));
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCreateUserStatement that = (OCreateUserStatement)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.passwordIdentifier != null ? !this.passwordIdentifier.equals(that.passwordIdentifier) : that.passwordIdentifier != null) {
            return false;
        }
        if (this.passwordString != null ? !this.passwordString.equals(that.passwordString) : that.passwordString != null) {
            return false;
        }
        return this.roles != null ? this.roles.equals(that.roles) : that.roles == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.passwordIdentifier != null ? this.passwordIdentifier.hashCode() : 0);
        result = 31 * result + (this.passwordString != null ? this.passwordString.hashCode() : 0);
        result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
        return result;
    }
}

