/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OBaseIdentifier;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OCollection;
import com.orientechnologies.orient.core.sql.parser.OEqualsCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFunctionCall;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLevelZeroIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLuceneOperator;
import com.orientechnologies.orient.core.sql.parser.OUpdateItem;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class OBinaryCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OBinaryCompareOperator operator;
    protected OExpression right;

    public OBinaryCondition(int id) {
        super(id);
    }

    public OBinaryCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord, OCommandContext ctx) {
        return this.operator.execute(this.left.execute(currentRecord, ctx), this.right.execute(currentRecord, ctx));
    }

    @Override
    public boolean evaluate(OResult currentRecord, OCommandContext ctx) {
        Object leftVal = this.left.execute(currentRecord, ctx);
        Object rightVal = this.right.execute(currentRecord, ctx);
        OCollate collate = this.left.getCollate(currentRecord, ctx);
        if (collate == null) {
            collate = this.right.getCollate(currentRecord, ctx);
        }
        if (collate != null) {
            leftVal = collate.transform(leftVal);
            rightVal = collate.transform(rightVal);
        }
        return this.operator.execute(leftVal, rightVal);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        this.left.toString(params, builder);
        builder.append(" ");
        builder.append(this.operator.toString());
        builder.append(" ");
        this.right.toString(params, builder);
    }

    @Override
    protected boolean supportsBasicCalculation() {
        if (!this.operator.supportsBasicCalculation()) {
            return false;
        }
        return this.left.supportsBasicCalculation() && this.right.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (!this.operator.supportsBasicCalculation()) {
            ++total;
        }
        if (!this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (!this.right.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (!this.operator.supportsBasicCalculation()) {
            result.add(this);
        }
        if (!this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (!this.right.supportsBasicCalculation()) {
            result.add(this.right);
        }
        return result;
    }

    public OBinaryCondition isIndexedFunctionCondition(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.left.isIndexedFunctionCal()) {
            return this;
        }
        return null;
    }

    public long estimateIndexed(OFromClause target, OCommandContext context) {
        return this.left.estimateIndexedFunction(target, context, this.operator, this.right.execute((OResult)null, context));
    }

    public Iterable<OIdentifiable> executeIndexedFunction(OFromClause target, OCommandContext context) {
        return this.left.executeIndexedFunction(target, context, this.operator, this.right.execute((OResult)null, context));
    }

    public boolean canExecuteIndexedFunctionWithoutIndex(OFromClause target, OCommandContext context) {
        return this.left.canExecuteIndexedFunctionWithoutIndex(target, context, this.operator, this.right.execute((OResult)null, context));
    }

    public boolean allowsIndexedFunctionExecutionOnTarget(OFromClause target, OCommandContext context) {
        return this.left.allowsIndexedFunctionExecutionOnTarget(target, context, this.operator, this.right.execute((OResult)null, context));
    }

    public boolean executeIndexedFunctionAfterIndexSearch(OFromClause target, OCommandContext context) {
        return this.left.executeIndexedFunctionAfterIndexSearch(target, context, this.operator, this.right.execute((OResult)null, context));
    }

    @Override
    public List<OBinaryCondition> getIndexedFunctionConditions(OClass iSchemaClass, ODatabaseDocumentInternal database) {
        if (this.left.isIndexedFunctionCal()) {
            return Collections.singletonList(this);
        }
        return null;
    }

    @Override
    public boolean needsAliases(Set<String> aliases) {
        if (this.left.needsAliases(aliases)) {
            return true;
        }
        return this.right.needsAliases(aliases);
    }

    @Override
    public OBinaryCondition copy() {
        OBinaryCondition result = new OBinaryCondition(-1);
        result.left = this.left.copy();
        result.operator = this.operator.copy();
        result.right = this.right.copy();
        return result;
    }

    @Override
    public void extractSubQueries(SubQueryCollector collector) {
        this.left.extractSubQueries(collector);
        this.right.extractSubQueries(collector);
    }

    @Override
    public boolean refersToParent() {
        return this.left.refersToParent() || this.right.refersToParent();
    }

    @Override
    public Optional<OUpdateItem> transformToUpdateItem() {
        if (!this.checkCanTransformToUpdate()) {
            return Optional.empty();
        }
        if (this.operator instanceof OEqualsCompareOperator) {
            OUpdateItem result = new OUpdateItem(-1);
            result.operator = 0;
            OBaseExpression baseExp = (OBaseExpression)this.left.mathExpression;
            result.left = baseExp.identifier.suffix.identifier.copy();
            result.leftModifier = baseExp.modifier == null ? null : baseExp.modifier.copy();
            result.right = this.right.copy();
            return Optional.of(result);
        }
        return super.transformToUpdateItem();
    }

    private boolean checkCanTransformToUpdate() {
        if (this.left == null || this.left.mathExpression == null || !(this.left.mathExpression instanceof OBaseExpression)) {
            return false;
        }
        OBaseExpression base = (OBaseExpression)this.left.mathExpression;
        return base.identifier != null && base.identifier.suffix != null && base.identifier.suffix.identifier != null;
    }

    public OExpression getLeft() {
        return this.left;
    }

    public OBinaryCompareOperator getOperator() {
        return this.operator;
    }

    public OExpression getRight() {
        return this.right;
    }

    public void setLeft(OExpression left) {
        this.left = left;
    }

    public void setOperator(OBinaryCompareOperator operator) {
        this.operator = operator;
    }

    public void setRight(OExpression right) {
        this.right = right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OBinaryCondition that = (OBinaryCondition)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) {
            return false;
        }
        return !(this.right != null ? !this.right.equals(that.right) : that.right != null);
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    @Override
    public List<String> getMatchPatternInvolvedAliases() {
        List<String> leftX = this.left.getMatchPatternInvolvedAliases();
        List<String> rightX = this.right.getMatchPatternInvolvedAliases();
        if (leftX == null) {
            return rightX;
        }
        if (rightX == null) {
            return leftX;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(leftX);
        result.addAll(rightX);
        return result;
    }

    @Override
    public void translateLuceneOperator() {
        if (this.operator instanceof OLuceneOperator) {
            OFunctionCall function;
            OBaseIdentifier identifirer;
            OExpression newLeft = new OExpression(-1);
            newLeft.mathExpression = new OBaseExpression(-1);
            ((OBaseExpression)newLeft.mathExpression).identifier = identifirer = new OBaseIdentifier(-1);
            identifirer.levelZero = new OLevelZeroIdentifier(-1);
            identifirer.levelZero.functionCall = function = new OFunctionCall(-1);
            function.name = new OIdentifier("search_fields");
            function.params = new ArrayList<OExpression>();
            function.params.add(this.fieldNamesToStrings(this.left));
            function.params.add(this.right);
            this.left = newLeft;
            this.operator = new OEqualsCompareOperator(-1);
            this.right = new OExpression(-1);
            this.right.booleanValue = true;
        }
    }

    private OExpression fieldNamesToStrings(OExpression left) {
        if (left.isBaseIdentifier()) {
            OIdentifier identifier = ((OBaseExpression)left.mathExpression).identifier.suffix.identifier;
            OCollection newColl = new OCollection(-1);
            newColl.expressions = new ArrayList<OExpression>();
            newColl.expressions.add(this.identifierToStringExpr(identifier));
            OExpression result = new OExpression(-1);
            OBaseExpression newBase = new OBaseExpression(-1);
            result.mathExpression = newBase;
            newBase.identifier = new OBaseIdentifier(-1);
            newBase.identifier.levelZero = new OLevelZeroIdentifier(-1);
            newBase.identifier.levelZero.collection = newColl;
            return result;
        }
        if (left.mathExpression instanceof OBaseExpression) {
            OBaseExpression base = (OBaseExpression)left.mathExpression;
            if (base.identifier != null && base.identifier.levelZero != null && base.identifier.levelZero.collection != null) {
                OCollection coll = base.identifier.levelZero.collection;
                OCollection newColl = new OCollection(-1);
                newColl.expressions = new ArrayList<OExpression>();
                for (OExpression exp : coll.expressions) {
                    if (exp.isBaseIdentifier()) {
                        OIdentifier identifier = ((OBaseExpression)exp.mathExpression).identifier.suffix.identifier;
                        OExpression val = this.identifierToStringExpr(identifier);
                        newColl.expressions.add(val);
                        continue;
                    }
                    throw new OCommandExecutionException("Cannot execute because of invalid LUCENE expression");
                }
                OExpression result = new OExpression(-1);
                OBaseExpression newBase = new OBaseExpression(-1);
                result.mathExpression = newBase;
                newBase.identifier = new OBaseIdentifier(-1);
                newBase.identifier.levelZero = new OLevelZeroIdentifier(-1);
                newBase.identifier.levelZero.collection = newColl;
                return result;
            }
        }
        throw new OCommandExecutionException("Cannot execute because of invalid LUCENE expression");
    }

    private OExpression identifierToStringExpr(OIdentifier identifier) {
        OBaseExpression bexp = new OBaseExpression(identifier.getStringValue());
        OExpression result = new OExpression(-1);
        result.mathExpression = bexp;
        return result;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("left", this.left.serialize());
        result.setProperty("operator", this.operator.getClass().getName());
        result.setProperty("right", this.right.serialize());
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        this.left = new OExpression(-1);
        this.left.deserialize((OResult)fromResult.getProperty("left"));
        try {
            this.operator = (OBinaryCompareOperator)Class.forName(String.valueOf((char[])fromResult.getProperty("operator"))).newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
        this.right = new OExpression(-1);
        this.right.deserialize((OResult)fromResult.getProperty("right"));
    }

    @Override
    public boolean isCacheable() {
        return this.left.isCacheable() && this.right.isCacheable();
    }
}

