/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.parser.OArrayNumberSelector;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import com.orientechnologies.orient.core.sql.parser.SubQueryCollector;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OArrayRangeSelector
extends SimpleNode {
    protected Integer from;
    protected Integer to;
    protected boolean newRange = false;
    protected boolean included = false;
    protected OArrayNumberSelector fromSelector;
    protected OArrayNumberSelector toSelector;

    public OArrayRangeSelector(int id) {
        super(id);
    }

    public OArrayRangeSelector(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void toString(Map<Object, Object> params, StringBuilder builder) {
        if (this.from != null) {
            builder.append(this.from);
        } else {
            this.fromSelector.toString(params, builder);
        }
        if (this.newRange) {
            builder.append("..");
            if (this.included) {
                builder.append('.');
            }
        } else {
            builder.append("-");
        }
        if (this.to != null) {
            builder.append(this.to);
        } else {
            this.toSelector.toString(params, builder);
        }
    }

    public Object execute(OIdentifiable iCurrentRecord, Object result, OCommandContext ctx) {
        if (result == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(result)) {
            return null;
        }
        Integer lFrom = this.from;
        if (this.fromSelector != null) {
            lFrom = this.fromSelector.getValue(iCurrentRecord, result, ctx);
        }
        if (lFrom == null) {
            lFrom = 0;
        }
        Integer lTo = this.to;
        if (this.toSelector != null) {
            lTo = this.toSelector.getValue(iCurrentRecord, result, ctx);
        }
        if (this.included) {
            Integer n = lTo;
            Integer n2 = lTo = Integer.valueOf(lTo + 1);
        }
        if (lFrom > lTo) {
            return null;
        }
        Object[] arrayResult = OMultiValue.array(result);
        if (arrayResult == null || arrayResult.length == 0) {
            return arrayResult;
        }
        if (arrayResult.length < (lFrom = Integer.valueOf(Math.max(lFrom, 0)))) {
            return null;
        }
        lFrom = Math.min(lFrom, arrayResult.length - 1);
        lTo = Math.min(lTo, arrayResult.length);
        return Arrays.asList(Arrays.copyOfRange(arrayResult, (int)lFrom, (int)lTo));
    }

    public Object execute(OResult iCurrentRecord, Object result, OCommandContext ctx) {
        if (result == null) {
            return null;
        }
        if (!OMultiValue.isMultiValue(result)) {
            return null;
        }
        Integer lFrom = this.from;
        if (this.fromSelector != null) {
            lFrom = this.fromSelector.getValue(iCurrentRecord, result, ctx);
        }
        if (lFrom == null) {
            lFrom = 0;
        }
        Integer lTo = this.to;
        if (this.toSelector != null) {
            lTo = this.toSelector.getValue(iCurrentRecord, result, ctx);
        }
        if (this.included) {
            Integer n = lTo;
            Integer n2 = lTo = Integer.valueOf(lTo + 1);
        }
        if (lFrom > lTo) {
            return null;
        }
        Object[] arrayResult = OMultiValue.array(result);
        if (arrayResult == null || arrayResult.length == 0) {
            return arrayResult;
        }
        if (arrayResult.length < (lFrom = Integer.valueOf(Math.max(lFrom, 0)))) {
            return null;
        }
        lFrom = Math.min(lFrom, arrayResult.length - 1);
        lTo = Math.min(lTo, arrayResult.length);
        return Arrays.asList(Arrays.copyOfRange(arrayResult, (int)lFrom, (int)lTo));
    }

    public boolean needsAliases(Set<String> aliases) {
        if (this.fromSelector != null && this.fromSelector.needsAliases(aliases)) {
            return true;
        }
        return this.toSelector != null && this.toSelector.needsAliases(aliases);
    }

    @Override
    public OArrayRangeSelector copy() {
        OArrayRangeSelector result = new OArrayRangeSelector(-1);
        result.from = this.from;
        result.to = this.to;
        result.newRange = this.newRange;
        result.included = this.included;
        result.fromSelector = this.fromSelector == null ? null : this.fromSelector.copy();
        result.toSelector = this.toSelector == null ? null : this.toSelector.copy();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OArrayRangeSelector that = (OArrayRangeSelector)o;
        if (this.newRange != that.newRange) {
            return false;
        }
        if (this.included != that.included) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.to != null ? !this.to.equals(that.to) : that.to != null) {
            return false;
        }
        if (this.fromSelector != null ? !this.fromSelector.equals(that.fromSelector) : that.fromSelector != null) {
            return false;
        }
        return !(this.toSelector != null ? !this.toSelector.equals(that.toSelector) : that.toSelector != null);
    }

    public int hashCode() {
        int result = this.from != null ? this.from.hashCode() : 0;
        result = 31 * result + (this.to != null ? this.to.hashCode() : 0);
        result = 31 * result + (this.newRange ? 1 : 0);
        result = 31 * result + (this.included ? 1 : 0);
        result = 31 * result + (this.fromSelector != null ? this.fromSelector.hashCode() : 0);
        result = 31 * result + (this.toSelector != null ? this.toSelector.hashCode() : 0);
        return result;
    }

    public void extractSubQueries(SubQueryCollector collector) {
        if (this.fromSelector != null) {
            this.fromSelector.extractSubQueries(collector);
        }
        if (this.toSelector != null) {
            this.toSelector.extractSubQueries(collector);
        }
    }

    public boolean refersToParent() {
        if (this.fromSelector != null && this.fromSelector.refersToParent()) {
            return true;
        }
        return this.toSelector != null && this.toSelector.refersToParent();
    }

    public void setValue(Object target, Object value, OCommandContext ctx) {
        if (target == null) {
            return;
        }
        if (target.getClass().isArray()) {
            this.setArrayValue(target, value, ctx);
        } else if (target instanceof List) {
            this.setValue((List)target, value, ctx);
        } else if (OMultiValue.isMultiValue(value)) {
            // empty if block
        }
    }

    public void setValue(List target, Object value, OCommandContext ctx) {
        int from = this.from == null ? 0 : this.from;
        int to = target.size() - 1;
        if (this.to != null) {
            to = this.to;
            if (!this.included) {
                --to;
            }
        }
        if (from > to) {
            target.clear();
            return;
        }
        for (int i = 0; i <= to; ++i) {
            if (i < from && target.size() - 1 < i) {
                target.set(i, null);
                continue;
            }
            if (i < from) continue;
            target.set(i, value);
        }
    }

    public void setValue(Set target, Object value, OCommandContext ctx) {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        int from = this.from == null ? 0 : this.from;
        int to = target.size() - 1;
        if (this.to != null) {
            to = this.to;
            if (!this.included) {
                --to;
            }
        }
        if (from > to) {
            target.clear();
            return;
        }
        Iterator targetIterator = target.iterator();
        for (int i = 0; i <= to; ++i) {
            Object next = null;
            if (targetIterator.hasNext()) {
                next = targetIterator.next();
            }
            if (i < from && target.size() - 1 < i) {
                result.add(null);
            } else if (i >= from) {
                result.add(value);
            } else {
                result.add(next);
            }
            target.clear();
            target.addAll(result);
        }
    }

    public void setValue(Map target, Object value, OCommandContext ctx) {
        int from = this.from == null ? 0 : this.from;
        int to = this.to;
        if (!this.included) {
            --to;
        }
        if (from > to) {
            target.clear();
            return;
        }
        for (int i = from; i <= to; ++i) {
            target.put(i, value);
        }
    }

    private void setArrayValue(Object target, Object value, OCommandContext ctx) {
        int from = this.from == null ? 0 : this.from;
        int to = Array.getLength(target) - 1;
        if (this.to != null) {
            to = this.to;
            if (!this.included) {
                --to;
            }
        }
        if (from > to || from >= Array.getLength(target)) {
            return;
        }
        to = Math.min(to, Array.getLength(target) - 1);
        for (int i = from; i <= to; ++i) {
            Array.set(target, i, value);
        }
    }

    public void applyRemove(Object currentValue, OResultInternal originalRecord, OCommandContext ctx) {
        if (currentValue == null) {
            return;
        }
        Integer from = this.from;
        if (this.fromSelector != null) {
            from = this.fromSelector.getValue(originalRecord, null, ctx);
        }
        Integer to = this.to;
        if (this.toSelector != null) {
            to = this.toSelector.getValue(originalRecord, null, ctx);
        }
        if (from == null || to == null) {
            throw new OCommandExecutionException("Invalid range expression: " + this.toString() + " one of the elements is null");
        }
        if (this.included) {
            Integer n = to;
            Integer n2 = to = Integer.valueOf(to + 1);
        }
        if (from < 0) {
            from = 0;
        }
        if (from >= to) {
            return;
        }
        int range = to - from;
        if (currentValue instanceof List) {
            List list = (List)currentValue;
            for (int i = 0; i < range && list.size() > from; ++i) {
                list.remove(from);
            }
        } else if (currentValue instanceof Set) {
            Iterator iter = ((Set)currentValue).iterator();
            int count = 0;
            while (iter.hasNext()) {
                iter.next();
                if (count >= from) {
                    if (count >= to) break;
                    iter.remove();
                }
                ++count;
            }
        } else {
            throw new OCommandExecutionException("Trying to remove elements from " + currentValue + " (" + currentValue.getClass().getSimpleName() + ")");
        }
    }

    public OResult serialize() {
        OResultInternal result = new OResultInternal();
        result.setProperty("from", this.from);
        result.setProperty("to", this.to);
        result.setProperty("newRange", this.newRange);
        result.setProperty("included", this.included);
        if (this.fromSelector != null) {
            result.setProperty("fromSelector", this.fromSelector.serialize());
        }
        if (this.toSelector != null) {
            result.setProperty("toSelector", this.toSelector.serialize());
        }
        return result;
    }

    public void deserialize(OResult fromResult) {
        this.from = (Integer)fromResult.getProperty("from");
        this.to = (Integer)fromResult.getProperty("to");
        this.newRange = (Boolean)fromResult.getProperty("newRange");
        this.included = (Boolean)fromResult.getProperty("included");
        if (fromResult.getProperty("fromSelector") != null) {
            this.fromSelector = new OArrayNumberSelector(-1);
            this.fromSelector.deserialize((OResult)fromResult.getProperty("fromSelector"));
        }
        if (fromResult.getProperty("toSelector") != null) {
            this.toSelector = new OArrayNumberSelector(-1);
            this.toSelector.deserialize((OResult)fromResult.getProperty("toSelector"));
        }
    }
}

