/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OSkip;

public class SkipExecutionStep
extends AbstractExecutionStep {
    private final OSkip skip;
    int skipped = 0;
    OResultSet lastFetch;
    private boolean finished;

    public SkipExecutionStep(OSkip skip, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.skip = skip;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        if (this.finished) {
            return new OInternalResultSet();
        }
        int skipValue = this.skip.getValue(ctx);
        while (this.skipped < skipValue) {
            OResultSet rs = ((OExecutionStepInternal)this.prev.get()).syncPull(ctx, Math.min(100, skipValue - this.skipped));
            if (!rs.hasNext()) {
                this.finished = true;
                return new OInternalResultSet();
            }
            while (rs.hasNext()) {
                rs.next();
                ++this.skipped;
            }
        }
        return ((OExecutionStepInternal)this.prev.get()).syncPull(ctx, nRecords);
    }

    @Override
    public void sendTimeout() {
    }

    @Override
    public void close() {
        this.prev.ifPresent(x -> x.close());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        return OExecutionStepInternal.getIndent(depth, indent) + "+ SKIP (" + this.skip.toString() + ")";
    }
}

