/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OSimpleExecStatement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class OSingleOpExecutionPlan
implements OInternalExecutionPlan {
    private final OSimpleExecStatement statement;
    OCommandContext ctx;
    boolean executed = false;
    private OResultSet result;

    public OSingleOpExecutionPlan(OCommandContext ctx, OSimpleExecStatement stm) {
        this.ctx = ctx;
        this.statement = stm;
    }

    @Override
    public void close() {
    }

    @Override
    public OResultSet fetchNext(final int n) {
        if (this.executed && this.result == null) {
            throw new OCommandExecutionException("Trying to execute a result-set twice. Please use reset()");
        }
        if (!this.executed) {
            this.executed = true;
            this.result = this.statement.executeSimple(this.ctx);
            if (this.result instanceof OInternalResultSet) {
                ((OInternalResultSet)this.result).plan = this;
            }
        }
        return new OResultSet(){
            int fetched = 0;

            @Override
            public boolean hasNext() {
                return this.fetched < n && OSingleOpExecutionPlan.this.result.hasNext();
            }

            @Override
            public OResult next() {
                if (this.fetched >= n) {
                    throw new IllegalStateException();
                }
                ++this.fetched;
                return OSingleOpExecutionPlan.this.result.next();
            }

            @Override
            public void close() {
                OSingleOpExecutionPlan.this.result.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public void reset(OCommandContext ctx) {
        this.executed = false;
    }

    @Override
    public long getCost() {
        return 0L;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    public OResultSet executeInternal(OBasicCommandContext ctx) throws OCommandExecutionException {
        if (this.executed) {
            throw new OCommandExecutionException("Trying to execute a result-set twice. Please use reset()");
        }
        this.executed = true;
        OResultSet result = this.statement.executeSimple(this.ctx);
        if (result instanceof OInternalResultSet) {
            ((OInternalResultSet)result).plan = this;
        }
        return result;
    }

    @Override
    public List<OExecutionStep> getSteps() {
        return Collections.emptyList();
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ ");
        result.append(this.statement.toString());
        return result.toString();
    }

    @Override
    public OResult toResult() {
        OResultInternal result = new OResultInternal();
        result.setProperty("type", "QueryExecutionPlan");
        result.setProperty("javaType", this.getClass().getName());
        result.setProperty("stmText", this.statement.toString());
        result.setProperty("cost", this.getCost());
        result.setProperty("prettyPrint", this.prettyPrint(0, 2));
        result.setProperty("steps", null);
        return result;
    }
}

