/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.BatchStep;
import com.orientechnologies.orient.core.sql.executor.ConvertToResultInternalStep;
import com.orientechnologies.orient.core.sql.executor.ConvertToUpdatableResultStep;
import com.orientechnologies.orient.core.sql.executor.CopyRecordContentBeforeUpdateStep;
import com.orientechnologies.orient.core.sql.executor.CountStep;
import com.orientechnologies.orient.core.sql.executor.LimitExecutionStep;
import com.orientechnologies.orient.core.sql.executor.MoveVertexStep;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.ProjectionCalculationStep;
import com.orientechnologies.orient.core.sql.executor.SaveElementStep;
import com.orientechnologies.orient.core.sql.executor.SubQueryStep;
import com.orientechnologies.orient.core.sql.executor.TimeoutStep;
import com.orientechnologies.orient.core.sql.executor.UnwrapPreviousValueStep;
import com.orientechnologies.orient.core.sql.executor.UpdateContentStep;
import com.orientechnologies.orient.core.sql.executor.UpdateMergeStep;
import com.orientechnologies.orient.core.sql.executor.UpdateRemoveStep;
import com.orientechnologies.orient.core.sql.executor.UpdateSetStep;
import com.orientechnologies.orient.core.sql.executor.UpsertStep;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OCluster;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OFromItem;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OMoveVertexStatement;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import com.orientechnologies.orient.core.sql.parser.OUpdateOperations;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.storage.OStorage;

public class OMoveVertexExecutionPlanner {
    private final OFromItem source;
    private final OIdentifier targetClass;
    private final OCluster targetCluster;
    private final OUpdateOperations updateOperations;
    private final OBatch batch;

    public OMoveVertexExecutionPlanner(OMoveVertexStatement oStatement) {
        this.source = oStatement.getSource();
        this.targetClass = oStatement.getTargetClass();
        this.targetCluster = oStatement.getTargetCluster();
        this.updateOperations = oStatement.getUpdateOperations();
        this.batch = oStatement.getBatch();
    }

    public OUpdateExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        OUpdateExecutionPlan result = new OUpdateExecutionPlan(ctx);
        this.handleSource(result, ctx, this.source, enableProfiling);
        this.convertToModifiableResult(result, ctx, enableProfiling);
        this.handleTarget(result, this.targetClass, this.targetCluster, ctx, enableProfiling);
        this.handleOperations(result, ctx, this.updateOperations, enableProfiling);
        this.handleBatch(result, ctx, this.batch, enableProfiling);
        this.handleSave(result, ctx, enableProfiling);
        return result;
    }

    private void handleTarget(OUpdateExecutionPlan result, OIdentifier targetClass, OCluster targetCluster, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new MoveVertexStep(targetClass, targetCluster, ctx, profilingEnabled));
    }

    private void handleBatch(OUpdateExecutionPlan result, OCommandContext ctx, OBatch batch, boolean profilingEnabled) {
        if (batch != null) {
            result.chain(new BatchStep(batch, ctx, profilingEnabled));
        }
    }

    private void convertToModifiableResult(OUpdateExecutionPlan plan, OCommandContext ctx, boolean profilingEnabled) {
        plan.chain(new ConvertToUpdatableResultStep(ctx, profilingEnabled));
    }

    private void handleResultForReturnCount(OUpdateExecutionPlan result, OCommandContext ctx, boolean returnCount, boolean profilingEnabled) {
        if (returnCount) {
            result.chain(new CountStep(ctx, profilingEnabled));
        }
    }

    private void handleResultForReturnAfter(OUpdateExecutionPlan result, OCommandContext ctx, boolean returnAfter, OProjection returnProjection, boolean profilingEnabled) {
        if (returnAfter) {
            result.chain(new ConvertToResultInternalStep(ctx, profilingEnabled));
            if (returnProjection != null) {
                result.chain(new ProjectionCalculationStep(returnProjection, ctx, profilingEnabled));
            }
        }
    }

    private void handleResultForReturnBefore(OUpdateExecutionPlan result, OCommandContext ctx, boolean returnBefore, OProjection returnProjection, boolean profilingEnabled) {
        if (returnBefore) {
            result.chain(new UnwrapPreviousValueStep(ctx, profilingEnabled));
            if (returnProjection != null) {
                result.chain(new ProjectionCalculationStep(returnProjection, ctx, profilingEnabled));
            }
        }
    }

    private void handleSave(OUpdateExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new SaveElementStep(ctx, profilingEnabled));
    }

    private void handleTimeout(OUpdateExecutionPlan result, OCommandContext ctx, OTimeout timeout, boolean profilingEnabled) {
        if (timeout != null && timeout.getVal().longValue() > 0L) {
            result.chain(new TimeoutStep(timeout, ctx, profilingEnabled));
        }
    }

    private void handleReturnBefore(OUpdateExecutionPlan result, OCommandContext ctx, boolean returnBefore, boolean profilingEnabled) {
        if (returnBefore) {
            result.chain(new CopyRecordContentBeforeUpdateStep(ctx, profilingEnabled));
        }
    }

    private void handleLock(OUpdateExecutionPlan result, OCommandContext ctx, OStorage.LOCKING_STRATEGY lockRecord) {
    }

    private void handleLimit(OUpdateExecutionPlan plan, OCommandContext ctx, OLimit limit, boolean profilingEnabled) {
        if (limit != null) {
            plan.chain(new LimitExecutionStep(limit, ctx, profilingEnabled));
        }
    }

    private void handleUpsert(OUpdateExecutionPlan plan, OCommandContext ctx, OFromClause target, OWhereClause where, boolean upsert, boolean profilingEnabled) {
        if (upsert) {
            plan.chain(new UpsertStep(target, where, ctx, profilingEnabled));
        }
    }

    private void handleOperations(OUpdateExecutionPlan plan, OCommandContext ctx, OUpdateOperations op, boolean profilingEnabled) {
        if (op != null) {
            switch (op.getType()) {
                case 0: {
                    plan.chain(new UpdateSetStep(op.getUpdateItems(), ctx, profilingEnabled));
                    break;
                }
                case 6: {
                    plan.chain(new UpdateRemoveStep(op.getUpdateRemoveItems(), ctx, profilingEnabled));
                    break;
                }
                case 2: {
                    plan.chain(new UpdateMergeStep(op.getJson(), ctx, profilingEnabled));
                    break;
                }
                case 3: {
                    plan.chain(new UpdateContentStep(op.getJson(), ctx, profilingEnabled));
                    break;
                }
                case 1: 
                case 4: 
                case 5: {
                    throw new OCommandExecutionException("Cannot execute with UPDATE PUT/ADD/INCREMENT new executor: " + op);
                }
            }
        }
    }

    private void handleSource(OUpdateExecutionPlan result, OCommandContext ctx, OFromItem source, boolean profilingEnabled) {
        OSelectStatement sourceStatement = new OSelectStatement(-1);
        sourceStatement.setTarget(new OFromClause(-1));
        sourceStatement.getTarget().setItem(source);
        OSelectExecutionPlanner planner = new OSelectExecutionPlanner(sourceStatement);
        result.chain(new SubQueryStep(planner.createExecutionPlan(ctx, profilingEnabled), ctx, ctx, profilingEnabled));
    }
}

