/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.IfStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collections;
import java.util.List;

public class OIfExecutionPlan
implements OInternalExecutionPlan {
    private String location;
    private final OCommandContext ctx;
    protected IfStep step;

    public OIfExecutionPlan(OCommandContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void reset(OCommandContext ctx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.step.close();
    }

    @Override
    public OResultSet fetchNext(int n) {
        return this.step.syncPull(this.ctx, n);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder result = new StringBuilder();
        result.append(this.step.prettyPrint(depth, indent));
        return result.toString();
    }

    public void chain(IfStep step) {
        this.step = step;
    }

    @Override
    public List<OExecutionStep> getSteps() {
        return Collections.singletonList(this.step);
    }

    public void setSteps(List<OExecutionStepInternal> steps) {
        this.step = (IfStep)steps.get(0);
    }

    @Override
    public OResult toResult() {
        OResultInternal result = new OResultInternal();
        result.setProperty("type", "IfExecutionPlan");
        result.setProperty("javaType", this.getClass().getName());
        result.setProperty("cost", this.getCost());
        result.setProperty("prettyPrint", this.prettyPrint(0, 2));
        result.setProperty("steps", Collections.singletonList(this.step.toResult()));
        return result;
    }

    @Override
    public long getCost() {
        return 0L;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    public boolean containsReturn() {
        return this.step.getPositivePlan().containsReturn() || this.step.getNegativePlan() != null && this.step.getPositivePlan().containsReturn();
    }

    public OExecutionStepInternal executeUntilReturn() {
        this.step.init(this.ctx);
        return this.step;
    }
}

