/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.CastToVertexStep;
import com.orientechnologies.orient.core.sql.executor.CheckSafeDeleteStep;
import com.orientechnologies.orient.core.sql.executor.CountStep;
import com.orientechnologies.orient.core.sql.executor.DeleteStep;
import com.orientechnologies.orient.core.sql.executor.LimitExecutionStep;
import com.orientechnologies.orient.core.sql.executor.ODeleteExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OSelectExecutionPlanner;
import com.orientechnologies.orient.core.sql.executor.OUpdateExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.SubQueryStep;
import com.orientechnologies.orient.core.sql.parser.ODeleteVertexStatement;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OIndexIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OSelectStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;

public class ODeleteVertexExecutionPlanner {
    private final OFromClause fromClause;
    private final OWhereClause whereClause;
    private final boolean returnBefore;
    private final OLimit limit;

    public ODeleteVertexExecutionPlanner(ODeleteVertexStatement stm) {
        this.fromClause = stm.getFromClause() == null ? null : stm.getFromClause().copy();
        this.whereClause = stm.getWhereClause() == null ? null : stm.getWhereClause().copy();
        this.returnBefore = stm.isReturnBefore();
        this.limit = stm.getLimit() == null ? null : stm.getLimit();
    }

    public ODeleteExecutionPlan createExecutionPlan(OCommandContext ctx, boolean enableProfiling) {
        ODeleteExecutionPlan result = new ODeleteExecutionPlan(ctx);
        if (this.handleIndexAsTarget(result, this.fromClause.getItem().getIndex(), this.whereClause, ctx)) {
            if (this.limit != null) {
                throw new OCommandExecutionException("Cannot apply a LIMIT on a delete from index");
            }
            if (this.returnBefore) {
                throw new OCommandExecutionException("Cannot apply a RETURN BEFORE on a delete from index");
            }
        } else {
            this.handleTarget(result, ctx, this.fromClause, this.whereClause, enableProfiling);
            this.handleLimit(result, ctx, this.limit, enableProfiling);
        }
        this.handleCastToVertex(result, ctx, enableProfiling);
        this.handleDelete(result, ctx, enableProfiling);
        this.handleReturn(result, ctx, this.returnBefore, enableProfiling);
        return result;
    }

    private boolean handleIndexAsTarget(ODeleteExecutionPlan result, OIndexIdentifier indexIdentifier, OWhereClause whereClause, OCommandContext ctx) {
        if (indexIdentifier == null) {
            return false;
        }
        throw new OCommandExecutionException("DELETE VERTEX FROM INDEX is not supported");
    }

    private void handleDelete(ODeleteExecutionPlan result, OCommandContext ctx, boolean profilingEnabled) {
        result.chain(new DeleteStep(ctx, profilingEnabled));
    }

    private void handleUnsafe(ODeleteExecutionPlan result, OCommandContext ctx, boolean unsafe, boolean profilingEnabled) {
        if (!unsafe) {
            result.chain(new CheckSafeDeleteStep(ctx, profilingEnabled));
        }
    }

    private void handleReturn(ODeleteExecutionPlan result, OCommandContext ctx, boolean returnBefore, boolean profilingEnabled) {
        if (!returnBefore) {
            result.chain(new CountStep(ctx, profilingEnabled));
        }
    }

    private void handleLimit(OUpdateExecutionPlan plan, OCommandContext ctx, OLimit limit, boolean profilingEnabled) {
        if (limit != null) {
            plan.chain(new LimitExecutionStep(limit, ctx, profilingEnabled));
        }
    }

    private void handleCastToVertex(ODeleteExecutionPlan plan, OCommandContext ctx, boolean profilingEnabled) {
        plan.chain(new CastToVertexStep(ctx, profilingEnabled));
    }

    private void handleTarget(OUpdateExecutionPlan result, OCommandContext ctx, OFromClause target, OWhereClause whereClause, boolean profilingEnabled) {
        OSelectStatement sourceStatement = new OSelectStatement(-1);
        sourceStatement.setTarget(target);
        sourceStatement.setWhereClause(whereClause);
        OSelectExecutionPlanner planner = new OSelectExecutionPlanner(sourceStatement);
        result.chain(new SubQueryStep(planner.createExecutionPlan(ctx, profilingEnabled), ctx, ctx, profilingEnabled));
    }
}

