/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.ODDLStatement;
import java.util.Collections;
import java.util.List;

public class ODDLExecutionPlan
implements OInternalExecutionPlan {
    private final ODDLStatement statement;
    OCommandContext ctx;
    boolean executed = false;

    public ODDLExecutionPlan(OCommandContext ctx, ODDLStatement stm) {
        this.ctx = ctx;
        this.statement = stm;
    }

    @Override
    public void close() {
    }

    @Override
    public OResultSet fetchNext(int n) {
        return null;
    }

    @Override
    public void reset(OCommandContext ctx) {
        this.executed = false;
    }

    @Override
    public long getCost() {
        return 0L;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    public OResultSet executeInternal(OBasicCommandContext ctx) throws OCommandExecutionException {
        if (this.executed) {
            throw new OCommandExecutionException("Trying to execute a result-set twice. Please use reset()");
        }
        this.executed = true;
        OResultSet result = this.statement.executeDDL(this.ctx);
        if (result instanceof OInternalResultSet) {
            ((OInternalResultSet)result).plan = this;
        }
        return result;
    }

    @Override
    public List<OExecutionStep> getSteps() {
        return Collections.emptyList();
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ DDL\n");
        result.append("  ");
        result.append(this.statement.toString());
        return result.toString();
    }

    @Override
    public OResult toResult() {
        OResultInternal result = new OResultInternal();
        result.setProperty("type", "DDLExecutionPlan");
        result.setProperty("javaType", this.getClass().getName());
        result.setProperty("stmText", this.statement.toString());
        result.setProperty("cost", this.getCost());
        result.setProperty("prettyPrint", this.prettyPrint(0, 2));
        return result;
    }
}

