/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSet;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LetQueryStep
extends AbstractExecutionStep {
    private final OIdentifier varName;
    private final OStatement query;

    public LetQueryStep(OIdentifier varName, OStatement query, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.varName = varName;
        this.query = query;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (!this.getPrev().isPresent()) {
            throw new OCommandExecutionException("Cannot execute a local LET on a query without a target");
        }
        return new OResultSet(){
            OResultSet source;
            {
                this.source = LetQueryStep.this.getPrev().get().syncPull(ctx, nRecords);
            }

            @Override
            public boolean hasNext() {
                return this.source.hasNext();
            }

            @Override
            public OResult next() {
                OResultInternal result = (OResultInternal)this.source.next();
                if (result != null) {
                    this.calculate(result, ctx);
                }
                return result;
            }

            private void calculate(OResultInternal result, OCommandContext ctx2) {
                OBasicCommandContext subCtx = new OBasicCommandContext();
                subCtx.setDatabase(ctx2.getDatabase());
                subCtx.setParentWithoutOverridingChild(ctx2);
                OInternalExecutionPlan subExecutionPlan = LetQueryStep.this.query.createExecutionPlan(subCtx, LetQueryStep.this.profilingEnabled);
                result.setMetadata(LetQueryStep.this.varName.getStringValue(), this.toList(new OLocalResultSet(subExecutionPlan)));
            }

            private List<OResult> toList(OLocalResultSet oLocalResultSet) {
                ArrayList<OResult> result = new ArrayList<OResult>();
                while (oLocalResultSet.hasNext()) {
                    result.add(oLocalResultSet.next());
                }
                oLocalResultSet.close();
                return result;
            }

            @Override
            public void close() {
                this.source.close();
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        return spaces + "+ LET (for each record)\n" + spaces + "  " + this.varName + " = (" + this.query + ")";
    }
}

