/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OScriptExecutionPlan;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;

public class IfStep
extends AbstractExecutionStep {
    OBooleanExpression condition;
    OScriptExecutionPlan positivePlan;
    OScriptExecutionPlan negativePlan;
    Boolean conditionMet = null;

    public IfStep(OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.init(ctx);
        if (this.conditionMet.booleanValue()) {
            return this.positivePlan.fetchNext(nRecords);
        }
        if (this.negativePlan != null) {
            return this.negativePlan.fetchNext(nRecords);
        }
        return new OInternalResultSet();
    }

    protected void init(OCommandContext ctx) {
        if (this.conditionMet == null) {
            this.conditionMet = this.condition.evaluate((OResult)null, ctx);
        }
    }

    public OBooleanExpression getCondition() {
        return this.condition;
    }

    public void setCondition(OBooleanExpression condition) {
        this.condition = condition;
    }

    public OScriptExecutionPlan getPositivePlan() {
        return this.positivePlan;
    }

    public void setPositivePlan(OScriptExecutionPlan positivePlan) {
        this.positivePlan = positivePlan;
    }

    public OScriptExecutionPlan getNegativePlan() {
        return this.negativePlan;
    }

    public void setNegativePlan(OScriptExecutionPlan negativePlan) {
        this.negativePlan = negativePlan;
    }
}

