/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GetValueFromIndexEntryStep
extends AbstractExecutionStep {
    private final int[] filterClusterIds;
    private long cost = 0L;
    private OResultSet prevResult = null;

    public GetValueFromIndexEntryStep(OCommandContext ctx, int[] filterClusterIds, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.filterClusterIds = filterClusterIds;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        if (!this.prev.isPresent()) {
            throw new IllegalStateException("filter step requires a previous step");
        }
        final OExecutionStepInternal prevStep = (OExecutionStepInternal)this.prev.get();
        return new OResultSet(){
            public boolean finished = false;
            OResult nextItem = null;
            int fetched = 0;

            @Override
            public boolean hasNext() {
                if (this.fetched >= nRecords || this.finished) {
                    return false;
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                return this.nextItem != null;
            }

            @Override
            public OResult next() {
                if (this.fetched >= nRecords || this.finished) {
                    throw new IllegalStateException();
                }
                if (this.nextItem == null) {
                    this.fetchNextItem();
                }
                if (this.nextItem == null) {
                    throw new IllegalStateException();
                }
                OResult result = this.nextItem;
                this.nextItem = null;
                ++this.fetched;
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fetchNextItem() {
                this.nextItem = null;
                if (this.finished) {
                    return;
                }
                if (GetValueFromIndexEntryStep.this.prevResult == null) {
                    GetValueFromIndexEntryStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                    if (!GetValueFromIndexEntryStep.this.prevResult.hasNext()) {
                        this.finished = true;
                        return;
                    }
                }
                while (!this.finished) {
                    while (!GetValueFromIndexEntryStep.this.prevResult.hasNext()) {
                        GetValueFromIndexEntryStep.this.prevResult = prevStep.syncPull(ctx, nRecords);
                        if (GetValueFromIndexEntryStep.this.prevResult.hasNext()) continue;
                        this.finished = true;
                        return;
                    }
                    OResult val = GetValueFromIndexEntryStep.this.prevResult.next();
                    long begin = GetValueFromIndexEntryStep.this.profilingEnabled ? System.nanoTime() : 0L;
                    try {
                        Object finalVal = val.getProperty("rid");
                        if (GetValueFromIndexEntryStep.this.filterClusterIds != null) {
                            if (!(finalVal instanceof OIdentifiable)) continue;
                            ORID rid = ((OIdentifiable)finalVal).getIdentity();
                            boolean found = false;
                            for (int filterClusterId : GetValueFromIndexEntryStep.this.filterClusterIds) {
                                if (rid.getClusterId() >= 0 && filterClusterId != rid.getClusterId()) continue;
                                found = true;
                                break;
                            }
                            if (!found) continue;
                        }
                        if (finalVal instanceof OIdentifiable) {
                            OResultInternal res = new OResultInternal();
                            res.setElement((OIdentifiable)finalVal);
                            this.nextItem = res;
                            break;
                        }
                        if (!(finalVal instanceof OResult)) break;
                        this.nextItem = (OResult)finalVal;
                        break;
                    }
                    finally {
                        if (!GetValueFromIndexEntryStep.this.profilingEnabled) continue;
                        GetValueFromIndexEntryStep.this.cost = GetValueFromIndexEntryStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ EXTRACT VALUE FROM INDEX ENTRY";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        if (this.filterClusterIds != null) {
            result = result + "\n";
            result = result + spaces;
            result = result + "  filtering clusters [";
            result = result + Arrays.stream(this.filterClusterIds).boxed().map(x -> "" + x).collect(Collectors.joining(","));
            result = result + "]";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        return new GetValueFromIndexEntryStep(ctx, this.filterClusterIds, this.profilingEnabled);
    }
}

