/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class FetchFromRidsStep
extends AbstractExecutionStep {
    private Collection<ORecordId> rids;
    private Iterator<ORecordId> iterator;
    private OResult nextResult = null;

    public FetchFromRidsStep(Collection<ORecordId> rids, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.rids = rids;
        this.reset();
    }

    @Override
    public void reset() {
        this.iterator = this.rids.iterator();
        this.nextResult = null;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){
            int internalNext = 0;

            private void fetchNext() {
                if (FetchFromRidsStep.this.nextResult != null) {
                    return;
                }
                while (FetchFromRidsStep.this.iterator.hasNext()) {
                    OIdentifiable nextDoc;
                    ORecordId nextRid = (ORecordId)FetchFromRidsStep.this.iterator.next();
                    if (nextRid == null || (nextDoc = (OIdentifiable)ctx.getDatabase().load(nextRid)) == null) continue;
                    FetchFromRidsStep.this.nextResult = new OResultInternal();
                    ((OResultInternal)FetchFromRidsStep.this.nextResult).setElement(nextDoc);
                    return;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.internalNext >= nRecords) {
                    return false;
                }
                if (FetchFromRidsStep.this.nextResult == null) {
                    this.fetchNext();
                }
                return FetchFromRidsStep.this.nextResult != null;
            }

            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                ++this.internalNext;
                OResult result = FetchFromRidsStep.this.nextResult;
                FetchFromRidsStep.this.nextResult = null;
                return result;
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        return OExecutionStepInternal.getIndent(depth, indent) + "+ FETCH FROM RIDs\n" + OExecutionStepInternal.getIndent(depth, indent) + "  " + this.rids;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        if (this.rids != null) {
            result.setProperty("rids", this.rids.stream().map(x -> x.toString()).collect(Collectors.toList()));
        }
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            if (fromResult.getProperty("rids") != null) {
                List ser = (List)fromResult.getProperty("rids");
                this.rids = ser.stream().map(x -> new ORecordId((String)x)).collect(Collectors.toList());
            }
            this.reset();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }
}

