/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OQueryStats;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OAndBlock;
import com.orientechnologies.orient.core.sql.parser.OBaseExpression;
import com.orientechnologies.orient.core.sql.parser.OBetweenCondition;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OBinaryCondition;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OCollection;
import com.orientechnologies.orient.core.sql.parser.OContainsAnyCondition;
import com.orientechnologies.orient.core.sql.parser.OEqualsCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OGeOperator;
import com.orientechnologies.orient.core.sql.parser.OGtOperator;
import com.orientechnologies.orient.core.sql.parser.OInCondition;
import com.orientechnologies.orient.core.sql.parser.OLeOperator;
import com.orientechnologies.orient.core.sql.parser.OLtOperator;
import com.orientechnologies.orient.core.sql.parser.OValueExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FetchFromIndexStep
extends AbstractExecutionStep {
    protected OIndex index;
    protected OBooleanExpression condition;
    private OBinaryCondition additionalRangeCondition;
    private boolean orderAsc;
    protected String indexName;
    private long cost = 0L;
    private long count = 0L;
    private boolean inited = false;
    private OIndexCursor cursor;
    private List<OIndexCursor> nextCursors = new ArrayList<OIndexCursor>();
    OMultiCollectionIterator<Map.Entry<Object, OIdentifiable>> customIterator;
    private Iterator nullKeyIterator;
    private Map.Entry<Object, OIdentifiable> nextEntry = null;

    public FetchFromIndexStep(OIndex<?> index, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, OCommandContext ctx, boolean profilingEnabled) {
        this(index, condition, additionalRangeCondition, true, ctx, profilingEnabled);
    }

    public FetchFromIndexStep(OIndex<?> index, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, boolean orderAsc, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.index = index;
        this.indexName = index.getName();
        this.condition = condition;
        this.additionalRangeCondition = additionalRangeCondition;
        this.orderAsc = orderAsc;
    }

    public FetchFromIndexStep(String indexName, OBooleanExpression condition, OBinaryCondition additionalRangeCondition, boolean orderAsc, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.indexName = indexName;
        this.condition = condition;
        this.additionalRangeCondition = additionalRangeCondition;
        this.orderAsc = orderAsc;
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.init(ctx.getDatabase());
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){
            int localCount = 0;

            @Override
            public boolean hasNext() {
                if (this.localCount >= nRecords) {
                    return false;
                }
                if (FetchFromIndexStep.this.nextEntry == null) {
                    FetchFromIndexStep.this.fetchNextEntry();
                }
                return FetchFromIndexStep.this.nextEntry != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                if (!this.hasNext()) {
                    throw new IllegalStateException();
                }
                long begin = FetchFromIndexStep.this.profilingEnabled ? System.nanoTime() : 0L;
                try {
                    Object key = FetchFromIndexStep.this.nextEntry.getKey();
                    OIdentifiable value = (OIdentifiable)FetchFromIndexStep.this.nextEntry.getValue();
                    FetchFromIndexStep.this.nextEntry = null;
                    ++this.localCount;
                    OResultInternal result = new OResultInternal();
                    result.setProperty("key", key);
                    result.setProperty("rid", value);
                    ctx.setVariable("$current", result);
                    OResultInternal oResultInternal = result;
                    return oResultInternal;
                }
                finally {
                    if (FetchFromIndexStep.this.profilingEnabled) {
                        FetchFromIndexStep.this.cost = FetchFromIndexStep.this.cost + (System.nanoTime() - begin);
                    }
                }
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    private void fetchNextEntry() {
        this.nextEntry = null;
        if (this.cursor != null) {
            this.nextEntry = this.cursor.nextEntry();
            while (this.nextEntry == null && this.nextCursors.size() > 0) {
                this.cursor = this.nextCursors.remove(0);
                this.nextEntry = this.cursor.nextEntry();
            }
        }
        if (this.nextEntry == null && this.customIterator != null && this.customIterator.hasNext()) {
            this.nextEntry = this.customIterator.next();
        }
        if (this.nextEntry == null && this.nullKeyIterator != null && this.nullKeyIterator.hasNext()) {
            final OIdentifiable nextValue = (OIdentifiable)this.nullKeyIterator.next();
            this.nextEntry = new Map.Entry<Object, OIdentifiable>(){

                @Override
                public Object getKey() {
                    return null;
                }

                @Override
                public OIdentifiable getValue() {
                    return nextValue;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value) {
                    return null;
                }
            };
        }
        if (this.nextEntry == null) {
            this.updateIndexStats();
        } else {
            ++this.count;
        }
    }

    private void updateIndexStats() {
        OQueryStats stats = OQueryStats.get((ODatabaseDocumentInternal)this.ctx.getDatabase());
        if (this.index == null) {
            return;
        }
        String indexName = this.index.getName();
        boolean range = false;
        int size = 0;
        if (this.condition == null) {
            size = 0;
        } else if (this.condition instanceof OBinaryCondition) {
            size = 1;
        } else if (this.condition instanceof OBetweenCondition) {
            size = 1;
            range = true;
        } else if (this.condition instanceof OAndBlock) {
            OAndBlock andBlock = (OAndBlock)this.condition;
            size = andBlock.getSubBlocks().size();
            OBooleanExpression lastOp = andBlock.getSubBlocks().get(andBlock.getSubBlocks().size() - 1);
            if (lastOp instanceof OBinaryCondition) {
                OBinaryCompareOperator op = ((OBinaryCondition)lastOp).getOperator();
                range = op.isRangeOperator();
            }
        } else if (this.condition instanceof OInCondition) {
            size = 1;
        }
        stats.pushIndexStats(indexName, size, range, this.additionalRangeCondition != null, this.count);
    }

    private synchronized void init(ODatabase db) {
        if (this.inited) {
            return;
        }
        this.inited = true;
        this.init(this.condition, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(OBooleanExpression condition, ODatabase db) {
        block12: {
            long begin;
            long l = begin = this.profilingEnabled ? System.nanoTime() : 0L;
            if (this.index == null) {
                this.index = db.getMetadata().getIndexManager().getIndex(this.indexName);
            }
            try {
                if (this.index.getDefinition() == null) {
                    return;
                }
                if (condition == null) {
                    this.processFlatIteration();
                    break block12;
                }
                if (condition instanceof OBinaryCondition) {
                    this.processBinaryCondition();
                    break block12;
                }
                if (condition instanceof OBetweenCondition) {
                    this.processBetweenCondition();
                    break block12;
                }
                if (condition instanceof OAndBlock) {
                    this.processAndBlock();
                    break block12;
                }
                if (condition instanceof OInCondition) {
                    this.processInCondition();
                    break block12;
                }
                throw new OCommandExecutionException("search for index for " + condition + " is not supported yet");
            }
            finally {
                if (this.profilingEnabled) {
                    this.cost += System.nanoTime() - begin;
                }
            }
        }
    }

    private void processInCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OInCondition inCondition = (OInCondition)this.condition;
        OExpression left = inCondition.getLeft();
        if (!left.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        Object rightValue = inCondition.evaluateRight((OResult)null, this.ctx);
        OEqualsCompareOperator equals = new OEqualsCompareOperator(-1);
        if (OMultiValue.isMultiValue(rightValue)) {
            this.customIterator = new OMultiCollectionIterator();
            for (final Object item : OMultiValue.getMultiValueIterable(rightValue)) {
                final OIndexCursor localCursor = this.createCursor(equals, definition, item, this.ctx);
                this.customIterator.add(new Iterator<Map.Entry>(){

                    @Override
                    public boolean hasNext() {
                        return localCursor.hasNext();
                    }

                    @Override
                    public Map.Entry next() {
                        if (!localCursor.hasNext()) {
                            throw new IllegalStateException();
                        }
                        final OIdentifiable value = (OIdentifiable)localCursor.next();
                        return new Map.Entry(){

                            public Object getKey() {
                                return item;
                            }

                            public Object getValue() {
                                return value;
                            }

                            public Object setValue(Object value2) {
                                return null;
                            }
                        };
                    }
                });
            }
            this.customIterator.reset();
        } else {
            this.cursor = this.createCursor(equals, definition, rightValue, this.ctx);
        }
        this.fetchNextEntry();
    }

    private void processAndBlock() {
        OCollection fromKey = this.indexKeyFrom((OAndBlock)this.condition, this.additionalRangeCondition);
        OCollection toKey = this.indexKeyTo((OAndBlock)this.condition, this.additionalRangeCondition);
        boolean fromKeyIncluded = this.indexKeyFromIncluded((OAndBlock)this.condition, this.additionalRangeCondition);
        boolean toKeyIncluded = this.indexKeyToIncluded((OAndBlock)this.condition, this.additionalRangeCondition);
        this.init(fromKey, fromKeyIncluded, toKey, toKeyIncluded);
    }

    private void processFlatIteration() {
        this.cursor = this.isOrderAsc() ? this.index.cursor() : this.index.descCursor();
        this.fetchNullKeys();
        if (this.cursor != null) {
            this.fetchNextEntry();
        }
    }

    private void fetchNullKeys() {
        if (this.index.getDefinition().isNullValuesIgnored()) {
            this.nullKeyIterator = Collections.emptyIterator();
            return;
        }
        Object nullIter = this.index.get(null);
        this.nullKeyIterator = nullIter instanceof OIdentifiable ? Collections.singleton(nullIter).iterator() : (nullIter instanceof Iterable ? ((Iterable)nullIter).iterator() : (nullIter instanceof Iterator ? (Iterator)nullIter : Collections.emptyIterator()));
    }

    private void init(OCollection fromKey, boolean fromKeyIncluded, OCollection toKey, boolean toKeyIncluded) {
        List<OCollection> secondValueCombinations = this.cartesianProduct(fromKey);
        List<OCollection> thirdValueCombinations = this.cartesianProduct(toKey);
        for (int i = 0; i < secondValueCombinations.size(); ++i) {
            OIndexCursor cursor;
            Object secondValue = secondValueCombinations.get(i).execute((OResult)null, this.ctx);
            Object thirdValue = thirdValueCombinations.get(i).execute((OResult)null, this.ctx);
            OIndexDefinition indexDef = this.index.getDefinition();
            secondValue = this.convertToIndexDefinitionTypes(secondValue, indexDef.getTypes());
            thirdValue = this.convertToIndexDefinitionTypes(thirdValue, indexDef.getTypes());
            if (this.index.supportsOrderedIterations()) {
                cursor = this.index.iterateEntriesBetween(this.toBetweenIndexKey(indexDef, secondValue), fromKeyIncluded, this.toBetweenIndexKey(indexDef, thirdValue), toKeyIncluded, this.isOrderAsc());
            } else if (this.additionalRangeCondition == null && this.allEqualities((OAndBlock)this.condition)) {
                cursor = this.index.iterateEntries(this.toIndexKey(indexDef, secondValue), this.isOrderAsc());
            } else {
                throw new UnsupportedOperationException("Cannot evaluate " + this.condition + " on index " + this.index);
            }
            this.nextCursors.add(cursor);
        }
        if (this.nextCursors.size() > 0) {
            this.cursor = this.nextCursors.remove(0);
            this.fetchNextEntry();
        }
    }

    private List<OCollection> cartesianProduct(OCollection key) {
        return this.cartesianProduct(new OCollection(-1), key);
    }

    private List<OCollection> cartesianProduct(OCollection head, OCollection key) {
        if (key.getExpressions().size() == 0) {
            return Collections.singletonList(head);
        }
        OExpression nextElementInKey = key.getExpressions().get(0);
        Object value = nextElementInKey.execute(new OResultInternal(), this.ctx);
        if (value instanceof Iterable && !(value instanceof OIdentifiable)) {
            ArrayList<OCollection> result = new ArrayList<OCollection>();
            for (Object elemInKey : (Collection)value) {
                OCollection newHead = new OCollection(-1);
                for (OExpression exp : head.getExpressions()) {
                    newHead.add(exp.copy());
                }
                newHead.add(this.toExpression(elemInKey, this.ctx));
                OCollection tail = key.copy();
                tail.getExpressions().remove(0);
                result.addAll(this.cartesianProduct(newHead, tail));
            }
            return result;
        }
        OCollection newHead = new OCollection(-1);
        for (OExpression exp : head.getExpressions()) {
            newHead.add(exp.copy());
        }
        newHead.add(nextElementInKey);
        OCollection tail = key.copy();
        tail.getExpressions().remove(0);
        return this.cartesianProduct(newHead, tail);
    }

    private OExpression toExpression(Object value, OCommandContext ctx) {
        return new OValueExpression(value);
    }

    private Object convertToIndexDefinitionTypes(Object val, OType[] types) {
        if (val == null) {
            return null;
        }
        if (OMultiValue.isMultiValue(val)) {
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            for (Object o : OMultiValue.getMultiValueIterable(val)) {
                result.add(OType.convert(o, types[i++].getDefaultJavaType()));
            }
            return result;
        }
        return OType.convert(val, types[0].getDefaultJavaType());
    }

    private boolean allEqualities(OAndBlock condition) {
        if (condition == null) {
            return false;
        }
        for (OBooleanExpression exp : condition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                if (!(((OBinaryCondition)exp).getOperator() instanceof OEqualsCompareOperator)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void processBetweenCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OExpression key = ((OBetweenCondition)this.condition).getFirst();
        if (!key.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        OExpression second = ((OBetweenCondition)this.condition).getSecond();
        OExpression third = ((OBetweenCondition)this.condition).getThird();
        Object secondValue = second.execute((OResult)null, this.ctx);
        Object thirdValue = third.execute((OResult)null, this.ctx);
        this.cursor = this.index.iterateEntriesBetween(this.toBetweenIndexKey(definition, secondValue), true, this.toBetweenIndexKey(definition, thirdValue), true, this.isOrderAsc());
        if (this.cursor != null) {
            this.fetchNextEntry();
        }
    }

    private void processBinaryCondition() {
        OIndexDefinition definition = this.index.getDefinition();
        OBinaryCompareOperator operator = ((OBinaryCondition)this.condition).getOperator();
        OExpression left = ((OBinaryCondition)this.condition).getLeft();
        if (!left.toString().equalsIgnoreCase("key")) {
            throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
        }
        Object rightValue = ((OBinaryCondition)this.condition).getRight().execute((OResult)null, this.ctx);
        this.cursor = this.createCursor(operator, definition, rightValue, this.ctx);
        if (this.cursor != null) {
            this.fetchNextEntry();
        }
    }

    private Collection toIndexKey(OIndexDefinition definition, Object rightValue) {
        if (definition.getFields().size() == 1 && rightValue instanceof Collection) {
            rightValue = ((Collection)rightValue).iterator().next();
        }
        if (rightValue instanceof List) {
            rightValue = definition.createValue((List)rightValue);
        } else if (!(rightValue instanceof OCompositeKey)) {
            rightValue = definition.createValue(rightValue);
        }
        if (!(rightValue instanceof Collection)) {
            rightValue = Collections.singleton(rightValue);
        }
        return (Collection)rightValue;
    }

    private Object toBetweenIndexKey(OIndexDefinition definition, Object rightValue) {
        if (definition.getFields().size() == 1 && rightValue instanceof Collection) {
            rightValue = ((Collection)rightValue).size() > 0 ? ((Collection)rightValue).iterator().next() : null;
        }
        rightValue = definition.createValue(rightValue);
        if (definition.getFields().size() > 1 && !(rightValue instanceof Collection)) {
            rightValue = Collections.singleton(rightValue);
        }
        return rightValue;
    }

    private OIndexCursor createCursor(OBinaryCompareOperator operator, OIndexDefinition definition, Object value, OCommandContext ctx) {
        boolean orderAsc = this.isOrderAsc();
        if (operator instanceof OEqualsCompareOperator) {
            return this.index.iterateEntries(this.toIndexKey(definition, value), orderAsc);
        }
        if (operator instanceof OGeOperator) {
            return this.index.iterateEntriesMajor(value, true, orderAsc);
        }
        if (operator instanceof OGtOperator) {
            return this.index.iterateEntriesMajor(value, false, orderAsc);
        }
        if (operator instanceof OLeOperator) {
            return this.index.iterateEntriesMinor(value, true, orderAsc);
        }
        if (operator instanceof OLtOperator) {
            return this.index.iterateEntriesMinor(value, false, orderAsc);
        }
        throw new OCommandExecutionException("search for index for " + this.condition + " is not supported yet");
    }

    protected boolean isOrderAsc() {
        return this.orderAsc;
    }

    private OCollection indexKeyFrom(OAndBlock keyCondition, OBinaryCondition additional) {
        OCollection result = new OCollection(-1);
        for (OBooleanExpression exp : keyCondition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                OBinaryCondition binaryCond = (OBinaryCondition)exp;
                OBinaryCompareOperator operator = binaryCond.getOperator();
                if (operator instanceof OEqualsCompareOperator || operator instanceof OGtOperator || operator instanceof OGeOperator) {
                    result.add(binaryCond.getRight());
                    continue;
                }
                if (additional == null) continue;
                result.add(additional.getRight());
                continue;
            }
            if (exp instanceof OInCondition) {
                OExpression item = new OExpression(-1);
                if (((OInCondition)exp).getRightMathExpression() != null) {
                    item.setMathExpression(((OInCondition)exp).getRightMathExpression());
                    result.add(item);
                    continue;
                }
                if (((OInCondition)exp).getRightParam() != null) {
                    OBaseExpression e = new OBaseExpression(-1);
                    e.setInputParam(((OInCondition)exp).getRightParam().copy());
                    item.setMathExpression(e);
                    result.add(item);
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            if (exp instanceof OContainsAnyCondition) {
                if (((OContainsAnyCondition)exp).getRight() != null) {
                    result.add(((OContainsAnyCondition)exp).getRight());
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            throw new UnsupportedOperationException("Cannot execute index query with " + exp);
        }
        return result;
    }

    private OCollection indexKeyTo(OAndBlock keyCondition, OBinaryCondition additional) {
        OCollection result = new OCollection(-1);
        for (OBooleanExpression exp : keyCondition.getSubBlocks()) {
            if (exp instanceof OBinaryCondition) {
                OBinaryCondition binaryCond = (OBinaryCondition)exp;
                OBinaryCompareOperator operator = binaryCond.getOperator();
                if (operator instanceof OEqualsCompareOperator || operator instanceof OLtOperator || operator instanceof OLeOperator) {
                    result.add(binaryCond.getRight());
                    continue;
                }
                if (additional == null) continue;
                result.add(additional.getRight());
                continue;
            }
            if (exp instanceof OInCondition) {
                OExpression item = new OExpression(-1);
                if (((OInCondition)exp).getRightMathExpression() != null) {
                    item.setMathExpression(((OInCondition)exp).getRightMathExpression());
                    result.add(item);
                    continue;
                }
                if (((OInCondition)exp).getRightParam() != null) {
                    OBaseExpression e = new OBaseExpression(-1);
                    e.setInputParam(((OInCondition)exp).getRightParam().copy());
                    item.setMathExpression(e);
                    result.add(item);
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            if (exp instanceof OContainsAnyCondition) {
                if (((OContainsAnyCondition)exp).getRight() != null) {
                    result.add(((OContainsAnyCondition)exp).getRight());
                    continue;
                }
                throw new UnsupportedOperationException("Cannot execute index query with " + exp);
            }
            throw new UnsupportedOperationException("Cannot execute index query with " + exp);
        }
        return result;
    }

    private boolean indexKeyFromIncluded(OAndBlock keyCondition, OBinaryCondition additional) {
        OBinaryCompareOperator additionalOperator;
        OBooleanExpression exp = keyCondition.getSubBlocks().get(keyCondition.getSubBlocks().size() - 1);
        OBinaryCompareOperator oBinaryCompareOperator = additionalOperator = additional == null ? null : additional.getOperator();
        if (exp instanceof OBinaryCondition) {
            OBinaryCompareOperator operator = ((OBinaryCondition)exp).getOperator();
            if (this.isGreaterOperator(operator)) {
                return this.isIncludeOperator(operator);
            }
            return additionalOperator == null || this.isIncludeOperator(additionalOperator) && this.isGreaterOperator(additionalOperator);
        }
        if (exp instanceof OInCondition || exp instanceof OContainsAnyCondition) {
            return additional == null || this.isIncludeOperator(additionalOperator) && this.isGreaterOperator(additionalOperator);
        }
        throw new UnsupportedOperationException("Cannot execute index query with " + exp);
    }

    private boolean isGreaterOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OGeOperator || operator instanceof OGtOperator;
    }

    private boolean isLessOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OLeOperator || operator instanceof OLtOperator;
    }

    private boolean isIncludeOperator(OBinaryCompareOperator operator) {
        if (operator == null) {
            return false;
        }
        return operator instanceof OGeOperator || operator instanceof OLeOperator;
    }

    private boolean indexKeyToIncluded(OAndBlock keyCondition, OBinaryCondition additional) {
        OBinaryCompareOperator additionalOperator;
        OBooleanExpression exp = keyCondition.getSubBlocks().get(keyCondition.getSubBlocks().size() - 1);
        OBinaryCompareOperator oBinaryCompareOperator = additionalOperator = additional == null ? null : additional.getOperator();
        if (exp instanceof OBinaryCondition) {
            OBinaryCompareOperator operator = ((OBinaryCondition)exp).getOperator();
            if (this.isLessOperator(operator)) {
                return this.isIncludeOperator(operator);
            }
            return additionalOperator == null || this.isIncludeOperator(additionalOperator) && this.isLessOperator(additionalOperator);
        }
        if (exp instanceof OInCondition || exp instanceof OContainsAnyCondition) {
            return additionalOperator == null || this.isIncludeOperator(additionalOperator) && this.isLessOperator(additionalOperator);
        }
        throw new UnsupportedOperationException("Cannot execute index query with " + exp);
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String result = OExecutionStepInternal.getIndent(depth, indent) + "+ FETCH FROM INDEX " + this.indexName;
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        if (this.condition != null) {
            result = result + "\n" + OExecutionStepInternal.getIndent(depth, indent) + "  " + this.condition + (this.additionalRangeCondition == null ? "" : " and " + this.additionalRangeCondition);
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        result.setProperty("indexName", this.index.getName());
        if (this.condition != null) {
            result.setProperty("condition", this.condition.serialize());
        }
        if (this.additionalRangeCondition != null) {
            result.setProperty("additionalRangeCondition", this.additionalRangeCondition.serialize());
        }
        result.setProperty("orderAsc", this.orderAsc);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.indexName = (String)fromResult.getProperty("indexName");
            if (fromResult.getProperty("condition") != null) {
                this.condition = OBooleanExpression.deserializeFromOResult((OResult)fromResult.getProperty("condition"));
            }
            if (fromResult.getProperty("additionalRangeCondition") != null) {
                this.additionalRangeCondition = new OBinaryCondition(-1);
                this.additionalRangeCondition.deserialize((OResult)fromResult.getProperty("additionalRangeCondition"));
            }
            this.orderAsc = (Boolean)fromResult.getProperty("orderAsc");
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }

    @Override
    public void reset() {
        this.index = null;
        this.condition = this.condition == null ? null : this.condition.copy();
        this.additionalRangeCondition = this.additionalRangeCondition == null ? null : this.additionalRangeCondition.copy();
        this.cost = 0L;
        this.count = 0L;
        this.inited = false;
        this.cursor = null;
        this.customIterator = null;
        this.nullKeyIterator = null;
        this.nextEntry = null;
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @Override
    public OExecutionStep copy(OCommandContext ctx) {
        FetchFromIndexStep result = new FetchFromIndexStep(this.indexName, this.condition == null ? null : this.condition.copy(), this.additionalRangeCondition == null ? null : this.additionalRangeCondition.copy(), this.orderAsc, ctx, this.profilingEnabled);
        return result;
    }
}

