/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.FetchFromClusterExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FetchFromClustersExecutionStep
extends AbstractExecutionStep {
    List<OExecutionStep> subSteps;
    private boolean orderByRidAsc = false;
    private boolean orderByRidDesc = false;
    OResultSet currentResultSet;
    int currentStep = 0;

    public FetchFromClustersExecutionStep(int[] clusterIds, OCommandContext ctx, Boolean ridOrder, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        if (Boolean.TRUE.equals(ridOrder)) {
            this.orderByRidAsc = true;
        } else if (Boolean.FALSE.equals(ridOrder)) {
            this.orderByRidDesc = true;
        }
        this.subSteps = new ArrayList<OExecutionStep>();
        this.sortClusers(clusterIds);
        for (int i = 0; i < clusterIds.length; ++i) {
            FetchFromClusterExecutionStep step = new FetchFromClusterExecutionStep(clusterIds[i], ctx, profilingEnabled);
            if (this.orderByRidAsc) {
                step.setOrder(FetchFromClusterExecutionStep.ORDER_ASC);
            } else if (this.orderByRidDesc) {
                step.setOrder(FetchFromClusterExecutionStep.ORDER_DESC);
            }
            this.subSteps.add(step);
        }
    }

    private void sortClusers(int[] clusterIds) {
        if (this.orderByRidAsc) {
            Arrays.sort(clusterIds);
        } else if (this.orderByRidDesc) {
            Arrays.sort(clusterIds);
            for (int i = 0; i < clusterIds.length / 2; ++i) {
                int old = clusterIds[i];
                clusterIds[i] = clusterIds[clusterIds.length - 1 - i];
                clusterIds[clusterIds.length - 1 - i] = old;
            }
        }
    }

    @Override
    public OResultSet syncPull(final OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        return new OResultSet(){
            int totDispatched = 0;

            @Override
            public boolean hasNext() {
                do {
                    if (this.totDispatched >= nRecords) {
                        return false;
                    }
                    if (FetchFromClustersExecutionStep.this.currentResultSet != null && FetchFromClustersExecutionStep.this.currentResultSet.hasNext()) continue;
                    if (FetchFromClustersExecutionStep.this.currentStep >= FetchFromClustersExecutionStep.this.subSteps.size()) {
                        return false;
                    }
                    FetchFromClustersExecutionStep.this.currentResultSet = ((AbstractExecutionStep)FetchFromClustersExecutionStep.this.subSteps.get(FetchFromClustersExecutionStep.this.currentStep)).syncPull(ctx, nRecords);
                    if (FetchFromClustersExecutionStep.this.currentResultSet.hasNext()) continue;
                    FetchFromClustersExecutionStep.this.currentResultSet = ((AbstractExecutionStep)FetchFromClustersExecutionStep.this.subSteps.get(FetchFromClustersExecutionStep.this.currentStep++)).syncPull(ctx, nRecords);
                } while (!FetchFromClustersExecutionStep.this.currentResultSet.hasNext());
                return true;
            }

            @Override
            public OResult next() {
                do {
                    if (this.totDispatched >= nRecords) {
                        throw new IllegalStateException();
                    }
                    if (FetchFromClustersExecutionStep.this.currentResultSet != null && FetchFromClustersExecutionStep.this.currentResultSet.hasNext()) continue;
                    if (FetchFromClustersExecutionStep.this.currentStep >= FetchFromClustersExecutionStep.this.subSteps.size()) {
                        throw new IllegalStateException();
                    }
                    FetchFromClustersExecutionStep.this.currentResultSet = ((AbstractExecutionStep)FetchFromClustersExecutionStep.this.subSteps.get(FetchFromClustersExecutionStep.this.currentStep)).syncPull(ctx, nRecords);
                    if (FetchFromClustersExecutionStep.this.currentResultSet.hasNext()) continue;
                    FetchFromClustersExecutionStep.this.currentResultSet = ((AbstractExecutionStep)FetchFromClustersExecutionStep.this.subSteps.get(FetchFromClustersExecutionStep.this.currentStep++)).syncPull(ctx, nRecords);
                } while (!FetchFromClustersExecutionStep.this.currentResultSet.hasNext());
                ++this.totDispatched;
                return FetchFromClustersExecutionStep.this.currentResultSet.next();
            }

            @Override
            public void close() {
                for (OExecutionStep step : FetchFromClustersExecutionStep.this.subSteps) {
                    ((AbstractExecutionStep)step).close();
                }
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return Optional.empty();
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return new HashMap<String, Long>();
            }
        };
    }

    @Override
    public void sendTimeout() {
        for (OExecutionStep step : this.subSteps) {
            ((AbstractExecutionStep)step).sendTimeout();
        }
        this.prev.ifPresent(p -> p.sendTimeout());
    }

    @Override
    public void close() {
        for (OExecutionStep step : this.subSteps) {
            ((AbstractExecutionStep)step).close();
        }
        this.prev.ifPresent(p -> p.close());
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        StringBuilder builder = new StringBuilder();
        String ind = OExecutionStepInternal.getIndent(depth, indent);
        builder.append(ind);
        builder.append("+ FETCH FROM CLUSTERS");
        if (this.profilingEnabled) {
            builder.append(" (" + this.getCostFormatted() + ")");
        }
        builder.append("\n");
        for (int i = 0; i < this.subSteps.size(); ++i) {
            OExecutionStepInternal step = (OExecutionStepInternal)this.subSteps.get(i);
            builder.append(step.prettyPrint(depth + 1, indent));
            if (i >= this.subSteps.size() - 1) continue;
            builder.append("\n");
        }
        return builder.toString();
    }

    @Override
    public List<OExecutionStep> getSubSteps() {
        return this.subSteps;
    }

    @Override
    public long getCost() {
        return this.subSteps.stream().map(x -> x.getCost()).reduce((a, b) -> a + b).orElse(-1L);
    }

    @Override
    public OResult serialize() {
        OResultInternal result = OExecutionStepInternal.basicSerialize(this);
        result.setProperty("orderByRidAsc", this.orderByRidAsc);
        result.setProperty("orderByRidDesc", this.orderByRidDesc);
        return result;
    }

    @Override
    public void deserialize(OResult fromResult) {
        try {
            OExecutionStepInternal.basicDeserialize(fromResult, this);
            this.orderByRidAsc = (Boolean)fromResult.getProperty("orderByRidAsc");
            this.orderByRidDesc = (Boolean)fromResult.getProperty("orderByRidDesc");
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException(""), e);
        }
    }
}

