/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.executor.OUpdatableResult;
import com.orientechnologies.orient.core.sql.parser.OBatch;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CreateEdgesStep
extends AbstractExecutionStep {
    private final OIdentifier targetClass;
    private final OIdentifier targetCluster;
    private final OIdentifier fromAlias;
    private final OIdentifier toAlias;
    private final Number wait;
    private final Number retry;
    private final OBatch batch;
    Iterator fromIter;
    Iterator toIterator;
    OVertex currentFrom;
    List toList = new ArrayList();
    private boolean inited = false;
    private long cost = 0L;

    public CreateEdgesStep(OIdentifier targetClass, OIdentifier targetClusterName, OIdentifier fromAlias, OIdentifier toAlias, Number wait, Number retry, OBatch batch, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.targetClass = targetClass;
        this.targetCluster = targetClusterName;
        this.fromAlias = fromAlias;
        this.toAlias = toAlias;
        this.wait = wait;
        this.retry = retry;
        this.batch = batch;
    }

    @Override
    public OResultSet syncPull(OCommandContext ctx, final int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        this.init();
        return new OResultSet(){
            int currentBatch = 0;

            @Override
            public boolean hasNext() {
                return this.currentBatch < nRecords && (CreateEdgesStep.this.toIterator.hasNext() || CreateEdgesStep.this.toList.size() > 0 && CreateEdgesStep.this.fromIter.hasNext());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OResult next() {
                if (!CreateEdgesStep.this.toIterator.hasNext()) {
                    CreateEdgesStep.this.toIterator = CreateEdgesStep.this.toList.iterator();
                    if (!CreateEdgesStep.this.fromIter.hasNext()) {
                        throw new IllegalStateException();
                    }
                    OVertex oVertex = CreateEdgesStep.this.currentFrom = CreateEdgesStep.this.fromIter.hasNext() ? CreateEdgesStep.this.asVertex(CreateEdgesStep.this.fromIter.next()) : null;
                }
                if (this.currentBatch < nRecords && (CreateEdgesStep.this.toIterator.hasNext() || CreateEdgesStep.this.toList.size() > 0 && CreateEdgesStep.this.fromIter.hasNext())) {
                    if (CreateEdgesStep.this.currentFrom == null) {
                        throw new OCommandExecutionException("Invalid FROM vertex for edge");
                    }
                    Object obj = CreateEdgesStep.this.toIterator.next();
                    long begin = CreateEdgesStep.this.profilingEnabled ? System.nanoTime() : 0L;
                    try {
                        OVertex currentTo = CreateEdgesStep.this.asVertex(obj);
                        if (currentTo == null) {
                            throw new OCommandExecutionException("Invalid TO vertex for edge");
                        }
                        OEdge edge = CreateEdgesStep.this.currentFrom.addEdge(currentTo, CreateEdgesStep.this.targetClass.getStringValue());
                        OUpdatableResult result = new OUpdatableResult(edge);
                        result.setElement(edge);
                        ++this.currentBatch;
                        OUpdatableResult oUpdatableResult = result;
                        return oUpdatableResult;
                    }
                    finally {
                        if (CreateEdgesStep.this.profilingEnabled) {
                            CreateEdgesStep.this.cost = CreateEdgesStep.this.cost + (System.nanoTime() - begin);
                        }
                    }
                }
                throw new IllegalStateException();
            }

            @Override
            public void close() {
            }

            @Override
            public Optional<OExecutionPlan> getExecutionPlan() {
                return null;
            }

            @Override
            public Map<String, Long> getQueryStats() {
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        CreateEdgesStep createEdgesStep = this;
        synchronized (createEdgesStep) {
            if (this.inited) {
                return;
            }
            this.inited = true;
        }
        Iterator<Object> fromValues = this.ctx.getVariable(this.fromAlias.getStringValue());
        if (fromValues instanceof Iterable && !(fromValues instanceof OIdentifiable)) {
            fromValues = ((Iterable)((Object)fromValues)).iterator();
        } else if (!(fromValues instanceof Iterator)) {
            fromValues = Collections.singleton(fromValues).iterator();
        }
        Iterator<Object> toValues = this.ctx.getVariable(this.toAlias.getStringValue());
        if (toValues instanceof Iterable && !(toValues instanceof OIdentifiable)) {
            toValues = ((Iterable)((Object)toValues)).iterator();
        } else if (!(toValues instanceof Iterator)) {
            toValues = Collections.singleton(toValues).iterator();
        }
        this.fromIter = fromValues;
        if (this.fromIter instanceof OResultSet) {
            try {
                ((OResultSet)this.fromIter).reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Iterator<Object> toIter = toValues;
        while (toIter != null && toIter.hasNext()) {
            this.toList.add(toIter.next());
        }
        this.toIterator = this.toList.iterator();
        if (toIter instanceof OResultSet) {
            try {
                ((OResultSet)toIter).reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.currentFrom = this.fromIter != null && this.fromIter.hasNext() ? this.asVertex(this.fromIter.next()) : null;
    }

    private OVertex asVertex(Object currentFrom) {
        if (currentFrom instanceof ORID) {
            currentFrom = ((ORID)currentFrom).getRecord();
        }
        if (currentFrom instanceof OResult) {
            return ((OResult)currentFrom).getVertex().orElse(null);
        }
        if (currentFrom instanceof OVertex) {
            return (OVertex)currentFrom;
        }
        if (currentFrom instanceof OElement) {
            return ((OElement)currentFrom).asVertex().orElse(null);
        }
        return null;
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        String result = spaces + "+ FOR EACH x in " + this.fromAlias + "\n";
        result = result + spaces + "    FOR EACH y in " + this.toAlias + "\n";
        result = result + spaces + "       CREATE EDGE " + this.targetClass + " FROM x TO y";
        if (this.profilingEnabled) {
            result = result + " (" + this.getCostFormatted() + ")";
        }
        if (this.targetCluster != null) {
            result = result + "\n" + spaces + "       (target cluster " + this.targetCluster + ")";
        }
        return result;
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

