/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.common.concur.OTimeoutException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.sql.executor.AbstractExecutionStep;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResultSet;

public class CheckClassTypeStep
extends AbstractExecutionStep {
    private final String targetClass;
    private final String parentClass;
    private long cost = 0L;
    boolean found = false;

    public CheckClassTypeStep(String targetClass, String parentClass, OCommandContext ctx, boolean profilingEnabled) {
        super(ctx, profilingEnabled);
        this.targetClass = targetClass;
        this.parentClass = parentClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OResultSet syncPull(OCommandContext ctx, int nRecords) throws OTimeoutException {
        this.getPrev().ifPresent(x -> x.syncPull(ctx, nRecords));
        long begin = this.profilingEnabled ? System.nanoTime() : 0L;
        try {
            if (this.found) {
                OInternalResultSet oInternalResultSet = new OInternalResultSet();
                return oInternalResultSet;
            }
            if (this.targetClass.equals(this.parentClass)) {
                OInternalResultSet oInternalResultSet = new OInternalResultSet();
                return oInternalResultSet;
            }
            ODatabase db = ctx.getDatabase();
            OSchema schema = db.getMetadata().getSchema();
            OClass parentClazz = schema.getClass(this.parentClass);
            if (parentClazz == null) {
                throw new OCommandExecutionException("Class not found: " + this.parentClass);
            }
            OClass targetClazz = schema.getClass(this.targetClass);
            if (targetClazz == null) {
                throw new OCommandExecutionException("Class not found: " + this.targetClass);
            }
            if (parentClazz.equals(targetClazz)) {
                this.found = true;
            } else {
                for (OClass sublcass : parentClazz.getAllSubclasses()) {
                    if (!sublcass.equals(targetClazz)) continue;
                    this.found = true;
                    break;
                }
            }
            if (!this.found) {
                throw new OCommandExecutionException("Class  " + this.targetClass + " is not a subclass of " + this.parentClass);
            }
            OInternalResultSet oInternalResultSet = new OInternalResultSet();
            return oInternalResultSet;
        }
        finally {
            if (this.profilingEnabled) {
                this.cost += System.nanoTime() - begin;
            }
        }
    }

    @Override
    public String prettyPrint(int depth, int indent) {
        String spaces = OExecutionStepInternal.getIndent(depth, indent);
        StringBuilder result = new StringBuilder();
        result.append(spaces);
        result.append("+ CHECK CLASS HIERARCHY");
        if (this.profilingEnabled) {
            result.append(" (" + this.getCostFormatted() + ")");
        }
        result.append("\n");
        result.append("  " + this.parentClass);
        return result.toString();
    }

    @Override
    public long getCost() {
        return this.cost;
    }
}

