/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.executor;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.sql.executor.OExecutionStepInternal;
import java.text.DecimalFormat;
import java.util.Optional;

public abstract class AbstractExecutionStep
implements OExecutionStepInternal {
    protected final OCommandContext ctx;
    protected Optional<OExecutionStepInternal> prev = Optional.empty();
    protected Optional<OExecutionStepInternal> next = Optional.empty();
    protected boolean timedOut = false;
    protected boolean profilingEnabled = false;

    public AbstractExecutionStep(OCommandContext ctx, boolean profilingEnabled) {
        this.ctx = ctx;
        this.profilingEnabled = profilingEnabled;
    }

    @Override
    public void setPrevious(OExecutionStepInternal step) {
        this.prev = Optional.ofNullable(step);
    }

    @Override
    public void setNext(OExecutionStepInternal step) {
        this.next = Optional.ofNullable(step);
    }

    public OCommandContext getContext() {
        return this.ctx;
    }

    public Optional<OExecutionStepInternal> getPrev() {
        return this.prev;
    }

    public Optional<OExecutionStepInternal> getNext() {
        return this.next;
    }

    @Override
    public void sendTimeout() {
        this.timedOut = true;
        this.prev.ifPresent(p -> p.sendTimeout());
    }

    @Override
    public void close() {
        this.prev.ifPresent(p -> p.close());
    }

    public boolean isProfilingEnabled() {
        return this.profilingEnabled;
    }

    public void setProfilingEnabled(boolean profilingEnabled) {
        this.profilingEnabled = profilingEnabled;
    }

    protected String getCostFormatted() {
        return new DecimalFormat().format(this.getCost() / 1000L) + "\u03bcs";
    }
}

