/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContains;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsKey;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsValue;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OIndexSearchResult {
    public final Map<String, Object> fieldValuePairs = new HashMap<String, Object>(8);
    public final OQueryOperator lastOperator;
    public final OSQLFilterItemField.FieldChain lastField;
    public final Object lastValue;
    boolean containsNullValues;

    public OIndexSearchResult(OQueryOperator lastOperator, OSQLFilterItemField.FieldChain field, Object value) {
        this.lastOperator = lastOperator;
        this.lastField = field;
        this.lastValue = value;
        this.containsNullValues = value == null;
    }

    public static boolean isIndexEqualityOperator(OQueryOperator queryOperator) {
        return queryOperator instanceof OQueryOperatorEquals || queryOperator instanceof OQueryOperatorContains || queryOperator instanceof OQueryOperatorContainsKey || queryOperator instanceof OQueryOperatorContainsValue;
    }

    public OIndexSearchResult merge(OIndexSearchResult searchResult) {
        if (searchResult.lastOperator instanceof OQueryOperatorEquals) {
            return this.mergeFields(this, searchResult);
        }
        if (this.lastOperator instanceof OQueryOperatorEquals) {
            return this.mergeFields(searchResult, this);
        }
        if (OIndexSearchResult.isIndexEqualityOperator(searchResult.lastOperator)) {
            return this.mergeFields(this, searchResult);
        }
        return this.mergeFields(searchResult, this);
    }

    private OIndexSearchResult mergeFields(OIndexSearchResult mainSearchResult, OIndexSearchResult searchResult) {
        OIndexSearchResult result = new OIndexSearchResult(mainSearchResult.lastOperator, mainSearchResult.lastField, mainSearchResult.lastValue);
        result.fieldValuePairs.putAll(searchResult.fieldValuePairs);
        result.fieldValuePairs.putAll(mainSearchResult.fieldValuePairs);
        result.fieldValuePairs.put(searchResult.lastField.getItemName(0), searchResult.lastValue);
        result.containsNullValues = searchResult.containsNullValues || this.containsNullValues;
        return result;
    }

    boolean canBeMerged(OIndexSearchResult searchResult) {
        if (this.lastField.isLong() || searchResult.lastField.isLong()) {
            return false;
        }
        if (!this.lastOperator.canBeMerged() || !searchResult.lastOperator.canBeMerged()) {
            return false;
        }
        return OIndexSearchResult.isIndexEqualityOperator(this.lastOperator) || OIndexSearchResult.isIndexEqualityOperator(searchResult.lastOperator);
    }

    public List<String> fields() {
        ArrayList<String> result = new ArrayList<String>(this.fieldValuePairs.size() + 1);
        result.addAll(this.fieldValuePairs.keySet());
        result.add(this.lastField.getItemName(0));
        return result;
    }

    int getFieldCount() {
        return this.fieldValuePairs.size() + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexSearchResult that = (OIndexSearchResult)o;
        if (this.containsNullValues != that.containsNullValues) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.fieldValuePairs.entrySet()) {
            if (that.fieldValuePairs.get(entry.getKey()).equals(entry.getValue())) continue;
            return false;
        }
        if (!this.lastField.equals(that.lastField)) {
            return false;
        }
        if (!this.lastOperator.equals(that.lastOperator)) {
            return false;
        }
        return this.lastValue.equals(that.lastValue);
    }

    public int hashCode() {
        int result = this.lastOperator.hashCode();
        for (Map.Entry<String, Object> entry : this.fieldValuePairs.entrySet()) {
            if (entry.getKey() != null) {
                result = 31 * result + entry.getKey().hashCode();
            }
            if (entry.getValue() == null) continue;
            result = 31 * result + entry.getValue().hashCode();
        }
        if (this.lastField != null) {
            result = 31 * result + this.lastField.hashCode();
        }
        if (this.lastValue != null) {
            result = 31 * result + this.lastValue.hashCode();
        }
        result = 31 * result + (this.containsNullValues ? 1 : 0);
        return result;
    }
}

