/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.comparator.OCaseInsentiveComparator;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLDropProperty
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    private String className;
    private String fieldName;
    private boolean ifExists;
    private boolean force = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLDropProperty parse(OCommandRequest iRequest) {
        block11: {
            String queryText;
            OCommandRequestText textRequest = (OCommandRequestText)iRequest;
            String originalQuery = queryText = textRequest.getText();
            try {
                queryText = this.preParse(queryText, iRequest);
                textRequest.setText(queryText);
                this.init((OCommandRequestText)iRequest);
                StringBuilder word = new StringBuilder();
                int oldPos = 0;
                int pos = OCommandExecutorSQLDropProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
                if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
                    throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.parserText, oldPos);
                }
                if ((pos = OCommandExecutorSQLDropProperty.nextWord(this.parserText, this.parserTextUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
                    throw new OCommandSQLParsingException("Keyword PROPERTY not found. Use " + this.getSyntax(), this.parserText, oldPos);
                }
                if ((pos = OCommandExecutorSQLDropProperty.nextWord(this.parserText, this.parserTextUpperCase, pos, word, false)) == -1) {
                    throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, pos);
                }
                String[] parts = word.toString().split("\\.");
                if (parts.length != 2) {
                    throw new OCommandSQLParsingException("Expected <class>.<property>. Use " + this.getSyntax(), this.parserText, pos);
                }
                this.className = this.decodeClassName(parts[0]);
                if (this.className == null) {
                    throw new OCommandSQLParsingException("Class not found", this.parserText, pos);
                }
                this.fieldName = this.decodeClassName(parts[1]);
                if ((pos = OCommandExecutorSQLDropProperty.nextWord(this.parserText, this.parserTextUpperCase, pos, word, false)) == -1) break block11;
                String forceParameter = word.toString();
                if ("FORCE".equals(forceParameter)) {
                    this.force = true;
                    break block11;
                }
                if ("IF".equals(word.toString())) {
                    pos = OCommandExecutorSQLDropProperty.nextWord(this.parserText, this.parserTextUpperCase, pos, word, false);
                    if ("EXISTS".equals(word.toString())) {
                        this.ifExists = true;
                        break block11;
                    }
                    throw new OCommandSQLParsingException("Wrong query parameter, expecting EXISTS after IF", this.parserText, pos);
                }
                throw new OCommandSQLParsingException("Wrong query parameter", this.parserText, pos);
            }
            finally {
                textRequest.setText(originalQuery);
            }
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.fieldName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not yet been parsed");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLDropProperty.getDatabase();
        OClassImpl sourceClass = (OClassImpl)database.getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        if (this.ifExists && !sourceClass.existsProperty(this.fieldName)) {
            return null;
        }
        List<OIndex<?>> indexes = this.relatedIndexes(this.fieldName);
        if (!indexes.isEmpty()) {
            if (this.force) {
                this.dropRelatedIndexes(indexes);
            } else {
                StringBuilder indexNames = new StringBuilder();
                boolean first = true;
                for (OIndex<?> index : sourceClass.getClassInvolvedIndexes(this.fieldName)) {
                    if (!first) {
                        indexNames.append(", ");
                    } else {
                        first = false;
                    }
                    indexNames.append(index.getName());
                }
                throw new OCommandExecutionException("Property used in indexes (" + indexNames.toString() + "). Please drop these indexes before removing property or use FORCE parameter.");
            }
        }
        sourceClass.dropProperty(this.fieldName);
        return null;
    }

    @Override
    public long getDistributedTimeout() {
        return OCommandExecutorSQLDropProperty.getDatabase().getConfiguration().getValueAsLong(OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT);
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    private void dropRelatedIndexes(List<OIndex<?>> indexes) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLDropProperty.getDatabase();
        for (OIndex<?> index : indexes) {
            database.command("DROP INDEX " + index.getName(), new Object[0]);
        }
    }

    private List<OIndex<?>> relatedIndexes(String fieldName) {
        ArrayList result = new ArrayList();
        ODatabaseDocumentInternal database = OCommandExecutorSQLDropProperty.getDatabase();
        for (OIndex<?> oIndex : database.getMetadata().getIndexManager().getClassIndexes(this.className)) {
            if (OCollections.indexOf(oIndex.getDefinition().getFields(), fieldName, new OCaseInsentiveComparator()) <= -1) continue;
            result.add(oIndex);
        }
        return result;
    }

    @Override
    public String getSyntax() {
        return "DROP PROPERTY <class>.<property> [ IF EXISTS ] [FORCE]";
    }
}

