/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.ODecimalSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OUUIDSerializer;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.OBlob;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OSerializableWrapper;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.Change;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.ChangeSerializationHelper;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;

public class ORecordSerializerNetworkV37
implements ORecordSerializer {
    public static final String NAME = "onet_ser_v37";
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final ORecordId NULL_RECORD_ID = new ORecordId(-2, -1L);
    private static final long MILLISEC_PER_DAY = 86400000L;
    public static final ORecordSerializerNetworkV37 INSTANCE = new ORecordSerializerNetworkV37();

    public void deserializePartial(ODocument document, BytesContainer bytes, String[] iFields) {
        String className = this.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        int size = OVarIntSerializer.readAsInteger(bytes);
        int matched = 0;
        while (size-- > 0) {
            String fieldName = this.readString(bytes);
            OType type = this.readOType(bytes);
            Object value = type == null ? null : this.deserializeValue(bytes, type, document);
            if (ODocumentInternal.rawContainsField(document, fieldName)) continue;
            ODocumentInternal.rawField(document, fieldName, value, type);
            for (String field : iFields) {
                if (!field.equals(fieldName)) continue;
                ++matched;
            }
            if (matched != iFields.length) continue;
            break;
        }
    }

    public void deserialize(ODocument document, BytesContainer bytes) {
        String className = this.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        int size = OVarIntSerializer.readAsInteger(bytes);
        while (size-- > 0) {
            String fieldName = this.readString(bytes);
            OType type = this.readOType(bytes);
            Object value = type == null ? null : this.deserializeValue(bytes, type, document);
            if (ODocumentInternal.rawContainsField(document, fieldName)) continue;
            ODocumentInternal.rawField(document, fieldName, value, type);
        }
        ORecordInternal.clearSource(document);
    }

    public void serialize(ODocument document, BytesContainer bytes, boolean iClassOnly) {
        this.serializeClass(document, bytes);
        if (iClassOnly) {
            this.writeEmptyString(bytes);
            return;
        }
        Set<Map.Entry<String, ODocumentEntry>> fields = ODocumentInternal.rawEntries(document);
        OVarIntSerializer.write(bytes, document.fields());
        for (Map.Entry<String, ODocumentEntry> entry : fields) {
            ODocumentEntry docEntry = entry.getValue();
            if (!docEntry.exist()) continue;
            this.writeString(bytes, entry.getKey());
            Object value = entry.getValue().value;
            if (value != null) {
                OType type = this.getFieldType(entry.getValue());
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the Result binary serializer");
                }
                this.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, value, type, this.getLinkedType(document, type, entry.getKey()));
                continue;
            }
            this.writeOType(bytes, bytes.alloc(1), null);
        }
    }

    public String[] getFieldNames(ODocument reference, BytesContainer bytes) {
        int classNameLen = OVarIntSerializer.readAsInteger(bytes);
        bytes.skip(classNameLen);
        ArrayList<String> result = new ArrayList<String>();
        int size = OVarIntSerializer.readAsInteger(bytes);
        while (size-- > 0) {
            String fieldName = this.readString(bytes);
            OType type = this.readOType(bytes);
            if (type != null) {
                this.deserializeValue(bytes, type, new ODocument());
            }
            result.add(fieldName);
        }
        return result.toArray(new String[result.size()]);
    }

    protected OClass serializeClass(ODocument document, BytesContainer bytes) {
        OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        String name = null;
        if (clazz != null) {
            name = clazz.getName();
        }
        if (name == null) {
            name = document.getClassName();
        }
        if (name != null) {
            this.writeString(bytes, name);
        } else {
            this.writeEmptyString(bytes);
        }
        return clazz;
    }

    protected OType readOType(BytesContainer bytes) {
        return OType.getById(this.readByte(bytes));
    }

    private void writeOType(BytesContainer bytes, int pos, OType type) {
        bytes.bytes[pos] = type == null ? -1 : (byte)type.getId();
    }

    public byte[] serializeValue(Object value, OType type) {
        BytesContainer bytes = new BytesContainer();
        this.serializeValue(bytes, value, type, null);
        return bytes.fitBytes();
    }

    public Object deserializeValue(byte[] val, OType type) {
        BytesContainer bytes = new BytesContainer(val);
        return this.deserializeValue(bytes, type, null);
    }

    public Object deserializeValue(BytesContainer bytes, OType type, ODocument document) {
        Object value = null;
        switch (type) {
            case INTEGER: {
                value = OVarIntSerializer.readAsInteger(bytes);
                break;
            }
            case LONG: {
                value = OVarIntSerializer.readAsLong(bytes);
                break;
            }
            case SHORT: {
                value = OVarIntSerializer.readAsShort(bytes);
                break;
            }
            case STRING: {
                value = this.readString(bytes);
                break;
            }
            case DOUBLE: {
                value = Double.longBitsToDouble(this.readLong(bytes));
                break;
            }
            case FLOAT: {
                value = Float.valueOf(Float.intBitsToFloat(this.readInteger(bytes)));
                break;
            }
            case BYTE: {
                value = this.readByte(bytes);
                break;
            }
            case BOOLEAN: {
                value = this.readByte(bytes) == 1;
                break;
            }
            case DATETIME: {
                value = new Date(OVarIntSerializer.readAsLong(bytes));
                break;
            }
            case DATE: {
                long savedTime = OVarIntSerializer.readAsLong(bytes) * 86400000L;
                savedTime = this.convertDayToTimezone(TimeZone.getTimeZone("GMT"), ODateHelper.getDatabaseTimeZone(), savedTime);
                value = new Date(savedTime);
                break;
            }
            case EMBEDDED: {
                value = new ODocument();
                this.deserialize((ODocument)value, bytes);
                if (((ODocument)value).containsField("__orientdb_serilized_class__ ")) {
                    String className = (String)((ODocument)value).field("__orientdb_serilized_class__ ");
                    try {
                        Class<?> clazz = Class.forName(className);
                        ODocumentSerializable newValue = (ODocumentSerializable)clazz.newInstance();
                        newValue.fromDocument((ODocument)value);
                        value = newValue;
                        break;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                ODocumentInternal.addOwner((ODocument)value, document);
                break;
            }
            case EMBEDDEDSET: {
                value = this.readEmbeddedCollection(bytes, new OTrackedSet<Object>(document), document);
                break;
            }
            case EMBEDDEDLIST: {
                value = this.readEmbeddedCollection(bytes, new OTrackedList<Object>(document), document);
                break;
            }
            case LINKSET: {
                value = this.readLinkCollection(bytes, new ORecordLazySet(document));
                break;
            }
            case LINKLIST: {
                value = this.readLinkCollection(bytes, new ORecordLazyList(document));
                break;
            }
            case BINARY: {
                value = this.readBinary(bytes);
                break;
            }
            case LINK: {
                value = this.readOptimizedLink(bytes);
                break;
            }
            case LINKMAP: {
                value = this.readLinkMap(bytes, document);
                break;
            }
            case EMBEDDEDMAP: {
                value = this.readEmbeddedMap(bytes, document);
                break;
            }
            case DECIMAL: {
                value = ODecimalSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
                bytes.skip(ODecimalSerializer.INSTANCE.getObjectSize(bytes.bytes, bytes.offset));
                break;
            }
            case LINKBAG: {
                ORidBag bag = this.readRidBag(bytes);
                bag.setOwner(document);
                value = bag;
                break;
            }
            case TRANSIENT: {
                break;
            }
            case CUSTOM: {
                try {
                    String className = this.readString(bytes);
                    Class<?> clazz = Class.forName(className);
                    OSerializableStream stream = (OSerializableStream)clazz.newInstance();
                    stream.fromStream(this.readBinary(bytes));
                    if (stream instanceof OSerializableWrapper) {
                        value = ((OSerializableWrapper)stream).getSerializable();
                        break;
                    }
                    value = stream;
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return value;
    }

    private void writeRidBag(BytesContainer bytes, ORidBag bag) {
        OSBTreeCollectionManager sbTreeCollectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
        UUID uuid = null;
        if (sbTreeCollectionManager != null) {
            uuid = sbTreeCollectionManager.listenForChanges(bag);
        }
        if (uuid == null) {
            uuid = new UUID(-1L, -1L);
        }
        int uuidPos = bytes.alloc(16);
        OUUIDSerializer.INSTANCE.serialize(uuid, bytes.bytes, uuidPos, new Object[0]);
        if (bag.isEmbedded() || OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.getValueAsInteger() >= bag.size()) {
            int pos = bytes.alloc(1);
            bytes.bytes[pos] = 1;
            OVarIntSerializer.write(bytes, bag.size());
            Iterator<OIdentifiable> iterator = bag.rawIterator();
            while (iterator.hasNext()) {
                OIdentifiable itemValue = iterator.next();
                if (itemValue == null) {
                    this.writeNullLink(bytes);
                    continue;
                }
                this.writeOptimizedLink(bytes, itemValue);
            }
        } else {
            int pos = bytes.alloc(1);
            bytes.bytes[pos] = 2;
            OBonsaiCollectionPointer pointer = bag.getPointer();
            if (pointer == null) {
                pointer = OBonsaiCollectionPointer.INVALID;
            }
            OVarIntSerializer.write(bytes, pointer.getFileId());
            OVarIntSerializer.write(bytes, pointer.getRootPointer().getPageIndex());
            OVarIntSerializer.write(bytes, pointer.getRootPointer().getPageOffset());
            OVarIntSerializer.write(bytes, bag.size());
            NavigableMap<OIdentifiable, Change> changes = bag.getChanges();
            if (changes != null) {
                OVarIntSerializer.write(bytes, changes.size());
                for (Map.Entry change : changes.entrySet()) {
                    this.writeOptimizedLink(bytes, (OIdentifiable)change.getKey());
                    int posAll = bytes.alloc(1);
                    bytes.bytes[posAll] = ((Change)change.getValue()).getType();
                    OVarIntSerializer.write(bytes, ((Change)change.getValue()).getValue());
                }
            } else {
                OVarIntSerializer.write(bytes, 0L);
            }
        }
    }

    private ORidBag readRidBag(BytesContainer bytes) {
        UUID uuid = OUUIDSerializer.INSTANCE.deserialize(bytes.bytes, bytes.offset);
        bytes.skip(16);
        if (uuid.getMostSignificantBits() == -1L && uuid.getLeastSignificantBits() == -1L) {
            uuid = null;
        }
        byte b = bytes.bytes[bytes.offset];
        bytes.skip(1);
        if (b == 1) {
            ORidBag bag = new ORidBag(uuid);
            int size = OVarIntSerializer.readAsInteger(bytes);
            for (int i = 0; i < size; ++i) {
                OIdentifiable id = this.readOptimizedLink(bytes);
                if (id.equals(NULL_RECORD_ID)) {
                    bag.add(null);
                    continue;
                }
                bag.add(id);
            }
            return bag;
        }
        long fileId = OVarIntSerializer.readAsLong(bytes);
        long pageIndex = OVarIntSerializer.readAsLong(bytes);
        int pageOffset = OVarIntSerializer.readAsInteger(bytes);
        int bagSize = OVarIntSerializer.readAsInteger(bytes);
        HashMap<OIdentifiable, Change> changes = new HashMap<OIdentifiable, Change>();
        int size = OVarIntSerializer.readAsInteger(bytes);
        while (size-- > 0) {
            OIdentifiable link = this.readOptimizedLink(bytes);
            byte type = bytes.bytes[bytes.offset];
            bytes.skip(1);
            int change = OVarIntSerializer.readAsInteger(bytes);
            changes.put(link, ChangeSerializationHelper.createChangeInstance(type, change));
        }
        OBonsaiCollectionPointer pointer = null;
        if (fileId != -1L) {
            pointer = new OBonsaiCollectionPointer(fileId, new OBonsaiBucketPointer(pageIndex, pageOffset));
        }
        return new ORidBag(pointer, changes, uuid);
    }

    private byte[] readBinary(BytesContainer bytes) {
        int n = OVarIntSerializer.readAsInteger(bytes);
        byte[] newValue = new byte[n];
        System.arraycopy(bytes.bytes, bytes.offset, newValue, 0, newValue.length);
        bytes.skip(n);
        return newValue;
    }

    private Map<Object, OIdentifiable> readLinkMap(BytesContainer bytes, ODocument document) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        ORecordLazyMap result = new ORecordLazyMap(document);
        while (size-- > 0) {
            OType keyType = this.readOType(bytes);
            Object key = this.deserializeValue(bytes, keyType, document);
            OIdentifiable value = this.readOptimizedLink(bytes);
            if (value.equals(NULL_RECORD_ID)) {
                result.put(key, null);
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    private Object readEmbeddedMap(BytesContainer bytes, ODocument document) {
        int size = OVarIntSerializer.readAsInteger(bytes);
        OTrackedMap result = new OTrackedMap(document);
        while (size-- > 0) {
            String key = this.readString(bytes);
            OType valType = this.readOType(bytes);
            Object value = null;
            if (valType != null) {
                value = this.deserializeValue(bytes, valType, document);
            }
            result.put(key, value);
        }
        return result;
    }

    private Collection<OIdentifiable> readLinkCollection(BytesContainer bytes, Collection<OIdentifiable> found) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            OIdentifiable id = this.readOptimizedLink(bytes);
            if (id.equals(NULL_RECORD_ID)) {
                found.add(null);
                continue;
            }
            found.add(id);
        }
        return found;
    }

    private OIdentifiable readOptimizedLink(BytesContainer bytes) {
        Object persRef;
        ORecordId id = new ORecordId(OVarIntSerializer.readAsInteger(bytes), OVarIntSerializer.readAsLong(bytes));
        if (id.isTemporary() && (persRef = id.getRecord()) != null) {
            return persRef;
        }
        return id;
    }

    private Collection<?> readEmbeddedCollection(BytesContainer bytes, Collection<Object> found, ODocument document) {
        int items = OVarIntSerializer.readAsInteger(bytes);
        for (int i = 0; i < items; ++i) {
            OType itemType = this.readOType(bytes);
            if (itemType == null) {
                found.add(null);
                continue;
            }
            found.add(this.deserializeValue(bytes, itemType, document));
        }
        return found;
    }

    private OType getLinkedType(ODocument document, OType type, String key) {
        OProperty prop;
        if (type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDSET && type != OType.EMBEDDEDMAP) {
            return null;
        }
        OImmutableClass immutableClass = ODocumentInternal.getImmutableSchemaClass(document);
        if (immutableClass != null && (prop = immutableClass.getProperty(key)) != null) {
            return prop.getLinkedType();
        }
        return null;
    }

    public void serializeValue(BytesContainer bytes, Object value, OType type, OType linkedType) {
        int pointer = 0;
        switch (type) {
            case INTEGER: 
            case LONG: 
            case SHORT: {
                OVarIntSerializer.write(bytes, ((Number)value).longValue());
                break;
            }
            case STRING: {
                this.writeString(bytes, value.toString());
                break;
            }
            case DOUBLE: {
                long dg = Double.doubleToLongBits((Double)value);
                pointer = bytes.alloc(8);
                OLongSerializer.INSTANCE.serializeLiteral(dg, bytes.bytes, pointer);
                break;
            }
            case FLOAT: {
                int fg = Float.floatToIntBits(((Float)value).floatValue());
                pointer = bytes.alloc(4);
                OIntegerSerializer.INSTANCE.serializeLiteral(fg, bytes.bytes, pointer);
                break;
            }
            case BYTE: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Byte)value;
                break;
            }
            case BOOLEAN: {
                pointer = bytes.alloc(1);
                bytes.bytes[pointer] = (Boolean)value != false ? (byte)1 : 0;
                break;
            }
            case DATETIME: {
                if (value instanceof Long) {
                    OVarIntSerializer.write(bytes, (Long)value);
                    break;
                }
                OVarIntSerializer.write(bytes, ((Date)value).getTime());
                break;
            }
            case DATE: {
                long dateValue = value instanceof Long ? ((Long)value).longValue() : ((Date)value).getTime();
                dateValue = this.convertDayToTimezone(ODateHelper.getDatabaseTimeZone(), TimeZone.getTimeZone("GMT"), dateValue);
                OVarIntSerializer.write(bytes, dateValue / 86400000L);
                break;
            }
            case EMBEDDED: {
                if (value instanceof ODocumentSerializable) {
                    ODocument cur = ((ODocumentSerializable)value).toDocument();
                    cur.field("__orientdb_serilized_class__ ", value.getClass().getName());
                    this.serialize(cur, bytes, false);
                    break;
                }
                this.serialize((ODocument)value, bytes, false);
                break;
            }
            case EMBEDDEDSET: 
            case EMBEDDEDLIST: {
                if (value.getClass().isArray()) {
                    this.writeEmbeddedCollection(bytes, Arrays.asList(OMultiValue.array(value)), linkedType);
                    break;
                }
                this.writeEmbeddedCollection(bytes, (Collection)value, linkedType);
                break;
            }
            case DECIMAL: {
                BigDecimal decimalValue = (BigDecimal)value;
                pointer = bytes.alloc(ODecimalSerializer.INSTANCE.getObjectSize(decimalValue, new Object[0]));
                ODecimalSerializer.INSTANCE.serialize(decimalValue, bytes.bytes, pointer, new Object[0]);
                break;
            }
            case BINARY: {
                pointer = this.writeBinary(bytes, (byte[])value);
                break;
            }
            case LINKSET: 
            case LINKLIST: {
                Collection ridCollection = (Collection)value;
                this.writeLinkCollection(bytes, ridCollection);
                break;
            }
            case LINK: {
                if (!(value instanceof OIdentifiable)) {
                    throw new OValidationException("Value '" + value + "' is not a OIdentifiable");
                }
                this.writeOptimizedLink(bytes, (OIdentifiable)value);
                break;
            }
            case LINKMAP: {
                this.writeLinkMap(bytes, (Map)value);
                break;
            }
            case EMBEDDEDMAP: {
                this.writeEmbeddedMap(bytes, (Map)value);
                break;
            }
            case LINKBAG: {
                this.writeRidBag(bytes, (ORidBag)value);
                break;
            }
            case CUSTOM: {
                if (!(value instanceof OSerializableStream)) {
                    value = new OSerializableWrapper((Serializable)value);
                }
                this.writeString(bytes, value.getClass().getName());
                this.writeBinary(bytes, ((OSerializableStream)value).toStream());
                break;
            }
            case TRANSIENT: {
                break;
            }
        }
    }

    private int writeBinary(BytesContainer bytes, byte[] valueBytes) {
        int pointer = OVarIntSerializer.write(bytes, valueBytes.length);
        int start = bytes.alloc(valueBytes.length);
        System.arraycopy(valueBytes, 0, bytes.bytes, start, valueBytes.length);
        return pointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLinkMap(BytesContainer bytes, Map<Object, OIdentifiable> map) {
        boolean disabledAutoConversion;
        boolean bl = disabledAutoConversion = map instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)map)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(false);
        }
        try {
            int fullPos = OVarIntSerializer.write(bytes, map.size());
            for (Map.Entry<Object, OIdentifiable> entry : map.entrySet()) {
                OType type = OType.STRING;
                this.writeOType(bytes, bytes.alloc(1), type);
                this.writeString(bytes, entry.getKey().toString());
                if (entry.getValue() == null) {
                    this.writeNullLink(bytes);
                    continue;
                }
                this.writeOptimizedLink(bytes, entry.getValue());
            }
            int n = fullPos;
            return n;
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)map)).setAutoConvertToRecord(true);
            }
        }
    }

    private int writeEmbeddedMap(BytesContainer bytes, Map<Object, Object> map) {
        int fullPos = OVarIntSerializer.write(bytes, map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.writeString(bytes, entry.getKey().toString());
            Object value = entry.getValue();
            if (value != null) {
                OType type = this.getTypeFromValueEmbedded(value);
                if (type == null) {
                    throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the Result binary serializer");
                }
                this.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, value, type, null);
                continue;
            }
            this.writeOType(bytes, bytes.alloc(1), null);
        }
        return fullPos;
    }

    private int writeNullLink(BytesContainer bytes) {
        int pos = OVarIntSerializer.write(bytes, NULL_RECORD_ID.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, NULL_RECORD_ID.getIdentity().getClusterPosition());
        return pos;
    }

    private int writeOptimizedLink(BytesContainer bytes, OIdentifiable link) {
        Object real;
        if (!link.getIdentity().isPersistent() && (real = link.getRecord()) != null) {
            link = real;
        }
        int pos = OVarIntSerializer.write(bytes, link.getIdentity().getClusterId());
        OVarIntSerializer.write(bytes, link.getIdentity().getClusterPosition());
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLinkCollection(BytesContainer bytes, Collection<OIdentifiable> value) {
        boolean disabledAutoConversion;
        int pos = OVarIntSerializer.write(bytes, value.size());
        boolean bl = disabledAutoConversion = value instanceof ORecordLazyMultiValue && ((ORecordLazyMultiValue)((Object)value)).isAutoConvertToRecord();
        if (disabledAutoConversion) {
            ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(false);
        }
        try {
            for (OIdentifiable itemValue : value) {
                if (itemValue == null) {
                    this.writeNullLink(bytes);
                    continue;
                }
                this.writeOptimizedLink(bytes, itemValue);
            }
        }
        finally {
            if (disabledAutoConversion) {
                ((ORecordLazyMultiValue)((Object)value)).setAutoConvertToRecord(true);
            }
        }
        return pos;
    }

    private int writeEmbeddedCollection(BytesContainer bytes, Collection<?> value, OType linkedType) {
        int pos = OVarIntSerializer.write(bytes, value.size());
        for (Object itemValue : value) {
            if (itemValue == null) {
                this.writeOType(bytes, bytes.alloc(1), null);
                continue;
            }
            OType type = linkedType == null ? this.getTypeFromValueEmbedded(itemValue) : linkedType;
            if (type != null) {
                this.writeOType(bytes, bytes.alloc(1), type);
                this.serializeValue(bytes, itemValue, type, null);
                continue;
            }
            throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
        }
        return pos;
    }

    private OType getFieldType(ODocumentEntry entry) {
        OProperty prop;
        OType type = entry.type;
        if (type == null && (prop = entry.property) != null) {
            type = prop.getType();
        }
        if (type == null || OType.ANY == type) {
            type = OType.getTypeByValue(entry.value);
        }
        return type;
    }

    private OType getTypeFromValueEmbedded(Object fieldValue) {
        OType type = OType.getTypeByValue(fieldValue);
        if (type == OType.LINK && fieldValue instanceof ODocument && !((ODocument)fieldValue).getIdentity().isValid()) {
            type = OType.EMBEDDED;
        }
        return type;
    }

    protected String readString(BytesContainer bytes) {
        int len = OVarIntSerializer.readAsInteger(bytes);
        String res = this.stringFromBytes(bytes.bytes, bytes.offset, len);
        bytes.skip(len);
        return res;
    }

    protected int readInteger(BytesContainer container) {
        int value = OIntegerSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 4;
        return value;
    }

    private byte readByte(BytesContainer container) {
        return container.bytes[container.offset++];
    }

    private long readLong(BytesContainer container) {
        long value = OLongSerializer.INSTANCE.deserializeLiteral(container.bytes, container.offset);
        container.offset += 8;
        return value;
    }

    private int writeEmptyString(BytesContainer bytes) {
        return OVarIntSerializer.write(bytes, 0L);
    }

    private int writeString(BytesContainer bytes, String toWrite) {
        byte[] nameBytes = this.bytesFromString(toWrite);
        int pointer = OVarIntSerializer.write(bytes, nameBytes.length);
        int start = bytes.alloc(nameBytes.length);
        System.arraycopy(nameBytes, 0, bytes.bytes, start, nameBytes.length);
        return pointer;
    }

    private byte[] bytesFromString(String toWrite) {
        try {
            return toWrite.getBytes(CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string encoding"), e);
        }
    }

    protected String stringFromBytes(byte[] bytes, int offset, int len) {
        try {
            return new String(bytes, offset, len, CHARSET_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSerializationException("Error on string decoding"), e);
        }
    }

    public OBinaryField deserializeField(BytesContainer bytes, OClass iClass, String iFieldName) {
        throw new UnsupportedOperationException("network serializer doesn't support comparators");
    }

    private long convertDayToTimezone(TimeZone from, TimeZone to, long time) {
        Calendar fromCalendar = Calendar.getInstance(from);
        fromCalendar.setTimeInMillis(time);
        Calendar toCalendar = Calendar.getInstance(to);
        toCalendar.setTimeInMillis(0L);
        toCalendar.set(0, fromCalendar.get(0));
        toCalendar.set(1, fromCalendar.get(1));
        toCalendar.set(2, fromCalendar.get(2));
        toCalendar.set(5, fromCalendar.get(5));
        toCalendar.set(11, 0);
        toCalendar.set(12, 0);
        toCalendar.set(13, 0);
        toCalendar.set(14, 0);
        return toCalendar.getTimeInMillis();
    }

    @Override
    public ORecord fromStream(byte[] iSource, ORecord iRecord, String[] iFields) {
        if (iSource == null || iSource.length == 0) {
            return iRecord;
        }
        if (iRecord == null) {
            iRecord = new ODocument();
        } else {
            if (iRecord instanceof OBlob) {
                iRecord.fromStream(iSource);
                return iRecord;
            }
            if (iRecord instanceof ORecordFlat) {
                iRecord.fromStream(iSource);
                return iRecord;
            }
        }
        ORecordInternal.setRecordSerializer(iRecord, this);
        BytesContainer container = new BytesContainer(iSource);
        try {
            if (iFields != null && iFields.length > 0) {
                this.deserializePartial((ODocument)iRecord, container, iFields);
            } else {
                this.deserialize((ODocument)iRecord, container);
            }
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record with id %s send this data for debugging: %s ", iRecord.getIdentity().toString(), Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
        return iRecord;
    }

    @Override
    public byte[] toStream(ORecord iSource, boolean iOnlyDelta) {
        if (iSource instanceof OBlob) {
            return iSource.toStream();
        }
        if (iSource instanceof ORecordFlat) {
            return iSource.toStream();
        }
        BytesContainer container = new BytesContainer();
        this.serialize((ODocument)iSource, container, false);
        return container.fitBytes();
    }

    @Override
    public byte[] writeClassOnly(ORecord iSource) {
        BytesContainer container = new BytesContainer();
        this.serialize((ODocument)iSource, container, true);
        return container.fitBytes();
    }

    @Override
    public int getCurrentVersion() {
        return 0;
    }

    @Override
    public int getMinSupportedVersion() {
        return 0;
    }

    @Override
    public boolean getSupportBinaryEvaluate() {
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public <RET> RET deserializeFieldFromRoot(byte[] record, String iFieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <RET> RET deserializeFieldFromEmbedded(byte[] record, int offset, String iFieldName, int serializerVersion) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String[] getFieldNamesRoot(ODocument reference, byte[] iSource) {
        if (iSource == null || iSource.length == 0) {
            return new String[0];
        }
        BytesContainer container = new BytesContainer(iSource);
        try {
            return this.getFieldNames(reference, container);
        }
        catch (RuntimeException e) {
            OLogManager.instance().warn((Object)this, "Error deserializing record to get field-names, send this data for debugging: %s ", Base64.getEncoder().encodeToString(iSource));
            throw e;
        }
    }

    @Override
    public String[] getFieldNamesEmbedded(ODocument reference, byte[] iSource, int offset, int serializerVersion) {
        return this.getFieldNamesRoot(reference, iSource);
    }
}

