/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.binary;

import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.BytesContainer;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.HelperClasses;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinaryV0;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OVarIntSerializer;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class ORecordSerializerBinaryV1
extends ORecordSerializerBinaryV0 {
    private HelperClasses.Tuple<Boolean, String> processLenLargerThanZeroDeserializePartial(String[] iFields, BytesContainer bytes, int len, byte[][] fields) {
        boolean match = false;
        String fieldName = null;
        for (int i = 0; i < iFields.length; ++i) {
            if (iFields[i] == null || iFields[i].length() != len) continue;
            boolean matchField = true;
            for (int j = 0; j < len; ++j) {
                if (bytes.bytes[bytes.offset + j] == fields[i][j]) continue;
                matchField = false;
                break;
            }
            if (!matchField) continue;
            fieldName = iFields[i];
            bytes.skip(len);
            match = true;
            break;
        }
        return new HelperClasses.Tuple<Boolean, Object>(match, fieldName);
    }

    private HelperClasses.Tuple<Boolean, String> processLenSmallerThanZeroDeserializePartial(OGlobalProperty prop, String[] iFields) {
        String fieldName = prop.getName();
        boolean matchField = false;
        for (String f : iFields) {
            if (!fieldName.equals(f)) continue;
            matchField = true;
            break;
        }
        return new HelperClasses.Tuple<Boolean, String>(matchField, fieldName);
    }

    private HelperClasses.Tuple<Signal, HelperClasses.Triple<Integer, OType, String>> processLessThanZeroDeserializePartialFields(ODocument document, int len, String[] iFields, BytesContainer bytes) {
        OGlobalProperty prop = this.getGlobalProperty(document, len);
        HelperClasses.Tuple<Boolean, String> matchFieldName = this.processLenSmallerThanZeroDeserializePartial(prop, iFields);
        boolean matchField = matchFieldName.getFirstVal();
        String fieldName = matchFieldName.getSecondVal();
        if (!matchField) {
            bytes.skip(4 + (prop.getType() != OType.ANY ? 0 : 1));
            return new HelperClasses.Tuple<Signal, Object>(Signal.CONTINUE, null);
        }
        Integer valuePos = HelperClasses.readInteger(bytes);
        OType type = this.getTypeForLenLessThanZero(prop, bytes);
        HelperClasses.Triple<Integer, OType, String> value = new HelperClasses.Triple<Integer, OType, String>(valuePos, type, fieldName);
        return new HelperClasses.Tuple<Signal, HelperClasses.Triple<Integer, OType, String>>(Signal.RETURN_VALUE, value);
    }

    @Override
    public void deserializePartial(ODocument document, BytesContainer bytes, String[] iFields) {
        int len;
        byte[][] fields = new byte[iFields.length][];
        for (int i = 0; i < iFields.length; ++i) {
            fields[i] = iFields[i].getBytes();
        }
        int unmarshalledFields = 0;
        block4: while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            OType type;
            int valuePos;
            String fieldName;
            if (len > 0) {
                HelperClasses.Tuple<Boolean, String> matchFieldName = this.processLenLargerThanZeroDeserializePartial(iFields, bytes, len, fields);
                boolean match = matchFieldName.getFirstVal();
                fieldName = matchFieldName.getSecondVal();
                if (!match) {
                    bytes.skip(len + 4 + 1);
                    continue;
                }
                valuePos = HelperClasses.readInteger(bytes);
                type = HelperClasses.readOType(bytes);
            } else {
                HelperClasses.Tuple<Signal, HelperClasses.Triple<Integer, OType, String>> actionSignal = this.processLessThanZeroDeserializePartialFields(document, len, iFields, bytes);
                switch (actionSignal.getFirstVal()) {
                    case CONTINUE: {
                        continue block4;
                    }
                }
                valuePos = (Integer)actionSignal.getSecondVal().getFirstVal();
                type = (OType)((Object)actionSignal.getSecondVal().getSecondVal());
                fieldName = actionSignal.getSecondVal().getThirdVal();
            }
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, document);
                bytes.offset = headerCursor;
                ODocumentInternal.rawField(document, fieldName, value, type);
            } else {
                ODocumentInternal.rawField(document, fieldName, null, null);
            }
            if (++unmarshalledFields != iFields.length) continue;
            break;
        }
    }

    @Override
    public void deserializePartialWithClassName(ODocument document, BytesContainer bytes, String[] iFields) {
        String className = HelperClasses.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        this.deserializePartial(document, bytes, iFields);
    }

    private boolean checkMatchForLargerThenZero(BytesContainer bytes, byte[] field, int len) {
        boolean match = true;
        for (int j = 0; j < len; ++j) {
            if (bytes.bytes[bytes.offset + j] == field[j]) continue;
            match = false;
            break;
        }
        return match;
    }

    private OType getTypeForLenLessThanZero(OGlobalProperty prop, BytesContainer bytes) {
        OType type = prop.getType() != OType.ANY ? prop.getType() : HelperClasses.readOType(bytes);
        return type;
    }

    private HelperClasses.Tuple<Signal, OBinaryField> processLenLargerThanZeroDeserializeField(BytesContainer bytes, String iFieldName, byte[] field, int len) {
        if (iFieldName.length() == len) {
            boolean match = this.checkMatchForLargerThenZero(bytes, field, len);
            bytes.skip(len);
            int valuePos = HelperClasses.readInteger(bytes);
            OType type = HelperClasses.readOType(bytes);
            if (valuePos == 0) {
                return new HelperClasses.Tuple<Signal, Object>(Signal.RETURN_VALUE, null);
            }
            if (!match) {
                return new HelperClasses.Tuple<Signal, Object>(Signal.CONTINUE, null);
            }
            if (!this.getComparator().isBinaryComparable(type)) {
                return new HelperClasses.Tuple<Signal, Object>(Signal.RETURN_VALUE, null);
            }
            bytes.offset = valuePos;
            return new HelperClasses.Tuple<Signal, OBinaryField>(Signal.RETURN_VALUE, new OBinaryField(iFieldName, type, bytes, null));
        }
        bytes.skip(len + 4 + 1);
        return new HelperClasses.Tuple<Signal, Object>(Signal.NO_ACTION, null);
    }

    private HelperClasses.Tuple<Signal, OBinaryField> processLenLessThanZeroDeserializeField(int len, OImmutableSchema _schema, String iFieldName, OClass iClass, BytesContainer bytes) {
        int id = len * -1 - 1;
        OGlobalProperty prop = _schema.getGlobalPropertyById(id);
        if (iFieldName.equals(prop.getName())) {
            int valuePos = HelperClasses.readInteger(bytes);
            OType type = this.getTypeForLenLessThanZero(prop, bytes);
            if (valuePos == 0 || !this.getComparator().isBinaryComparable(type)) {
                return new HelperClasses.Tuple<Signal, Object>(Signal.RETURN_VALUE, null);
            }
            bytes.offset = valuePos;
            OProperty classProp = iClass.getProperty(iFieldName);
            return new HelperClasses.Tuple<Signal, OBinaryField>(Signal.RETURN_VALUE, new OBinaryField(iFieldName, type, bytes, classProp != null ? classProp.getCollate() : null));
        }
        bytes.skip(4 + (prop.getType() != OType.ANY ? 0 : 1));
        return new HelperClasses.Tuple<Signal, Object>(Signal.NO_ACTION, null);
    }

    @Override
    public OBinaryField deserializeField(BytesContainer bytes, OClass iClass, String iFieldName) {
        byte[] field = iFieldName.getBytes();
        OMetadataInternal metadata = ODatabaseRecordThreadLocal.instance().get().getMetadata();
        OImmutableSchema _schema = metadata.getImmutableSchemaSnapshot();
        int len;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            HelperClasses.Tuple<Signal, OBinaryField> actionSignal;
            if (len > 0) {
                actionSignal = this.processLenLargerThanZeroDeserializeField(bytes, iFieldName, field, len);
                switch (actionSignal.getFirstVal()) {
                    case RETURN_VALUE: {
                        return actionSignal.getSecondVal();
                    }
                }
                continue;
            }
            actionSignal = this.processLenLessThanZeroDeserializeField(len, _schema, iFieldName, iClass, bytes);
            switch (actionSignal.getFirstVal()) {
                case RETURN_VALUE: {
                    return actionSignal.getSecondVal();
                }
            }
        }
        return null;
    }

    @Override
    public OBinaryField deserializeFieldWithClassName(BytesContainer bytes, OClass iClass, String iFieldName) {
        int classNameLen = OVarIntSerializer.readAsInteger(bytes);
        bytes.skip(classNameLen);
        return this.deserializeField(bytes, iClass, iFieldName);
    }

    @Override
    public void deserialize(ODocument document, BytesContainer bytes) {
        int len;
        int last = 0;
        while ((len = OVarIntSerializer.readAsInteger(bytes)) != 0) {
            OType type;
            int valuePos;
            String fieldName;
            if (len > 0) {
                fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                bytes.skip(len);
                valuePos = HelperClasses.readInteger(bytes);
                type = HelperClasses.readOType(bytes);
            } else {
                OGlobalProperty prop = this.getGlobalProperty(document, len);
                fieldName = prop.getName();
                valuePos = HelperClasses.readInteger(bytes);
                type = this.getTypeForLenLessThanZero(prop, bytes);
            }
            if (ODocumentInternal.rawContainsField(document, fieldName)) continue;
            if (valuePos != 0) {
                int headerCursor = bytes.offset;
                bytes.offset = valuePos;
                Object value = this.deserializeValue(bytes, type, document);
                if (bytes.offset > last) {
                    last = bytes.offset;
                }
                bytes.offset = headerCursor;
                ODocumentInternal.rawField(document, fieldName, value, type);
                continue;
            }
            ODocumentInternal.rawField(document, fieldName, null, null);
        }
        ORecordInternal.clearSource(document);
        if (last > bytes.offset) {
            bytes.offset = last;
        }
    }

    @Override
    public void deserializeWithClassName(ODocument document, BytesContainer bytes) {
        String className = HelperClasses.readString(bytes);
        if (className.length() != 0) {
            ODocumentInternal.fillClassNameIfNeeded(document, className);
        }
        this.deserialize(document, bytes);
    }

    @Override
    public String[] getFieldNames(ODocument reference, BytesContainer bytes, boolean readClassName) {
        if (readClassName) {
            int classNameLen = OVarIntSerializer.readAsInteger(bytes);
            bytes.skip(classNameLen);
        }
        ArrayList<String> result = new ArrayList<String>();
        while (true) {
            OGlobalProperty prop = null;
            int len = OVarIntSerializer.readAsInteger(bytes);
            if (len == 0) break;
            if (len > 0) {
                String fieldName = HelperClasses.stringFromBytes(bytes.bytes, bytes.offset, len).intern();
                result.add(fieldName);
                bytes.skip(len + 4 + 1);
                continue;
            }
            int id = len * -1 - 1;
            prop = ODocumentInternal.getGlobalPropertyById(reference, id);
            if (prop == null) {
                throw new OSerializationException("Missing property definition for property id '" + id + "'");
            }
            result.add(prop.getName());
            bytes.skip(4 + (prop.getType() != OType.ANY ? 0 : 1));
        }
        return result.toArray(new String[result.size()]);
    }

    private int serializeAllocateSpace(BytesContainer bytes, Map.Entry<String, ODocumentEntry>[] values, Map<String, OProperty> props, Set<Map.Entry<String, ODocumentEntry>> fields, int[] pos) {
        int i = 0;
        for (Map.Entry<String, ODocumentEntry> entry : fields) {
            OProperty prop;
            ODocumentEntry docEntry = entry.getValue();
            if (!docEntry.exist()) continue;
            if (docEntry.property == null && props != null && (prop = props.get(entry.getKey())) != null && docEntry.type == prop.getType()) {
                docEntry.property = prop;
            }
            if (docEntry.property != null) {
                int id = docEntry.property.getId();
                OVarIntSerializer.write(bytes, (id + 1) * -1);
                pos[i] = docEntry.property.getType() != OType.ANY ? bytes.alloc(4) : bytes.alloc(5);
            } else {
                this.writeString(bytes, entry.getKey());
                pos[i] = bytes.alloc(5);
            }
            values[i] = entry;
            ++i;
        }
        return i;
    }

    private void serializeWriteValues(BytesContainer bytes, ODocument document, int size, Map.Entry<String, ODocumentEntry>[] values, int[] pos) {
        for (int i = 0; i < size; ++i) {
            Object value = values[i].getValue().value;
            if (value == null) continue;
            OType type = this.getFieldType(values[i].getValue());
            if (type == null) {
                throw new OSerializationException("Impossible serialize value of type " + value.getClass() + " with the ODocument binary serializer");
            }
            int pointer = this.serializeValue(bytes, value, type, this.getLinkedType(document, type, values[i].getKey()));
            OIntegerSerializer.INSTANCE.serializeLiteral(pointer, bytes.bytes, pos[i]);
            if (values[i].getValue().property != null && values[i].getValue().property.getType() != OType.ANY) continue;
            HelperClasses.writeOType(bytes, pos[i] + 4, type);
        }
    }

    private void serializeDocument(ODocument document, BytesContainer bytes, OClass clazz) {
        Map<String, OProperty> props = clazz != null ? clazz.propertiesMap() : null;
        Set<Map.Entry<String, ODocumentEntry>> fields = ODocumentInternal.rawEntries(document);
        int[] pos = new int[fields.size()];
        Map.Entry[] values = new Map.Entry[fields.size()];
        int i = this.serializeAllocateSpace(bytes, values, props, fields, pos);
        this.writeEmptyString(bytes);
        this.serializeWriteValues(bytes, document, i, values, pos);
    }

    @Override
    public void serializeWithClassName(ODocument document, BytesContainer bytes, boolean iClassOnly) {
        OClass clazz = this.serializeClass(document, bytes, true);
        if (iClassOnly) {
            this.writeEmptyString(bytes);
            return;
        }
        this.serializeDocument(document, bytes, clazz);
    }

    @Override
    public void serialize(ODocument document, BytesContainer bytes, boolean iClassOnly) {
        OClass clazz = this.serializeClass(document, bytes, false);
        if (iClassOnly) {
            this.writeEmptyString(bytes);
            return;
        }
        this.serializeDocument(document, bytes, clazz);
    }

    protected OClass serializeClass(ODocument document, BytesContainer bytes, boolean serializeClassName) {
        OImmutableClass clazz = ODocumentInternal.getImmutableSchemaClass(document);
        if (serializeClassName) {
            if (clazz != null && document.isEmbedded()) {
                this.writeString(bytes, clazz.getName());
            } else {
                this.writeEmptyString(bytes);
            }
        }
        return clazz;
    }

    @Override
    public boolean isSerializingClassNameByDefault() {
        return false;
    }

    @Override
    public <RET> RET deserializeFieldTyped(BytesContainer bytes, String iFieldName, boolean isEmbedded, int serializerVersion) {
        if (isEmbedded) {
            this.skipClassName(bytes);
        }
        return this.deserializeFieldTypedLoopAndReturn(bytes, iFieldName, serializerVersion);
    }

    @Override
    public boolean isSerializingClassNameForEmbedded() {
        return true;
    }

    private static enum Signal {
        CONTINUE,
        RETURN,
        RETURN_VALUE,
        NO_ACTION;

    }
}

