/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.OEdgeIterator;
import com.orientechnologies.orient.core.record.impl.OEdgeToVertexIterable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;

public class OVertexDelegate
implements OVertex {
    private static final String CONNECTION_OUT_PREFIX = "out_";
    private static final String CONNECTION_IN_PREFIX = "in_";
    protected final ODocument element;

    public OVertexDelegate(ODocument entry) {
        this.element = entry;
    }

    @Override
    public Iterable<OEdge> getEdges(ODirection direction) {
        String[] fieldNames;
        HashSet<String> prefixes = new HashSet<String>();
        switch (direction) {
            case BOTH: {
                prefixes.add(CONNECTION_IN_PREFIX);
            }
            case OUT: {
                prefixes.add(CONNECTION_OUT_PREFIX);
                break;
            }
            case IN: {
                prefixes.add(CONNECTION_IN_PREFIX);
            }
        }
        HashSet candidateClasses = new HashSet();
        for (String fieldName : fieldNames = this.element.fieldNames()) {
            prefixes.stream().filter(prefix -> fieldName.startsWith((String)prefix)).forEach(prefix -> {
                if (fieldName.equals(prefix)) {
                    candidateClasses.add("E");
                } else {
                    candidateClasses.add(fieldName.substring(prefix.length()));
                }
            });
        }
        return this.getEdges(direction, candidateClasses.toArray(new String[0]));
    }

    @Override
    public Iterable<OEdge> getEdges(ODirection direction, String ... labels) {
        OMultiCollectionIterator<OEdge> iterable = new OMultiCollectionIterator().setEmbedded(true);
        Set<String> fieldNames = null;
        if (labels != null && labels.length > 0 && (fieldNames = this.getEdgeFieldNames(direction, labels)) != null) {
            this.element.deserializeFields(fieldNames.toArray(new String[0]));
        }
        if (fieldNames == null) {
            fieldNames = this.getPropertyNames();
        }
        for (String fieldName : fieldNames) {
            Object fieldValue;
            OPair<ODirection, String> connection = this.getConnection(direction, fieldName, labels);
            if (connection == null || (fieldValue = this.getProperty(fieldName)) == null) continue;
            Object destinationVId = null;
            if (fieldValue instanceof OIdentifiable) {
                fieldValue = Collections.singleton(fieldValue);
            }
            if (fieldValue instanceof Collection) {
                Collection coll = (Collection)fieldValue;
                if (coll instanceof ORecordLazyMultiValue) {
                    iterable.add(new OEdgeIterator(this, coll, ((ORecordLazyMultiValue)((Object)coll)).rawIterator(), connection, labels, coll.size()));
                    continue;
                }
                iterable.add(new OEdgeIterator(this, coll, coll.iterator(), connection, labels, -1));
                continue;
            }
            if (!(fieldValue instanceof ORidBag)) continue;
            iterable.add(new OEdgeIterator(this, fieldValue, ((ORidBag)fieldValue).rawIterator(), connection, labels, ((ORidBag)fieldValue).size()));
        }
        return iterable;
    }

    @Override
    public Iterable<OEdge> getEdges(ODirection direction, OClass ... type) {
        ArrayList<String> types = new ArrayList<String>();
        if (type != null) {
            for (OClass t : type) {
                types.add(t.getName());
            }
        }
        return this.getEdges(direction, types.toArray(new String[0]));
    }

    @Override
    public Iterable<OVertex> getVertices(ODirection direction) {
        return this.getVertices(direction, (String[])null);
    }

    @Override
    public Iterable<OVertex> getVertices(ODirection direction, String ... type) {
        if (direction == ODirection.BOTH) {
            OMultiCollectionIterator<OVertex> result = new OMultiCollectionIterator<OVertex>();
            result.add(this.getVertices(ODirection.OUT, type));
            result.add(this.getVertices(ODirection.IN, type));
            return result;
        }
        Iterable<OEdge> edges = this.getEdges(direction, type);
        return new OEdgeToVertexIterable(edges, direction);
    }

    @Override
    public Iterable<OVertex> getVertices(ODirection direction, OClass ... type) {
        ArrayList<String> types = new ArrayList<String>();
        if (type != null) {
            for (OClass t : type) {
                types.add(t.getName());
            }
        }
        return this.getVertices(direction, types.toArray(new String[0]));
    }

    @Override
    public OEdge addEdge(OVertex to) {
        return this.addEdge(to, "E");
    }

    public OVertex delete() {
        OVertexDelegate.deleteLinks(this);
        this.element.delete();
        return this;
    }

    public static void deleteLinks(OVertex delegate) {
        Iterable<OEdge> allEdges = delegate.getEdges(ODirection.BOTH);
        for (OEdge edge : allEdges) {
            edge.delete();
        }
    }

    protected static void detachOutgointEdge(OVertex vertex, OEdge edge) {
        OVertexDelegate.detachEdge(vertex, edge, CONNECTION_OUT_PREFIX);
    }

    protected static void detachIncomingEdge(OVertex vertex, OEdge edge) {
        OVertexDelegate.detachEdge(vertex, edge, CONNECTION_IN_PREFIX);
    }

    protected static void detachEdge(OVertex vertex, OEdge edge, String fieldPrefix) {
        String className = edge.getSchemaType().get().getName();
        if (className.equalsIgnoreCase("e")) {
            className = "";
        }
        String edgeField = fieldPrefix + className;
        Object edgeProp = vertex.getProperty(edgeField);
        OIdentifiable edgeId = null;
        edgeId = edge.getIdentity();
        if (edgeId == null) {
            OVertex out = edge.getFrom();
            OVertex in = edge.getTo();
            edgeId = vertex.getIdentity().equals(out) ? (OIdentifiable)in : (OIdentifiable)out;
        }
        if (edgeProp instanceof Collection) {
            ((Collection)edgeProp).remove(edgeId);
        } else if (edgeProp instanceof ORidBag) {
            ((ORidBag)edgeProp).remove(edgeId);
        } else {
            OLogManager.instance().warn((Object)vertex, "Error detaching edge: the vertex collection field is of type " + (edgeProp == null ? "null" : edgeProp.getClass()), new Object[0]);
        }
    }

    @Override
    public OEdge addEdge(OVertex to, String type) {
        ODatabaseDocument db = this.getDatabase();
        return db.newEdge((OVertex)this, to, type == null ? "E" : type);
    }

    @Override
    public OEdge addEdge(OVertex to, OClass type) {
        String className = "E";
        if (type != null) {
            className = type.getName();
        }
        return this.addEdge(to, className);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.element.getPropertyNames();
    }

    @Override
    public <RET> RET getProperty(String name) {
        return this.element.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) {
        this.element.setProperty(name, value);
    }

    @Override
    public void setProperty(String name, Object value, OType ... fieldType) {
        this.element.setProperty(name, value, fieldType);
    }

    @Override
    public <RET> RET removeProperty(String name) {
        return this.element.removeProperty(name);
    }

    @Override
    public Optional<OVertex> asVertex() {
        return Optional.of(this);
    }

    @Override
    public Optional<OEdge> asEdge() {
        return Optional.empty();
    }

    @Override
    public boolean isVertex() {
        return true;
    }

    @Override
    public boolean isEdge() {
        return false;
    }

    @Override
    public Optional<OClass> getSchemaType() {
        return Optional.ofNullable(this.element.getSchemaClass());
    }

    @Override
    public <T extends ORecord> T getRecord() {
        return (T)this.element;
    }

    @Override
    public void lock(boolean iExclusive) {
        this.element.lock(iExclusive);
    }

    @Override
    public boolean isLocked() {
        return this.element.isLocked();
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return this.element.lockingStrategy();
    }

    @Override
    public void unlock() {
        this.element.unlock();
    }

    @Override
    public int compareTo(OIdentifiable o) {
        return this.element.compareTo(o);
    }

    @Override
    public int compare(OIdentifiable o1, OIdentifiable o2) {
        return this.element.compare(o1, o2);
    }

    protected OPair<ODirection, String> getConnection(ODirection iDirection, String iFieldName, String ... iClassNames) {
        OClass type;
        if (iClassNames != null && iClassNames.length == 1 && iClassNames[0].equalsIgnoreCase("E")) {
            iClassNames = null;
        }
        OSchema schema = ODatabaseRecordThreadLocal.instance().get().getMetadata().getSchema();
        if ((iDirection == ODirection.OUT || iDirection == ODirection.BOTH) && iFieldName.startsWith(CONNECTION_OUT_PREFIX)) {
            if (iClassNames == null || iClassNames.length == 0) {
                return new OPair<ODirection, String>(ODirection.OUT, this.getConnectionClass(ODirection.OUT, iFieldName));
            }
            for (String clsName : iClassNames) {
                if (iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) {
                    return new OPair<ODirection, String>(ODirection.OUT, clsName);
                }
                type = schema.getClass(clsName);
                if (type == null) continue;
                for (OClass subType : type.getAllSubclasses()) {
                    clsName = subType.getName();
                    if (!iFieldName.equals(CONNECTION_OUT_PREFIX + clsName)) continue;
                    return new OPair<ODirection, String>(ODirection.OUT, clsName);
                }
            }
        }
        if ((iDirection == ODirection.IN || iDirection == ODirection.BOTH) && iFieldName.startsWith(CONNECTION_IN_PREFIX)) {
            if (iClassNames == null || iClassNames.length == 0) {
                return new OPair<ODirection, String>(ODirection.IN, this.getConnectionClass(ODirection.IN, iFieldName));
            }
            for (String clsName : iClassNames) {
                if (iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) {
                    return new OPair<ODirection, String>(ODirection.IN, clsName);
                }
                type = schema.getClass(clsName);
                if (type == null) continue;
                for (OClass subType : type.getAllSubclasses()) {
                    clsName = subType.getName();
                    if (!iFieldName.equals(CONNECTION_IN_PREFIX + clsName)) continue;
                    return new OPair<ODirection, String>(ODirection.IN, clsName);
                }
            }
        }
        return null;
    }

    private String getConnectionClass(ODirection iDirection, String iFieldName) {
        if (iDirection == ODirection.OUT) {
            if (iFieldName.length() > CONNECTION_OUT_PREFIX.length()) {
                return iFieldName.substring(CONNECTION_OUT_PREFIX.length());
            }
        } else if (iDirection == ODirection.IN && iFieldName.length() > CONNECTION_IN_PREFIX.length()) {
            return iFieldName.substring(CONNECTION_IN_PREFIX.length());
        }
        return "E";
    }

    private boolean isSubclassOfAny(OClass clazz, String[] labels) {
        for (String s : labels) {
            if (!clazz.isSubClassOf(s)) continue;
            return true;
        }
        return false;
    }

    protected Set<String> getEdgeFieldNames(ODirection iDirection, String ... iClassNames) {
        if (iClassNames != null && iClassNames.length == 1 && iClassNames[0].equalsIgnoreCase("E")) {
            iClassNames = null;
        }
        HashSet<String> result = new HashSet<String>();
        if (iClassNames == null) {
            return null;
        }
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (db == null) {
            return null;
        }
        OSchema schema = db.getMetadata().getSchema();
        HashSet<String> allClassNames = new HashSet<String>();
        for (String className : iClassNames) {
            allClassNames.add(className);
            OClass clazz = schema.getClass(className);
            if (clazz == null) continue;
            Collection<OClass> subClasses = clazz.getAllSubclasses();
            for (OClass subClass : subClasses) {
                allClassNames.add(subClass.getName());
            }
        }
        for (String className : allClassNames) {
            switch (iDirection) {
                case OUT: {
                    result.add(CONNECTION_OUT_PREFIX + className);
                    break;
                }
                case IN: {
                    result.add(CONNECTION_IN_PREFIX + className);
                    break;
                }
                case BOTH: {
                    result.add(CONNECTION_OUT_PREFIX + className);
                    result.add(CONNECTION_IN_PREFIX + className);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createLink(ODocument iFromVertex, OIdentifiable iTo, String iFieldName) {
        void var3_18;
        OType propType;
        OType outType = iFromVertex.fieldType(iFieldName);
        Object found = iFromVertex.field(iFieldName);
        OImmutableClass linkClass = ODocumentInternal.getImmutableSchemaClass(iFromVertex);
        if (linkClass == null) {
            throw new IllegalArgumentException("Class not found in source vertex: " + iFromVertex);
        }
        OProperty prop = linkClass.getProperty(iFieldName);
        OType oType = propType = prop != null && prop.getType() != OType.ANY ? prop.getType() : null;
        if (found == null) {
            if (propType == OType.LINKLIST || prop != null && "true".equalsIgnoreCase(prop.getCustom("ordered"))) {
                ORecordLazyList coll = new ORecordLazyList(iFromVertex);
                coll.add(iTo);
                ORecordLazyList oRecordLazyList = coll;
                outType = OType.LINKLIST;
            } else {
                if (propType != null && propType != OType.LINKBAG) throw new IllegalStateException("Type of field provided in schema '" + (Object)((Object)prop.getType()) + "' cannot be used for link creation.");
                ORidBag bag = new ORidBag();
                bag.add(iTo);
                ORidBag oRidBag = bag;
                outType = OType.LINKBAG;
            }
        } else if (found instanceof OIdentifiable) {
            if (prop != null && propType == OType.LINK) {
                throw new IllegalStateException("Type of field provided in schema '" + (Object)((Object)prop.getType()) + "' cannot be used for creation to hold several links.");
            }
            if (prop != null && "true".equalsIgnoreCase(prop.getCustom("ordered"))) {
                ORecordLazyList coll = new ORecordLazyList(iFromVertex);
                coll.add(found);
                coll.add(iTo);
                ORecordLazyList oRecordLazyList = coll;
                outType = OType.LINKLIST;
            } else {
                ORidBag bag = new ORidBag();
                bag.add((OIdentifiable)found);
                bag.add(iTo);
                ORidBag oRidBag = bag;
                outType = OType.LINKBAG;
            }
        } else if (found instanceof ORidBag) {
            Object var3_16 = null;
            ((ORidBag)found).add((OIdentifiable)iTo.getRecord());
        } else {
            if (!(found instanceof Collection)) throw new IllegalStateException("Relationship content is invalid on field " + iFieldName + ". Found: " + found);
            Object var3_17 = null;
            ((Collection)found).add(iTo);
        }
        if (var3_18 == null) return var3_18;
        iFromVertex.field(iFieldName, var3_18, outType);
        return var3_18;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OIdentifiable)) {
            return false;
        }
        if (!(obj instanceof OElement)) {
            obj = ((OIdentifiable)obj).getRecord();
        }
        return this.element.equals(((OElement)obj).getRecord());
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.element.getInternalStatus();
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.element.setInternalStatus(iStatus);
    }

    @Override
    public <RET> RET setDirty() {
        this.element.setDirty();
        return (RET)this;
    }

    @Override
    public void setDirtyNoChanged() {
        this.element.setDirtyNoChanged();
    }

    @Override
    public ORecordElement getOwner() {
        return this.element.getOwner();
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        return this.element.toStream();
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        return this.element.fromStream(iStream);
    }

    @Override
    public boolean detach() {
        return this.element.detach();
    }

    @Override
    public <RET extends ORecord> RET reset() {
        this.element.reset();
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET unload() {
        this.element.unload();
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET clear() {
        this.element.clear();
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET copy() {
        return (RET)new OVertexDelegate(this.element.copy());
    }

    @Override
    public ORID getIdentity() {
        return this.element.getIdentity();
    }

    @Override
    public int getVersion() {
        return this.element.getVersion();
    }

    @Override
    public ODatabaseDocument getDatabase() {
        return this.element.getDatabase();
    }

    @Override
    public boolean isDirty() {
        return this.element.isDirty();
    }

    @Override
    public <RET extends ORecord> RET load() throws ORecordNotFoundException {
        return (RET)this.element.load();
    }

    @Override
    public <RET extends ORecord> RET reload() throws ORecordNotFoundException {
        this.element.reload();
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET reload(String fetchPlan, boolean ignoreCache, boolean force) throws ORecordNotFoundException {
        this.element.reload(fetchPlan, ignoreCache, force);
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET save() {
        this.element.save();
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET save(String iCluster) {
        this.element.save(iCluster);
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET save(boolean forceCreate) {
        this.element.save(forceCreate);
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET save(String iCluster, boolean forceCreate) {
        this.element.save(iCluster, forceCreate);
        return (RET)this;
    }

    @Override
    public <RET extends ORecord> RET fromJSON(String iJson) {
        this.element.fromJSON(iJson);
        return (RET)this;
    }

    @Override
    public String toJSON() {
        return this.element.toJSON();
    }

    @Override
    public String toJSON(String iFormat) {
        return this.element.toJSON(iFormat);
    }

    @Override
    public int getSize() {
        return this.element.getSize();
    }

    @Override
    public ORID moveTo(String iClassName, String iClusterName) {
        if (this.checkDeletedInTx()) {
            throw new ORecordNotFoundException(this.getIdentity(), "The vertex " + this.getIdentity() + " has been deleted");
        }
        ORID oldIdentity = this.getIdentity().copy();
        Object oldRecord = oldIdentity.getRecord();
        if (oldRecord == null) {
            throw new ORecordNotFoundException(this.getIdentity(), "The vertex " + this.getIdentity() + " has been deleted");
        }
        ODocument doc = ((ODocument)this.getRecord()).copy();
        Iterable<OEdge> outEdges = this.getEdges(ODirection.OUT);
        Iterable<OEdge> inEdges = this.getEdges(ODirection.IN);
        this.copyRidBags((ORecord)oldRecord, doc);
        oldRecord.delete();
        if (iClassName != null) {
            doc.setClassName(iClassName);
        }
        doc.setDirty();
        ORecordInternal.setIdentity(doc, new ORecordId());
        if (iClusterName != null) {
            doc.save(iClusterName);
        } else {
            doc.save();
        }
        ORID newIdentity = doc.getIdentity();
        for (OEdge oe : outEdges) {
            if (oe.isLightweight()) {
                OVertex inV = oe.getVertex(ODirection.IN);
                String inFieldName = OVertexDelegate.getConnectionFieldName(ODirection.IN, oe.getSchemaType().map(x -> x.getName()).orElse(null), true);
                OVertexDelegate.replaceLinks((ODocument)inV.getRecord(), inFieldName, oldIdentity, newIdentity);
                continue;
            }
            oe.setProperty("out", newIdentity);
            oe.save();
        }
        for (OEdge oe : inEdges) {
            if (oe.isLightweight()) {
                OVertex outV = oe.getVertex(ODirection.OUT);
                String outFieldName = OVertexDelegate.getConnectionFieldName(ODirection.OUT, oe.getSchemaType().map(x -> x.getName()).orElse(null), true);
                OVertexDelegate.replaceLinks((ODocument)outV.getRecord(), outFieldName, oldIdentity, newIdentity);
                continue;
            }
            oe.setProperty("in", newIdentity);
            oe.save();
        }
        doc.save();
        return newIdentity;
    }

    protected boolean checkDeletedInTx() {
        ODatabaseDocument db = this.getDatabase();
        if (db == null) {
            return false;
        }
        if (this.getRecord() == null) {
            return false;
        }
        ORID id = this.getRecord().getIdentity();
        ORecordOperation oper = db.getTransaction().getRecordEntry(id);
        if (oper == null) {
            return id.isTemporary();
        }
        return oper.type == 2;
    }

    private void copyRidBags(ORecord oldRecord, ODocument newDoc) {
        ODocument oldDoc = (ODocument)oldRecord;
        for (String field : oldDoc.fieldNames()) {
            ORidBag bag;
            Object val;
            if (!field.equalsIgnoreCase("out") && !field.equalsIgnoreCase("in") && !field.startsWith(CONNECTION_OUT_PREFIX) && !field.startsWith(CONNECTION_IN_PREFIX) && !field.startsWith("OUT_") && !field.startsWith("IN_") || !((val = oldDoc.rawField(field)) instanceof ORidBag) || (bag = (ORidBag)val).isEmbedded()) continue;
            ORidBag newBag = new ORidBag();
            Iterator<OIdentifiable> rawIter = bag.rawIterator();
            while (rawIter.hasNext()) {
                newBag.add(rawIter.next());
            }
            newDoc.field(field, newBag);
        }
    }

    public static String getConnectionFieldName(ODirection iDirection, String iClassName, boolean useVertexFieldsForEdgeLabels) {
        if (iDirection == null || iDirection == ODirection.BOTH) {
            throw new IllegalArgumentException("Direction not valid");
        }
        if (useVertexFieldsForEdgeLabels) {
            String prefix;
            String string = prefix = iDirection == ODirection.OUT ? CONNECTION_OUT_PREFIX : CONNECTION_IN_PREFIX;
            if (iClassName == null || iClassName.isEmpty() || iClassName.equals("E")) {
                return prefix;
            }
            return prefix + iClassName;
        }
        return iDirection == ODirection.OUT ? "out" : "in";
    }

    public static void replaceLinks(ODocument iVertex, String iFieldName, OIdentifiable iVertexToRemove, OIdentifiable iNewVertex) {
        Collection col;
        Object fieldValue;
        if (iVertex == null) {
            return;
        }
        Object object = fieldValue = iVertexToRemove != null ? iVertex.field(iFieldName) : iVertex.removeField(iFieldName);
        if (fieldValue == null) {
            return;
        }
        if (fieldValue instanceof OIdentifiable) {
            if (iVertexToRemove != null) {
                if (!fieldValue.equals(iVertexToRemove)) {
                    return;
                }
                iVertex.field(iFieldName, iNewVertex);
            }
        } else if (fieldValue instanceof ORidBag) {
            ORidBag bag = (ORidBag)fieldValue;
            boolean found = false;
            Iterator<OIdentifiable> it = bag.rawIterator();
            while (it.hasNext()) {
                if (!it.next().equals(iVertexToRemove)) continue;
                found = true;
                it.remove();
            }
            if (found) {
                bag.add(iNewVertex);
            }
        } else if (fieldValue instanceof Collection && (col = (Collection)fieldValue).remove(iVertexToRemove)) {
            col.add(iNewVertex);
        }
        iVertex.save();
    }

    public String toString() {
        if (this.element != null) {
            return this.element.toString();
        }
        return super.toString();
    }
}

