/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.query.live;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.query.live.OLiveQueryListenerV2;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;

public class OLiveQueryQueueThreadV2
extends Thread {
    private final BlockingQueue<OLiveQueryHookV2.OLiveQueryOp> queue;
    private final ConcurrentMap<Integer, OLiveQueryListenerV2> subscribers;
    private boolean stopped = false;

    private OLiveQueryQueueThreadV2(BlockingQueue<OLiveQueryHookV2.OLiveQueryOp> queue, ConcurrentMap<Integer, OLiveQueryListenerV2> subscribers) {
        this.queue = queue;
        this.subscribers = subscribers;
    }

    public OLiveQueryQueueThreadV2() {
        this(new LinkedBlockingQueue<OLiveQueryHookV2.OLiveQueryOp>(), new ConcurrentHashMap<Integer, OLiveQueryListenerV2>());
        this.setName("LiveQueryQueueThreadV2");
        this.setDaemon(true);
    }

    @Override
    public OLiveQueryQueueThreadV2 clone() {
        return new OLiveQueryQueueThreadV2(this.queue, this.subscribers);
    }

    @Override
    public void run() {
        while (!this.stopped) {
            OLiveQueryHookV2.OLiveQueryOp next = null;
            try {
                next = this.queue.take();
            }
            catch (InterruptedException ignore) {
                break;
            }
            if (next == null) continue;
            for (OLiveQueryListenerV2 listener : this.subscribers.values()) {
                try {
                    listener.onLiveResult(next);
                }
                catch (Exception e) {
                    OLogManager.instance().warn((Object)this, "Error executing live query subscriber.", e, new Object[0]);
                }
            }
        }
    }

    public void stopExecution() {
        this.stopped = true;
        this.interrupt();
    }

    public void enqueue(OLiveQueryHookV2.OLiveQueryOp item) {
        this.queue.offer(item);
    }

    public Integer subscribe(Integer id, OLiveQueryListenerV2 iListener) {
        this.subscribers.put(id, iListener);
        return id;
    }

    public void unsubscribe(Integer id) {
        OLiveQueryListenerV2 res = (OLiveQueryListenerV2)this.subscribers.remove(id);
        if (res != null) {
            res.onLiveResultEnd();
        }
    }

    public boolean hasListeners() {
        return !this.subscribers.isEmpty();
    }

    public boolean hasToken(Integer key) {
        return this.subscribers.containsKey(key);
    }
}

