/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.types.OBinary;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.ODocumentSerializable;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public enum OType {
    BOOLEAN("Boolean", 0, Boolean.class, new Class[]{Number.class}),
    INTEGER("Integer", 1, Integer.class, new Class[]{Number.class}),
    SHORT("Short", 2, Short.class, new Class[]{Number.class}),
    LONG("Long", 3, Long.class, new Class[]{Number.class}),
    FLOAT("Float", 4, Float.class, new Class[]{Number.class}),
    DOUBLE("Double", 5, Double.class, new Class[]{Number.class}),
    DATETIME("Datetime", 6, Date.class, new Class[]{Date.class, Number.class}),
    STRING("String", 7, String.class, new Class[]{Enum.class}),
    BINARY("Binary", 8, byte[].class, new Class[]{byte[].class}),
    EMBEDDED("Embedded", 9, Object.class, new Class[]{ODocumentSerializable.class, OSerializableStream.class}),
    EMBEDDEDLIST("EmbeddedList", 10, List.class, new Class[]{List.class, OMultiCollectionIterator.class}),
    EMBEDDEDSET("EmbeddedSet", 11, Set.class, new Class[]{Set.class}),
    EMBEDDEDMAP("EmbeddedMap", 12, Map.class, new Class[]{Map.class}),
    LINK("Link", 13, OIdentifiable.class, new Class[]{OIdentifiable.class, ORID.class}),
    LINKLIST("LinkList", 14, List.class, new Class[]{List.class}),
    LINKSET("LinkSet", 15, Set.class, new Class[]{Set.class}),
    LINKMAP("LinkMap", 16, Map.class, new Class[]{Map.class}),
    BYTE("Byte", 17, Byte.class, new Class[]{Number.class}),
    TRANSIENT("Transient", 18, null, new Class[0]),
    DATE("Date", 19, Date.class, new Class[]{Number.class}),
    CUSTOM("Custom", 20, OSerializableStream.class, new Class[]{OSerializableStream.class, Serializable.class}),
    DECIMAL("Decimal", 21, BigDecimal.class, new Class[]{BigDecimal.class, Number.class}),
    LINKBAG("LinkBag", 22, ORidBag.class, new Class[]{ORidBag.class}),
    ANY("Any", 23, null, new Class[0]);

    protected static final OType[] TYPES;
    protected static final OType[] TYPES_BY_ID;
    protected static final Map<Class<?>, OType> TYPES_BY_CLASS;
    protected final String name;
    protected final int id;
    protected final Class<?> javaDefaultType;
    protected final Class<?>[] allowAssignmentFrom;
    protected final Set<OType> castable;

    private OType(String iName, int iId, Class<?> iJavaDefaultType, Class<?>[] iAllowAssignmentBy) {
        this.name = iName;
        this.id = iId;
        this.javaDefaultType = iJavaDefaultType;
        this.allowAssignmentFrom = iAllowAssignmentBy;
        this.castable = new HashSet<OType>();
        this.castable.add(this);
    }

    public static OType getById(byte iId) {
        if (iId >= 0 && iId < TYPES_BY_ID.length) {
            return TYPES_BY_ID[iId];
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public static OType getTypeByClass(Class<?> iClass) {
        if (iClass == null) {
            return null;
        }
        OType type = TYPES_BY_CLASS.get(iClass);
        if (type != null) {
            return type;
        }
        type = OType.getTypeByClassInherit(iClass);
        return type;
    }

    private static OType getTypeByClassInherit(Class<?> iClass) {
        boolean comparedAtLeastOnce;
        if (iClass.isArray()) {
            return EMBEDDEDLIST;
        }
        int priority = 0;
        do {
            comparedAtLeastOnce = false;
            for (OType type : TYPES) {
                if (type.allowAssignmentFrom.length <= priority) continue;
                if (type.allowAssignmentFrom[priority].isAssignableFrom(iClass)) {
                    return type;
                }
                comparedAtLeastOnce = true;
            }
            ++priority;
        } while (comparedAtLeastOnce);
        return null;
    }

    public static OType getTypeByValue(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        OType type = TYPES_BY_CLASS.get(clazz);
        if (type != null) {
            return type;
        }
        OType byType = OType.getTypeByClassInherit(clazz);
        if (LINK == byType) {
            if (value instanceof ODocument && ((ODocument)value).hasOwners()) {
                return EMBEDDED;
            }
        } else if (EMBEDDEDSET == byType) {
            if (OType.checkLinkCollection((Collection)value)) {
                return LINKSET;
            }
        } else if (EMBEDDEDLIST == byType && !clazz.isArray()) {
            if (value instanceof OMultiCollectionIterator) {
                type = ((OMultiCollectionIterator)value).isEmbedded() ? EMBEDDEDLIST : LINKLIST;
            } else if (OType.checkLinkCollection((Collection)value)) {
                return LINKLIST;
            }
        } else if (EMBEDDEDMAP == byType && OType.checkLinkCollection(((Map)value).values())) {
            return LINKMAP;
        }
        return byType;
    }

    private static boolean checkLinkCollection(Collection<?> toCheck) {
        boolean empty = true;
        for (Object object : toCheck) {
            if (object != null && !(object instanceof OIdentifiable)) {
                return false;
            }
            if (object == null) continue;
            empty = false;
        }
        return !empty;
    }

    public static boolean isSimpleType(Object iObject) {
        if (iObject == null) {
            return false;
        }
        Class<?> iType = iObject.getClass();
        return iType.isPrimitive() || Number.class.isAssignableFrom(iType) || String.class.isAssignableFrom(iType) || Boolean.class.isAssignableFrom(iType) || Date.class.isAssignableFrom(iType) || iType.isArray() && (iType.equals(byte[].class) || iType.equals(char[].class) || iType.equals(int[].class) || iType.equals(long[].class) || iType.equals(double[].class) || iType.equals(float[].class) || iType.equals(short[].class) || iType.equals(Integer[].class) || iType.equals(String[].class) || iType.equals(Long[].class) || iType.equals(Short[].class) || iType.equals(Double[].class));
    }

    public static Object convert(Object iValue, Class<?> iTargetClass) {
        if (iValue == null) {
            return null;
        }
        if (iTargetClass == null) {
            return iValue;
        }
        if (iValue.getClass().equals(iTargetClass)) {
            return iValue;
        }
        if (iTargetClass.isAssignableFrom(iValue.getClass())) {
            return iValue;
        }
        try {
            if (iValue instanceof OBinary && iTargetClass.isAssignableFrom(byte[].class)) {
                return ((OBinary)iValue).toByteArray();
            }
            if (byte[].class.isAssignableFrom(iTargetClass)) {
                return OStringSerializerHelper.getBinaryContent(iValue);
            }
            if (byte[].class.isAssignableFrom(iValue.getClass())) {
                return iValue;
            }
            if (iTargetClass.isEnum()) {
                if (iValue instanceof Number) {
                    return ((Enum[])iTargetClass.getEnumConstants())[((Number)iValue).intValue()];
                }
                return Enum.valueOf(iTargetClass, iValue.toString());
            }
            if (iTargetClass.equals(Byte.TYPE) || iTargetClass.equals(Byte.class)) {
                if (iValue instanceof Byte) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Byte.parseByte((String)iValue);
                }
                return ((Number)iValue).byteValue();
            }
            if (iTargetClass.equals(Short.TYPE) || iTargetClass.equals(Short.class)) {
                if (iValue instanceof Short) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Short.parseShort((String)iValue);
                }
                return ((Number)iValue).shortValue();
            }
            if (iTargetClass.equals(Integer.TYPE) || iTargetClass.equals(Integer.class)) {
                if (iValue instanceof Integer) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Integer.parseInt((String)iValue);
                }
                return ((Number)iValue).intValue();
            }
            if (iTargetClass.equals(Long.TYPE) || iTargetClass.equals(Long.class)) {
                if (iValue instanceof Long) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Long.parseLong((String)iValue);
                }
                if (iValue instanceof Date) {
                    return ((Date)iValue).getTime();
                }
                return ((Number)iValue).longValue();
            }
            if (iTargetClass.equals(Float.TYPE) || iTargetClass.equals(Float.class)) {
                if (iValue instanceof Float) {
                    return iValue;
                }
                if (iValue instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)iValue));
                }
                return Float.valueOf(((Number)iValue).floatValue());
            }
            if (iTargetClass.equals(BigDecimal.class)) {
                if (iValue instanceof String) {
                    return new BigDecimal((String)iValue);
                }
                if (iValue instanceof Number) {
                    return new BigDecimal(iValue.toString());
                }
            } else {
                if (iTargetClass.equals(Double.TYPE) || iTargetClass.equals(Double.class)) {
                    if (iValue instanceof Double) {
                        return iValue;
                    }
                    if (iValue instanceof String) {
                        return Double.parseDouble((String)iValue);
                    }
                    if (iValue instanceof Float) {
                        return Double.parseDouble(iValue.toString());
                    }
                    return ((Number)iValue).doubleValue();
                }
                if (iTargetClass.equals(Boolean.TYPE) || iTargetClass.equals(Boolean.class)) {
                    if (iValue instanceof Boolean) {
                        return (boolean)((Boolean)iValue);
                    }
                    if (iValue instanceof String) {
                        if (((String)iValue).equalsIgnoreCase("true")) {
                            return Boolean.TRUE;
                        }
                        if (((String)iValue).equalsIgnoreCase("false")) {
                            return Boolean.FALSE;
                        }
                        throw new IllegalArgumentException("Value is not boolean. Expected true or false but received '" + iValue + "'");
                    }
                    if (iValue instanceof Number) {
                        return ((Number)iValue).intValue() != 0;
                    }
                } else {
                    if (Set.class.isAssignableFrom(iTargetClass)) {
                        if (iValue instanceof Collection) {
                            HashSet set = new HashSet();
                            set.addAll((Collection)iValue);
                            return set;
                        }
                        return Collections.singleton(iValue);
                    }
                    if (List.class.isAssignableFrom(iTargetClass)) {
                        if (iValue instanceof Collection) {
                            ArrayList list = new ArrayList();
                            list.addAll((Collection)iValue);
                            return list;
                        }
                        return Collections.singletonList(iValue);
                    }
                    if (Collection.class.equals(iTargetClass)) {
                        if (iValue instanceof Collection) {
                            ArrayList set = new ArrayList();
                            set.addAll((Collection)iValue);
                            return set;
                        }
                        return Collections.singleton(iValue);
                    }
                    if (iTargetClass.equals(Date.class)) {
                        if (iValue instanceof Number) {
                            return new Date(((Number)iValue).longValue());
                        }
                        if (iValue instanceof String) {
                            if (OIOUtils.isLong(iValue.toString())) {
                                return new Date(Long.parseLong(iValue.toString()));
                            }
                            try {
                                return ODatabaseRecordThreadLocal.instance().get().getStorage().getConfiguration().getDateTimeFormatInstance().parse((String)iValue);
                            }
                            catch (ParseException ignore) {
                                return ODatabaseRecordThreadLocal.instance().get().getStorage().getConfiguration().getDateFormatInstance().parse((String)iValue);
                            }
                        }
                    } else {
                        if (iTargetClass.equals(String.class)) {
                            return iValue.toString();
                        }
                        if (iTargetClass.equals(OIdentifiable.class)) {
                            if (OMultiValue.isMultiValue(iValue)) {
                                ArrayList<OIdentifiable> result = new ArrayList<OIdentifiable>();
                                for (Object o : OMultiValue.getMultiValueIterable(iValue)) {
                                    if (o instanceof OIdentifiable) {
                                        result.add((OIdentifiable)o);
                                        continue;
                                    }
                                    if (!(o instanceof String)) continue;
                                    try {
                                        result.add(new ORecordId(iValue.toString()));
                                    }
                                    catch (Exception e) {
                                        OLogManager.instance().debug(OType.class, "Error in conversion of value '%s' to type '%s'", e, iValue, iTargetClass);
                                    }
                                }
                                return result;
                            }
                            if (iValue instanceof String) {
                                try {
                                    return new ORecordId((String)iValue);
                                }
                                catch (Exception e) {
                                    OLogManager.instance().debug(OType.class, "Error in conversion of value '%s' to type '%s'", e, iValue, iTargetClass);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug(OType.class, "Error in conversion of value '%s' to type '%s'", e, iValue, iTargetClass);
            return null;
        }
        return iValue;
    }

    public static Number increment(Number a, Number b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Cannot increment a null value");
        }
        if (a instanceof Integer) {
            if (b instanceof Integer) {
                int sum = a.intValue() + b.intValue();
                if (sum < 0 && a.intValue() > 0 && b.intValue() > 0) {
                    return new Long(a.intValue() + b.intValue());
                }
                return sum;
            }
            if (b instanceof Long) {
                return new Long((long)a.intValue() + b.longValue());
            }
            if (b instanceof Short) {
                int sum = a.intValue() + b.shortValue();
                if (sum < 0 && a.intValue() > 0 && b.shortValue() > 0) {
                    return new Long(a.intValue() + b.shortValue());
                }
                return sum;
            }
            if (b instanceof Float) {
                return new Float((float)a.intValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)a.intValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.intValue()).add((BigDecimal)b);
            }
        } else if (a instanceof Long) {
            if (b instanceof Integer) {
                return new Long(a.longValue() + (long)b.intValue());
            }
            if (b instanceof Long) {
                return new Long(a.longValue() + b.longValue());
            }
            if (b instanceof Short) {
                return new Long(a.longValue() + (long)b.shortValue());
            }
            if (b instanceof Float) {
                return new Float((float)a.longValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)a.longValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.longValue()).add((BigDecimal)b);
            }
        } else if (a instanceof Short) {
            if (b instanceof Integer) {
                int sum = a.shortValue() + b.intValue();
                if (sum < 0 && a.shortValue() > 0 && b.intValue() > 0) {
                    return new Long(a.shortValue() + b.intValue());
                }
                return sum;
            }
            if (b instanceof Long) {
                return new Long((long)a.shortValue() + b.longValue());
            }
            if (b instanceof Short) {
                int sum = a.shortValue() + b.shortValue();
                if (sum < 0 && a.shortValue() > 0 && b.shortValue() > 0) {
                    return new Integer(a.intValue() + b.intValue());
                }
                return sum;
            }
            if (b instanceof Float) {
                return new Float((float)a.shortValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)a.shortValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.shortValue()).add((BigDecimal)b);
            }
        } else if (a instanceof Float) {
            if (b instanceof Integer) {
                return new Float(a.floatValue() + (float)b.intValue());
            }
            if (b instanceof Long) {
                return new Float(a.floatValue() + (float)b.longValue());
            }
            if (b instanceof Short) {
                return new Float(a.floatValue() + (float)b.shortValue());
            }
            if (b instanceof Float) {
                return new Float(a.floatValue() + b.floatValue());
            }
            if (b instanceof Double) {
                return new Double((double)a.floatValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.floatValue()).add((BigDecimal)b);
            }
        } else if (a instanceof Double) {
            if (b instanceof Integer) {
                return new Double(a.doubleValue() + (double)b.intValue());
            }
            if (b instanceof Long) {
                return new Double(a.doubleValue() + (double)b.longValue());
            }
            if (b instanceof Short) {
                return new Double(a.doubleValue() + (double)b.shortValue());
            }
            if (b instanceof Float) {
                return new Double(a.doubleValue() + (double)b.floatValue());
            }
            if (b instanceof Double) {
                return new Double(a.doubleValue() + b.doubleValue());
            }
            if (b instanceof BigDecimal) {
                return new BigDecimal(a.doubleValue()).add((BigDecimal)b);
            }
        } else if (a instanceof BigDecimal) {
            if (b instanceof Integer) {
                return ((BigDecimal)a).add(new BigDecimal(b.intValue()));
            }
            if (b instanceof Long) {
                return ((BigDecimal)a).add(new BigDecimal(b.longValue()));
            }
            if (b instanceof Short) {
                return ((BigDecimal)a).add(new BigDecimal(b.shortValue()));
            }
            if (b instanceof Float) {
                return ((BigDecimal)a).add(new BigDecimal(b.floatValue()));
            }
            if (b instanceof Double) {
                return ((BigDecimal)a).add(new BigDecimal(b.doubleValue()));
            }
            if (b instanceof BigDecimal) {
                return ((BigDecimal)a).add((BigDecimal)b);
            }
        }
        throw new IllegalArgumentException("Cannot increment value '" + a + "' (" + a.getClass() + ") with '" + b + "' (" + b.getClass() + ")");
    }

    public static Number[] castComparableNumber(Number context, Number max) {
        if (context instanceof Short) {
            if (max instanceof Integer) {
                context = context.intValue();
            } else if (max instanceof Long) {
                context = context.longValue();
            } else if (max instanceof Float) {
                context = Float.valueOf(context.floatValue());
            } else if (max instanceof Double) {
                context = context.doubleValue();
            } else if (max instanceof BigDecimal) {
                context = new BigDecimal(context.intValue());
            } else if (max instanceof Byte) {
                context = context.byteValue();
            }
        } else if (context instanceof Integer) {
            if (max instanceof Long) {
                context = context.longValue();
            } else if (max instanceof Float) {
                context = Float.valueOf(context.floatValue());
            } else if (max instanceof Double) {
                context = context.doubleValue();
            } else if (max instanceof BigDecimal) {
                context = new BigDecimal(context.intValue());
            } else if (max instanceof Short) {
                max = max.intValue();
            } else if (max instanceof Byte) {
                max = max.intValue();
            }
        } else if (context instanceof Long) {
            if (max instanceof Float) {
                context = Float.valueOf(context.floatValue());
            } else if (max instanceof Double) {
                context = context.doubleValue();
            } else if (max instanceof BigDecimal) {
                context = new BigDecimal(context.longValue());
            } else if (max instanceof Integer || max instanceof Byte || max instanceof Short) {
                max = max.longValue();
            }
        } else if (context instanceof Float) {
            if (max instanceof Double) {
                context = context.doubleValue();
            } else if (max instanceof BigDecimal) {
                context = new BigDecimal(context.floatValue());
            } else if (max instanceof Byte || max instanceof Short || max instanceof Integer || max instanceof Long) {
                max = Float.valueOf(max.floatValue());
            }
        } else if (context instanceof Double) {
            if (max instanceof BigDecimal) {
                context = new BigDecimal(context.doubleValue());
            } else if (max instanceof Byte || max instanceof Short || max instanceof Integer || max instanceof Long || max instanceof Float) {
                max = max.doubleValue();
            }
        } else if (context instanceof BigDecimal) {
            if (max instanceof Integer) {
                max = new BigDecimal((Integer)max);
            } else if (max instanceof Float) {
                max = new BigDecimal(((Float)max).floatValue());
            } else if (max instanceof Double) {
                max = new BigDecimal((Double)max);
            } else if (max instanceof Short) {
                max = new BigDecimal(((Short)max).shortValue());
            } else if (max instanceof Byte) {
                max = new BigDecimal(((Byte)max).byteValue());
            }
        } else if (context instanceof Byte) {
            if (max instanceof Short) {
                context = context.shortValue();
            } else if (max instanceof Integer) {
                context = context.intValue();
            } else if (max instanceof Long) {
                context = context.longValue();
            } else if (max instanceof Float) {
                context = Float.valueOf(context.floatValue());
            } else if (max instanceof Double) {
                context = context.doubleValue();
            } else if (max instanceof BigDecimal) {
                context = new BigDecimal(context.intValue());
            }
        }
        return new Number[]{context, max};
    }

    public int asInt(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).intValue();
        }
        if (iValue instanceof String) {
            return Integer.valueOf((String)iValue);
        }
        if (iValue instanceof Boolean) {
            return (Boolean)iValue != false ? 1 : 0;
        }
        throw new IllegalArgumentException("Cannot convert value " + iValue + " to int for type: " + this.name);
    }

    public long asLong(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).longValue();
        }
        if (iValue instanceof String) {
            return Long.valueOf((String)iValue);
        }
        if (iValue instanceof Boolean) {
            return (Boolean)iValue != false ? 1L : 0L;
        }
        throw new IllegalArgumentException("Cannot convert value " + iValue + " to long for type: " + this.name);
    }

    public float asFloat(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).floatValue();
        }
        if (iValue instanceof String) {
            return Float.valueOf((String)iValue).floatValue();
        }
        throw new IllegalArgumentException("Cannot convert value " + iValue + " to float for type: " + this.name);
    }

    public double asDouble(Object iValue) {
        if (iValue instanceof Number) {
            return ((Number)iValue).doubleValue();
        }
        if (iValue instanceof String) {
            return Double.valueOf((String)iValue);
        }
        throw new IllegalArgumentException("Cannot convert value " + iValue + " to double for type: " + this.name);
    }

    @Deprecated
    public String asString(Object iValue) {
        return iValue.toString();
    }

    public boolean isMultiValue() {
        return this == EMBEDDEDLIST || this == EMBEDDEDMAP || this == EMBEDDEDSET || this == LINKLIST || this == LINKMAP || this == LINKSET || this == LINKBAG;
    }

    public boolean isLink() {
        return this == LINK || this == LINKSET || this == LINKLIST || this == LINKMAP || this == LINKBAG;
    }

    public boolean isEmbedded() {
        return this == EMBEDDED || this == EMBEDDEDLIST || this == EMBEDDEDMAP || this == EMBEDDEDSET;
    }

    public Class<?> getDefaultJavaType() {
        return this.javaDefaultType;
    }

    public Set<OType> getCastable() {
        return this.castable;
    }

    @Deprecated
    public Class<?>[] getJavaTypes() {
        return null;
    }

    static {
        TYPES = new OType[]{EMBEDDEDLIST, EMBEDDEDSET, EMBEDDEDMAP, LINK, CUSTOM, EMBEDDED, STRING, DATETIME};
        TYPES_BY_ID = new OType[24];
        TYPES_BY_CLASS = new HashMap();
        OType[] oTypeArray = OType.values();
        int n = oTypeArray.length;
        for (int i = 0; i < n; ++i) {
            OType oType;
            OType.TYPES_BY_ID[oType.id] = oType = oTypeArray[i];
        }
        TYPES_BY_CLASS.put(Boolean.class, BOOLEAN);
        TYPES_BY_CLASS.put(Boolean.TYPE, BOOLEAN);
        TYPES_BY_CLASS.put(Integer.TYPE, INTEGER);
        TYPES_BY_CLASS.put(Integer.class, INTEGER);
        TYPES_BY_CLASS.put(BigInteger.class, INTEGER);
        TYPES_BY_CLASS.put(Short.class, SHORT);
        TYPES_BY_CLASS.put(Short.TYPE, SHORT);
        TYPES_BY_CLASS.put(Long.class, LONG);
        TYPES_BY_CLASS.put(Long.TYPE, LONG);
        TYPES_BY_CLASS.put(Float.TYPE, FLOAT);
        TYPES_BY_CLASS.put(Float.class, FLOAT);
        TYPES_BY_CLASS.put(Double.TYPE, DOUBLE);
        TYPES_BY_CLASS.put(Double.class, DOUBLE);
        TYPES_BY_CLASS.put(Date.class, DATETIME);
        TYPES_BY_CLASS.put(String.class, STRING);
        TYPES_BY_CLASS.put(Enum.class, STRING);
        TYPES_BY_CLASS.put(byte[].class, BINARY);
        TYPES_BY_CLASS.put(Byte.class, BYTE);
        TYPES_BY_CLASS.put(Byte.TYPE, BYTE);
        TYPES_BY_CLASS.put(Character.class, STRING);
        TYPES_BY_CLASS.put(Character.TYPE, STRING);
        TYPES_BY_CLASS.put(ORecordId.class, LINK);
        TYPES_BY_CLASS.put(BigDecimal.class, DECIMAL);
        TYPES_BY_CLASS.put(ORidBag.class, LINKBAG);
        TYPES_BY_CLASS.put(OTrackedSet.class, EMBEDDEDSET);
        TYPES_BY_CLASS.put(ORecordLazySet.class, LINKSET);
        TYPES_BY_CLASS.put(OTrackedList.class, EMBEDDEDLIST);
        TYPES_BY_CLASS.put(ORecordLazyList.class, LINKLIST);
        TYPES_BY_CLASS.put(OTrackedMap.class, EMBEDDEDMAP);
        TYPES_BY_CLASS.put(ORecordLazyMap.class, LINKMAP);
        OType.BYTE.castable.add(BOOLEAN);
        OType.SHORT.castable.addAll(Arrays.asList(BOOLEAN, BYTE));
        OType.INTEGER.castable.addAll(Arrays.asList(BOOLEAN, BYTE, SHORT));
        OType.LONG.castable.addAll(Arrays.asList(BOOLEAN, BYTE, SHORT, INTEGER));
        OType.FLOAT.castable.addAll(Arrays.asList(BOOLEAN, BYTE, SHORT, INTEGER));
        OType.DOUBLE.castable.addAll(Arrays.asList(BOOLEAN, BYTE, SHORT, INTEGER, LONG, FLOAT));
        OType.DECIMAL.castable.addAll(Arrays.asList(BOOLEAN, BYTE, SHORT, INTEGER, LONG, FLOAT, DOUBLE));
        OType.LINKLIST.castable.add(LINKSET);
        OType.EMBEDDEDLIST.castable.add(EMBEDDEDSET);
    }
}

