/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.comparator.OCaseInsentiveComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.collate.ODefaultCollate;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class OPropertyImpl
extends ODocumentWrapperNoClass
implements OProperty {
    protected final OClassImpl owner;
    protected OType linkedType;
    protected OClass linkedClass;
    private transient String linkedClassName;
    protected String description;
    protected boolean mandatory;
    protected boolean notNull = false;
    protected String min;
    protected String max;
    protected String defaultValue;
    protected String regexp;
    protected boolean readonly;
    protected Map<String, String> customFields;
    protected OCollate collate = new ODefaultCollate();
    protected OGlobalProperty globalRef;
    private volatile int hashCode;

    OPropertyImpl(OClassImpl owner) {
        this.document = new ODocument().setTrackingChanges(false);
        this.owner = owner;
    }

    OPropertyImpl(OClassImpl owner, ODocument document) {
        this(owner);
        this.document = document;
    }

    public OPropertyImpl(OClassImpl oClassImpl, OGlobalProperty global) {
        this(oClassImpl);
        this.globalRef = global;
    }

    @Override
    public String getName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.globalRef.getName();
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getFullName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.owner.getName() + "." + this.globalRef.getName();
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public String getFullNameQuoted() {
        this.acquireSchemaReadLock();
        try {
            String string = "`" + this.owner.getName() + "`.`" + this.globalRef.getName() + "`";
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OType getType() {
        this.acquireSchemaReadLock();
        try {
            OType oType = this.globalRef.getType();
            return oType;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int compareTo(OProperty o) {
        this.acquireSchemaReadLock();
        try {
            int n = this.globalRef.getName().compareTo(o.getName());
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OIndex<?> createIndex(OClass.INDEX_TYPE iType) {
        return this.createIndex(iType.toString());
    }

    @Override
    public OIndex<?> createIndex(String iType) {
        this.acquireSchemaReadLock();
        try {
            OIndex<?> oIndex = this.owner.createIndex(this.getFullName(), iType, this.globalRef.getName());
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OIndex<?> createIndex(OClass.INDEX_TYPE iType, ODocument metadata) {
        return this.createIndex(iType.name(), metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<?> createIndex(String iType, ODocument metadata) {
        this.acquireSchemaReadLock();
        try {
            OIndex<?> oIndex = this.owner.createIndex(this.getFullName(), iType, null, metadata, this.globalRef.getName());
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public OPropertyImpl dropIndexes() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            OIndexManager indexManager = this.getDatabase().getMetadata().getIndexManager();
            ArrayList relatedIndexes = new ArrayList();
            for (OIndex<?> oIndex : indexManager.getClassIndexes(this.owner.getName())) {
                OIndexDefinition definition = oIndex.getDefinition();
                if (OCollections.indexOf(definition.getFields(), this.globalRef.getName(), new OCaseInsentiveComparator()) <= -1) continue;
                if (definition instanceof OPropertyIndexDefinition) {
                    relatedIndexes.add(oIndex);
                    continue;
                }
                throw new IllegalArgumentException("This operation applicable only for property indexes. " + oIndex.getName() + " is " + oIndex.getDefinition());
            }
            for (OIndex<Object> oIndex : relatedIndexes) {
                this.getDatabase().getMetadata().getIndexManager().dropIndex(oIndex.getName());
            }
            OPropertyImpl oPropertyImpl = this;
            return oPropertyImpl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Deprecated
    public void dropIndexesInternal() {
        this.dropIndexes();
    }

    @Override
    @Deprecated
    public OIndex<?> getIndex() {
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> indexes = this.owner.getInvolvedIndexes(this.globalRef.getName());
            if (indexes != null && !indexes.isEmpty()) {
                OIndex<?> oIndex = indexes.iterator().next();
                return oIndex;
            }
            OIndex<?> oIndex = null;
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    @Deprecated
    public Set<OIndex<?>> getIndexes() {
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> set = this.owner.getInvolvedIndexes(this.globalRef.getName());
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    @Deprecated
    public boolean isIndexed() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.owner.areIndexed(this.globalRef.getName());
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OClass getOwnerClass() {
        return this.owner;
    }

    @Override
    public OClass getLinkedClass() {
        this.acquireSchemaReadLock();
        try {
            if (this.linkedClass == null && this.linkedClassName != null) {
                this.linkedClass = this.owner.owner.getClass(this.linkedClassName);
            }
            OClass oClass = this.linkedClass;
            return oClass;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    protected static void checkSupportLinkedClass(OType type) {
        if (type != OType.LINK && type != OType.LINKSET && type != OType.LINKLIST && type != OType.LINKMAP && type != OType.EMBEDDED && type != OType.EMBEDDEDSET && type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDMAP && type != OType.LINKBAG) {
            throw new OSchemaException("Linked class is not supported for type: " + (Object)((Object)type));
        }
    }

    @Override
    public OType getLinkedType() {
        this.acquireSchemaReadLock();
        try {
            OType oType = this.linkedType;
            return oType;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    protected static void checkLinkTypeSupport(OType type) {
        if (type != OType.EMBEDDEDSET && type != OType.EMBEDDEDLIST && type != OType.EMBEDDEDMAP) {
            throw new OSchemaException("Linked type is not supported for type: " + (Object)((Object)type));
        }
    }

    @Override
    public boolean isNotNull() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.notNull;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean isMandatory() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.mandatory;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean isReadonly() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.readonly;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getMin() {
        this.acquireSchemaReadLock();
        try {
            String string = this.min;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getMax() {
        this.acquireSchemaReadLock();
        try {
            String string = this.max;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    protected static Object quoteString(String s) {
        if (s == null) {
            return "null";
        }
        String result = "\"" + s.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"") + "\"";
        return result;
    }

    @Override
    public String getDefaultValue() {
        this.acquireSchemaReadLock();
        try {
            String string = this.defaultValue;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getRegexp() {
        this.acquireSchemaReadLock();
        try {
            String string = this.regexp;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getCustom(String iName) {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields == null) {
                String string = null;
                return string;
            }
            String string = this.customFields.get(iName);
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public Map<String, String> getCustomInternal() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Map<String, String> map = Collections.unmodifiableMap(this.customFields);
                return map;
            }
            Map<String, String> map = null;
            return map;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void removeCustom(String iName) {
        this.setCustom(iName, null);
    }

    @Override
    public Set<String> getCustomKeys() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Set<String> set = this.customFields.keySet();
                return set;
            }
            HashSet<String> hashSet = new HashSet<String>();
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Object get(OProperty.ATTRIBUTES attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (attribute) {
            case LINKEDCLASS: {
                return this.getLinkedClass();
            }
            case LINKEDTYPE: {
                return this.getLinkedType();
            }
            case MIN: {
                return this.getMin();
            }
            case MANDATORY: {
                return this.isMandatory();
            }
            case READONLY: {
                return this.isReadonly();
            }
            case MAX: {
                return this.getMax();
            }
            case DEFAULT: {
                return this.getDefaultValue();
            }
            case NAME: {
                return this.getName();
            }
            case NOTNULL: {
                return this.isNotNull();
            }
            case REGEXP: {
                return this.getRegexp();
            }
            case TYPE: {
                return this.getType();
            }
            case COLLATE: {
                return this.getCollate();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)attribute) + "'");
    }

    @Override
    public void set(OProperty.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case LINKEDCLASS: {
                this.setLinkedClass(this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case LINKEDTYPE: {
                if (stringValue == null) {
                    this.setLinkedType(null);
                    break;
                }
                this.setLinkedType(OType.valueOf(stringValue));
                break;
            }
            case MIN: {
                this.setMin(stringValue);
                break;
            }
            case MANDATORY: {
                this.setMandatory(Boolean.parseBoolean(stringValue));
                break;
            }
            case READONLY: {
                this.setReadonly(Boolean.parseBoolean(stringValue));
                break;
            }
            case MAX: {
                this.setMax(stringValue);
                break;
            }
            case DEFAULT: {
                this.setDefaultValue(stringValue);
                break;
            }
            case NAME: {
                this.setName(stringValue);
                break;
            }
            case NOTNULL: {
                this.setNotNull(Boolean.parseBoolean(stringValue));
                break;
            }
            case REGEXP: {
                this.setRegexp(stringValue);
                break;
            }
            case TYPE: {
                this.setType(OType.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
                break;
            }
            case COLLATE: {
                this.setCollate(stringValue);
                break;
            }
            case CUSTOM: {
                int indx;
                int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
                if (indx < 0) {
                    if ("clear".equalsIgnoreCase(stringValue)) {
                        this.clearCustom();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                if (this.isQuoted(customValue)) {
                    customValue = this.removeQuotes(customValue);
                }
                if (customValue.isEmpty()) {
                    this.removeCustom(customName);
                    break;
                }
                this.setCustom(customName, customValue);
                break;
            }
            case DESCRIPTION: {
                this.setDescription(stringValue);
            }
        }
    }

    private String removeQuotes(String s) {
        s = s.trim();
        return s.substring(1, s.length() - 1);
    }

    private boolean isQuoted(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            return true;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("`") && s.endsWith("`");
    }

    @Override
    public OCollate getCollate() {
        this.acquireSchemaReadLock();
        try {
            OCollate oCollate = this.collate;
            return oCollate;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OProperty setCollate(OCollate collate) {
        this.setCollate(collate.getName());
        return this;
    }

    @Override
    public String getDescription() {
        this.acquireSchemaReadLock();
        try {
            String string = this.description;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String toString() {
        this.acquireSchemaReadLock();
        try {
            String string = this.globalRef.getName() + " (type=" + (Object)((Object)this.globalRef.getType()) + ")";
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int hashCode() {
        int sh = this.hashCode;
        if (sh != 0) {
            return sh;
        }
        this.acquireSchemaReadLock();
        try {
            sh = this.hashCode;
            if (sh != 0) {
                int n = sh;
                return n;
            }
            this.calculateHashCode();
            int n = this.hashCode;
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void calculateHashCode() {
        int prime = 31;
        int result = super.hashCode();
        this.hashCode = result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        this.acquireSchemaReadLock();
        try {
            if (this == obj) {
                boolean bl = true;
                return bl;
            }
            if (obj == null || !OProperty.class.isAssignableFrom(obj.getClass())) {
                boolean bl = false;
                return bl;
            }
            OProperty other = (OProperty)obj;
            if (this.owner == null) {
                if (other.getOwnerClass() != null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!this.owner.equals(other.getOwnerClass())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.getName().equals(other.getName());
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void fromStream() {
        Integer globalId;
        String name = (String)this.document.field("name");
        OType type = null;
        if (this.document.field("type") != null) {
            type = OType.getById(((Integer)this.document.field("type")).byteValue());
        }
        if ((globalId = (Integer)this.document.field("globalId")) != null) {
            this.globalRef = this.owner.owner.getGlobalPropertyById(globalId);
        } else {
            if (type == null) {
                type = OType.ANY;
            }
            this.globalRef = this.owner.owner.findOrCreateGlobalProperty(name, type);
        }
        this.mandatory = this.document.containsField("mandatory") ? (Boolean)this.document.field("mandatory") : false;
        this.readonly = this.document.containsField("readonly") ? (Boolean)this.document.field("readonly") : false;
        this.notNull = this.document.containsField("notNull") ? (Boolean)this.document.field("notNull") : false;
        this.defaultValue = this.document.containsField("defaultValue") ? this.document.field("defaultValue") : null;
        if (this.document.containsField("collate")) {
            this.collate = OSQLEngine.getCollate((String)this.document.field("collate"));
        }
        this.min = this.document.containsField("min") ? this.document.field("min") : null;
        this.max = this.document.containsField("max") ? this.document.field("max") : null;
        this.regexp = this.document.containsField("regexp") ? this.document.field("regexp") : null;
        this.linkedClassName = this.document.containsField("linkedClass") ? this.document.field("linkedClass") : null;
        this.linkedType = this.document.field("linkedType") != null ? OType.getById(((Integer)this.document.field("linkedType")).byteValue()) : null;
        this.customFields = this.document.containsField("customFields") ? this.document.field("customFields", OType.EMBEDDEDMAP) : null;
        this.description = this.document.containsField("description") ? this.document.field("description") : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OIndex<?>> getAllIndexes() {
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> indexes = this.owner.getIndexes();
            LinkedList indexList = new LinkedList();
            for (OIndex<?> index : indexes) {
                OIndexDefinition indexDefinition = index.getDefinition();
                if (!indexDefinition.getFields().contains(this.globalRef.getName())) continue;
                indexList.add(index);
            }
            LinkedList<OIndex<?>> linkedList = indexList;
            return linkedList;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.getName());
            this.document.field("type", this.getType().id);
            this.document.field("globalId", this.globalRef.getId());
            this.document.field("mandatory", this.mandatory);
            this.document.field("readonly", this.readonly);
            this.document.field("notNull", this.notNull);
            this.document.field("defaultValue", this.defaultValue);
            this.document.field("min", this.min);
            this.document.field("max", this.max);
            if (this.regexp != null) {
                this.document.field("regexp", this.regexp);
            } else {
                this.document.removeField("regexp");
            }
            if (this.linkedType != null) {
                this.document.field("linkedType", this.linkedType.id);
            }
            if (this.linkedClass != null || this.linkedClassName != null) {
                this.document.field("linkedClass", this.linkedClass != null ? this.linkedClass.getName() : this.linkedClassName);
            }
            this.document.field("customFields", this.customFields != null && this.customFields.size() > 0 ? this.customFields : null, OType.EMBEDDEDMAP);
            if (this.collate != null) {
                this.document.field("collate", this.collate.getName());
            }
            this.document.field("description", this.description);
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    public void acquireSchemaReadLock() {
        this.owner.acquireSchemaReadLock();
    }

    public void releaseSchemaReadLock() {
        this.owner.releaseSchemaReadLock();
    }

    public void acquireSchemaWriteLock() {
        this.owner.acquireSchemaWriteLock();
    }

    public void releaseSchemaWriteLock() {
        this.calculateHashCode();
        this.owner.releaseSchemaWriteLock();
    }

    public void checkEmbedded() {
        if (!(this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage)) {
            throw new OSchemaException("'Internal' schema modification methods can be used only inside of embedded database");
        }
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    protected void checkForDateFormat(String iDateAsString) {
        if (iDateAsString != null) {
            if (this.globalRef.getType() == OType.DATE) {
                try {
                    this.getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(iDateAsString);
                }
                catch (ParseException e) {
                    throw OException.wrapException(new OSchemaException("Invalid date format while formatting date '" + iDateAsString + "'"), e);
                }
            }
            if (this.globalRef.getType() == OType.DATETIME) {
                try {
                    this.getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(iDateAsString);
                }
                catch (ParseException e) {
                    throw OException.wrapException(new OSchemaException("Invalid datetime format while formatting date '" + iDateAsString + "'"), e);
                }
            }
        }
    }

    protected boolean isDistributedCommand() {
        return this.getDatabase().getStorage() instanceof OAutoshardedStorage && !((OAutoshardedStorage)((Object)this.getDatabase().getStorage())).isLocalEnv();
    }

    @Override
    public Integer getId() {
        return this.globalRef.getId();
    }
}

